/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.world.level.block.SBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={LayeredCauldronBlock.class})
public abstract class LayeredCauldronBlockMixin
extends AbstractCauldronBlock {
    public LayeredCauldronBlockMixin(BlockBehaviour.Properties pProperties, CauldronInteraction.InteractionMap pInteractions) {
        super(pProperties, pInteractions);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            this.heatOrCoolCauldron(pState, pLevel, pPos);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            this.heatOrCoolCauldron(pState, pLevel, pPos);
        }
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    public void heatOrCoolCauldron(BlockState pState, Level pLevel, BlockPos cauldronPos) {
        if (pState.getBlock() == Blocks.WATER_CAULDRON && pLevel.getBlockState(cauldronPos.below()).getBlock() instanceof CampfireBlock && ((Boolean)pLevel.getBlockState(cauldronPos.below()).getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            pLevel.setBlockAndUpdate(cauldronPos, (BlockState)SBlocks.PURIFIED_WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)((Integer)pState.getValue((Property)LayeredCauldronBlock.LEVEL))));
        }
        if (!(!ServerConfig.purifiedCauldronRevert || pState.getBlock() != SBlocks.PURIFIED_WATER_CAULDRON || pLevel.getBlockState(cauldronPos.below()).getBlock() instanceof CampfireBlock && ((Boolean)pLevel.getBlockState(cauldronPos.below()).getValue((Property)CampfireBlock.LIT)).booleanValue())) {
            pLevel.setBlockAndUpdate(cauldronPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)((Integer)pState.getValue((Property)LayeredCauldronBlock.LEVEL))));
        }
    }
}

