/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.needs.Stamina;
import com.stereowalker.survive.core.WeightHandler;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.network.protocol.game.ServerboundArmorStaminaPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundRelaxPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundStaminaExhaustionPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.unionlib.api.insert.InsertResultCanceller;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Random;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;

@EventBusSubscriber
public class StaminaData
extends SurviveData
implements Stamina {
    private int longStamina;
    private int shortStamina;
    private int energyReserveLevel = 6;
    private float longExhaustion;
    private float shortExhaustion;
    private int energyTimer;
    private int shortTermTimer;
    private int shortRecoveryTimer;
    private boolean isStraining;
    private int prevEnergyLevel;
    private int maxLongStamina;
    private int maxBurstStamina = 10;

    public StaminaData(double maxStamina) {
        this.longStamina = Mth.floor((double)maxStamina);
        this.prevEnergyLevel = Mth.floor((double)maxStamina);
        this.shortStamina = this.maxBurstStamina;
    }

    public void relax(int energyLevelIn, double maxStamina) {
        int remaining = 0;
        remaining = this.energyReserveLevel + energyLevelIn - 6;
        this.energyReserveLevel = Math.min(energyLevelIn + this.energyReserveLevel, 6);
        if (remaining > 0) {
            this.longStamina = Math.min(remaining + this.longStamina, Mth.floor((double)maxStamina));
        }
    }

    public void eat(Item pItem, ItemStack pStack, LivingEntity entity) {
        if (VersionHelper.VanillaComponents.FOOD.hasData(pStack) && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().getKey((Object)pItem)) && entity instanceof ServerPlayer && !entity.level().isClientSide) {
            ServerPlayer player = (ServerPlayer)entity;
            this.relax(DataMaps.Server.consummableItem.get(RegistryHelper.items().getKey((Object)pItem)).getEnergyAmount(), player.getAttributeValue(SAttributes.MAX_STAMINA.holder()));
        }
    }

    @Override
    public void clientTick(Player player) {
        if (player.isPassenger() && player.tickCount % 400 == 399 && player.getVehicle().getDeltaMovement().x == 0.0 && player.getVehicle().getDeltaMovement().z == 0.0) {
            new ServerboundRelaxPacket(1).send();
        }
        if (player.tickCount % 90 == 89 && player.level().getDifficulty() != Difficulty.PEACEFUL) {
            new ServerboundArmorStaminaPacket().send();
        }
    }

    @Override
    public void tick(Player player) {
        IRealisticEntity realPlayer = (IRealisticEntity)player;
        this.maxLongStamina = Mth.floor((double)player.getAttributeValue(SAttributes.MAX_STAMINA.holder()));
        if (player.isSleeping() && player.level().isDay() && this.longStamina < this.maxLongStamina / 2) {
            player.sleepCounter = 0;
        }
        Difficulty difficulty = player.level().getDifficulty();
        int energyToRegen = 1 + (player.hasEffect(SMobEffects.WELL_FED.holder()) ? new Random().nextInt(2) : 0);
        this.prevEnergyLevel = this.longStamina;
        if (this.longExhaustion > 20.0f) {
            this.longExhaustion -= 20.0f;
            if (difficulty != Difficulty.PEACEFUL) {
                if (this.longStamina > 0) {
                    this.longStamina = Math.max(this.longStamina - 1, 0);
                } else if (this.energyReserveLevel > 0) {
                    this.energyReserveLevel = Math.max(this.energyReserveLevel - 1, 0);
                }
            }
        }
        if (!this.isStraining && this.shortTermTimer > 0) {
            this.isStraining = true;
            this.maxBurstStamina = 10;
            if (Survive.CONFIG.nutrition_enabled) {
                int carb = realPlayer.nutritionData().carbs().level();
                this.maxBurstStamina = carb > 2000 ? Mth.lerpInt((float)((float)(carb - 2000) / 1000.0f), (int)12, (int)20) : (carb > 1000 ? Mth.lerpInt((float)((float)(carb - 1000) / 1000.0f), (int)7, (int)12) : (carb > 0 ? Mth.lerpInt((float)((float)carb / 2000.0f), (int)3, (int)7) : Mth.lerpInt((float)((float)(1000 + carb) / 1000.0f), (int)1, (int)3)));
            }
            this.shortExhaustion = 0.0f;
            this.shortStamina = this.maxBurstStamina;
        } else if (this.isStraining && this.shortTermTimer > 0) {
            --this.shortTermTimer;
            if (this.shortExhaustion > 5.0f) {
                this.shortExhaustion -= 5.0f;
                if (difficulty != Difficulty.PEACEFUL && this.shortStamina > 0) {
                    this.shortStamina = Math.max(this.shortStamina - 1, 0);
                }
            }
            if (this.shortStamina <= 0) {
                this.shortTermTimer = 0;
            }
        } else if (!this.isStraining && this.shortTermTimer <= 0) {
            --this.shortRecoveryTimer;
        } else if (this.isStraining && this.shortTermTimer <= 0) {
            this.isStraining = false;
            this.shortRecoveryTimer = this.maxBurstStamina - this.shortStamina;
            this.addExhaustion((float)this.shortRecoveryTimer * 7.8f, false);
            realPlayer.nutritionData().carbs().remove(this.shortRecoveryTimer * 10);
            this.shortRecoveryTimer *= 13;
            player.addEffect(new MobEffectInstance(SMobEffects.FATIGUE.holder(), this.shortRecoveryTimer, 1, false, true));
        }
        if (this.isTired() && Survive.CONFIG.nutrition_enabled && ((IRealisticEntity)player).nutritionData().fat().level() >= 20) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxLongStamina);
                realPlayer.nutritionData().fat().remove(20);
                this.energyTimer = 0;
            }
        } else if (this.isTired() && !Survive.CONFIG.nutrition_enabled && player.getFoodData().getFoodLevel() > Survive.STAMINA_CONFIG.min_food && WeightHandler.getTotalArmorWeight((LivingEntity)player) / Survive.STAMINA_CONFIG.max_weight < 1.0f) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxLongStamina);
                player.getFoodData().addExhaustion(2.0f);
                this.energyTimer = 0;
            }
        } else if (player.isSleeping()) {
            ++this.energyTimer;
            if ((double)this.energyTimer >= Math.floor((float)Survive.STAMINA_CONFIG.sleepTime / (float)(this.maxLongStamina + 6))) {
                this.relax(energyToRegen, this.maxLongStamina);
                this.energyTimer = 0;
            }
        } else if (this.longStamina <= 0 && this.energyReserveLevel <= 0) {
            ++this.energyTimer;
            if (this.energyTimer >= 20) {
                player.hurt(SDamageSources.source(player.level().registryAccess(), SDamageTypes.OVERWORK), 3.0f);
                this.energyTimer = 0;
            }
        } else {
            this.energyTimer = 0;
        }
        if (difficulty == Difficulty.PEACEFUL && player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && this.isTired() && player.tickCount % 10 == 0) {
            this.setEnergyLevel(this.getLTS() + 1);
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.contains("longStamina", 99)) {
            this.maxBurstStamina = compound.getInt("maxBurstStamina");
            this.maxLongStamina = compound.getInt("maxLongStamina");
            this.longStamina = compound.getInt("longStamina");
            this.longExhaustion = compound.getFloat("longExhaustion");
            this.shortStamina = compound.getInt("shortStamina");
            this.shortExhaustion = compound.getFloat("shortExhaustion");
            this.shortTermTimer = compound.getInt("shortTermTimer");
            this.shortRecoveryTimer = compound.getInt("shortRecoveryTimer");
            this.isStraining = compound.getBoolean("isStraining");
            this.energyTimer = compound.getInt("energyTickTimer");
            this.energyReserveLevel = compound.getInt("energyReserveLevel");
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.putInt("maxBurstStamina", this.maxBurstStamina);
        compound.putInt("maxLongStamina", this.maxLongStamina);
        compound.putInt("longStamina", this.longStamina);
        compound.putInt("shortStamina", this.shortStamina);
        compound.putBoolean("isStraining", this.isStraining);
        compound.putInt("energyReserveLevel", this.energyReserveLevel);
        if (!reducedData) {
            compound.putFloat("shortExhaustion", this.shortExhaustion);
            compound.putFloat("longExhaustion", this.longExhaustion);
            compound.putInt("energyTickTimer", this.energyTimer);
            compound.putInt("shortTermTimer", this.shortTermTimer);
        }
        compound.putInt("shortRecoveryTimer", this.shortRecoveryTimer);
    }

    public int getLTS() {
        return this.longStamina;
    }

    @Override
    public int getBurstStamina() {
        return this.shortStamina;
    }

    public int getSTSRecovery() {
        return this.maxBurstStamina - Mth.floor((float)((float)this.shortRecoveryTimer / 13.0f));
    }

    public boolean isTired() {
        return this.longStamina < this.maxLongStamina;
    }

    public boolean isExerting() {
        return this.isStraining;
    }

    @Override
    public boolean isShortOfBreath() {
        return this.shortRecoveryTimer > 0;
    }

    @Override
    public boolean isDeadTired() {
        return this.longStamina <= 0;
    }

    public void addExhaustion(float exhaustion, boolean strain) {
        if (strain && !this.isShortOfBreath()) {
            this.shortExhaustion = Math.min(this.shortExhaustion + exhaustion, 40.0f);
            this.shortTermTimer = 100;
        } else {
            this.longExhaustion = Math.min(this.longExhaustion + exhaustion, 40.0f);
        }
    }

    public int getReserveLevel() {
        return this.energyReserveLevel;
    }

    public void setEnergyLevel(int energyLevelIn) {
        this.longStamina = energyLevelIn;
    }

    public void setEnergyReserveLevel(int energyReserveLevelIn) {
        this.energyReserveLevel = energyReserveLevelIn;
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.STAMINA_CONFIG.enabled;
    }

    public static void clickItem(Player player, Level level, InteractionHand hand, InsertResultCanceller<InteractionResultHolder<ItemStack>> cancel) {
        if (cancel.wasCancelled() || !(player instanceof Player) || ((InteractionResultHolder)cancel.cancelResult()).getResult().consumesAction()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void rightClickEmpty(PlayerInteractEvent.RightClickEmpty clickItem) {
        if (clickItem.getEntity() instanceof LocalPlayer) {
            new ServerboundStaminaExhaustionPacket(0.3125f).send();
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty clickItem) {
        if (clickItem.getEntity() instanceof LocalPlayer) {
            new ServerboundStaminaExhaustionPacket(0.3125f).send();
        }
    }

    @SubscribeEvent
    public static void replenishEnergyOnSleep(SleepFinishedTimeEvent event) {
        for (Player player : event.getLevel().players()) {
            StaminaData energyStats = ((IRealisticEntity)player).staminaData();
            int staminaToRecover = Mth.ceil((float)((float)(event.getNewTime() - event.getLevel().dayTime()) / (float)Survive.STAMINA_CONFIG.sleepTime * (float)(energyStats.maxLongStamina + 6)));
            energyStats.relax(staminaToRecover, player.getAttributeValue(SAttributes.MAX_STAMINA.holder()));
        }
    }
}

