/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class WellbeingData
extends SurviveData {
    private boolean isWell = true;
    public int timeUntilUnwell = 0;
    public int timeUntilWell = 0;
    public int timeUntilHypothermia;
    public int timeUntilHyperthermia = 6000;
    private int intensity = -1;
    private String reason = "";

    public void setTimer(int min, int max, String reason) {
        if (this.timeUntilUnwell == 0 && this.isWell && this.shouldTick()) {
            this.timeUntilUnwell = min + this.rng.nextInt(max - min);
            this.reason = reason;
        }
    }

    public void setTimer(int min, int max, int intensity, String reason) {
        if (this.timeUntilUnwell == 0 && this.isWell && this.shouldTick()) {
            this.timeUntilUnwell = min + this.rng.nextInt(max - min);
            this.reason = reason;
            this.intensity = intensity;
        }
    }

    @Override
    public void tick(Player player) {
        if (this.timeUntilUnwell > 1 && this.isWell) {
            this.timeUntilWell = 0;
            --this.timeUntilUnwell;
        } else if (this.timeUntilUnwell == 1) {
            int rgn;
            this.timeUntilUnwell = 0;
            this.isWell = false;
            this.timeUntilWell = 6000;
            if (this.intensity == -1) {
                int max = 0;
                for (int i = 1; i <= 9; ++i) {
                    max += i;
                }
                int nte = this.rng.nextInt(max + 1);
                for (int i = 9; i >= 0; --i) {
                    if (nte >= max) {
                        this.intensity = i;
                        break;
                    }
                    max -= 10 - i;
                }
            }
            if ((rgn = this.rng.nextInt(2)) == 0) {
                player.addEffect(new MobEffectInstance(SMobEffects.SLOWNESS_ILLNESS.holder(), this.timeUntilWell, this.intensity));
            } else {
                player.addEffect(new MobEffectInstance(SMobEffects.WEAKNESS_ILLNESS.holder(), this.timeUntilWell, this.intensity));
            }
        } else if (this.timeUntilWell > 1 && !this.isWell) {
            this.timeUntilUnwell = 0;
            --this.timeUntilWell;
        } else if (this.timeUntilWell == 1) {
            this.isWell = true;
            this.timeUntilWell = 0;
            this.reason = "";
            this.intensity = -1;
        }
        if (!Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            double div;
            double maxTemp;
            TemperatureData data = ((IRealisticEntity)player).temperatureData();
            double tempLocation = data.getTemperatureLevel() - 37.0;
            double f = 0.0;
            if (tempLocation > 0.0) {
                maxTemp = 0.0;
                if (player.getAttribute(SAttributes.HEAT_RESISTANCE.holder()) != null) {
                    maxTemp = player.getAttributeValue(SAttributes.HEAT_RESISTANCE.holder());
                }
                div = tempLocation / maxTemp;
                f = Mth.clamp((double)div, (double)0.0, (double)1.4444444444444444);
            }
            if (tempLocation < 0.0) {
                maxTemp = 0.0;
                if (player.getAttribute(SAttributes.COLD_RESISTANCE.holder()) != null) {
                    maxTemp = player.getAttributeValue(SAttributes.COLD_RESISTANCE.holder());
                }
                div = tempLocation / maxTemp;
                f = Mth.clamp((double)div, (double)-1.4444444444444444, (double)0.0);
            }
            this.timeUntilHyperthermia = f > (double)0.7f && !player.hasEffect(SMobEffects.HYPERTHERMIA.holder()) ? --this.timeUntilHyperthermia : 6000;
            this.timeUntilHypothermia = f < (double)-0.7f && !player.hasEffect(SMobEffects.HYPOTHERMIA.holder()) ? --this.timeUntilHypothermia : 6000;
            if (this.timeUntilHyperthermia <= 0 && !player.hasEffect(SMobEffects.HYPERTHERMIA.holder())) {
                player.addEffect(new MobEffectInstance(SMobEffects.HYPERTHERMIA.holder(), 6000));
            }
            if (this.timeUntilHypothermia <= 0 && !player.hasEffect(SMobEffects.HYPOTHERMIA.holder())) {
                player.addEffect(new MobEffectInstance(SMobEffects.HYPOTHERMIA.holder(), 6000));
            }
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.contains("timeUntilUnwell", 99)) {
            this.isWell = compound.getBoolean("isWell");
            this.timeUntilWell = compound.getInt("timeUntilWell");
            this.timeUntilUnwell = compound.getInt("timeUntilUnwell");
            this.timeUntilHypothermia = compound.getInt("timeUntilHypothermia");
            this.timeUntilHyperthermia = compound.getInt("timeUntilHyperthermia");
            this.intensity = compound.getInt("unwellIntensity");
            this.reason = compound.getString("unwellReason");
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.putBoolean("isWell", this.isWell);
        compound.putInt("timeUntilWell", this.timeUntilWell);
        compound.putInt("timeUntilUnwell", this.timeUntilUnwell);
        compound.putInt("timeUntilHypothermia", this.timeUntilHypothermia);
        compound.putInt("timeUntilHyperthermia", this.timeUntilHyperthermia);
        compound.putInt("unwellIntensity", this.intensity);
        compound.putString("unwellReason", this.reason);
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.WELLBEING_CONFIG.enabled;
    }

    public boolean isWell() {
        return this.isWell;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public String getReason() {
        return this.reason;
    }
}

