/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.tags.FluidSTags;
import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.component.SDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EmptyCanteenItem
extends Item {
    boolean isNetherite;

    public EmptyCanteenItem(boolean isNetherite, Item.Properties properties) {
        super(properties);
        this.isNetherite = isNetherite;
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult hitresult = EmptyCanteenItem.getPlayerPOVHitResult((Level)levelIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        int i = Survive.THIRST_CONFIG.canteenFillAmount(this.isNetherite);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = hitresult.getBlockPos();
            if (!levelIn.mayInteract(playerIn, blockpos)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (levelIn.getFluidState(blockpos).is(FluidSTags.PURIFIED_WATER)) {
                levelIn.playSound(playerIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                levelIn.gameEvent((Entity)playerIn, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                return InteractionResultHolder.sidedSuccess((Object)this.turnCanteenIntoItem(itemstack, blockpos, playerIn, CanteenItem.addToCanteen(new ItemStack((ItemLike)SItems.FILLED_CANTEEN), i, (Holder<Potion>)SPotions.PURIFIED_WATER.holder())), (boolean)levelIn.isClientSide());
            }
            if (levelIn.getFluidState(blockpos).is(FluidTags.WATER)) {
                levelIn.playSound(playerIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                levelIn.gameEvent((Entity)playerIn, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                return InteractionResultHolder.sidedSuccess((Object)this.turnCanteenIntoItem(itemstack, blockpos, playerIn, CanteenItem.addToCanteen(new ItemStack((ItemLike)SItems.FILLED_CANTEEN), i, (Holder<Potion>)Potions.WATER)), (boolean)levelIn.isClientSide());
            }
            return InteractionResultHolder.pass((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    protected ItemStack turnCanteenIntoItem(ItemStack canteenStack, BlockPos fillPos, Player pPlayer, ItemStack pFilledBottleStack) {
        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        if (pFilledBottleStack.has(DataComponents.POTION_CONTENTS) && ((PotionContents)pFilledBottleStack.get(DataComponents.POTION_CONTENTS)).potion().get() == Potions.WATER) {
            SDataComponents.BIOME_SOURCE_D.setData(pFilledBottleStack, (Object)((ResourceKey)pPlayer.level().getBiome(fillPos).unwrapKey().get()).location());
        }
        return ItemUtils.createFilledResult((ItemStack)canteenStack, (Player)pPlayer, (ItemStack)pFilledBottleStack);
    }
}

