/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block.entity;

import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.HygieneItems;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.DryingCauldronBlock;
import com.stereowalker.survive.world.level.block.RealisticCampfireBlock;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class DryingCauldronBlockEntity
extends BlockEntity {
    ItemStack result;
    int resultCount;
    int waterContentLeft;

    public DryingCauldronBlockEntity(BlockPos pos, BlockState blockState) {
        super(SBlockEntityType.DRYING_CAULDRON, pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("waterContentLeft", this.waterContentLeft);
        tag.putInt("resultCount", this.resultCount);
        tag.put("result", this.result.save(registries, (Tag)new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.waterContentLeft = tag.getInt("waterContentLeft");
        this.resultCount = tag.getInt("resultCount");
        this.result = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.get("result")).orElse(ItemStack.EMPTY);
    }

    public static int calculateFromTicks(int ticks, int level) {
        return Mth.ceil((float)((float)ticks * 300.0f * ((float)level / 3.0f)));
    }

    public ItemStack getResult() {
        return this.result == null ? ItemStack.EMPTY : this.result.copy();
    }

    public static boolean setResult(Level level, ItemStack item, BlockPos pos, Player player, InteractionHand hand) {
        BlockState state = level.getBlockState(pos);
        if (item.getItem() == HygieneItems.POTASH_SOLUTION) {
            if (!(level.getBlockEntity(pos) instanceof DryingCauldronBlockEntity)) {
                BlockEntity blockEntity;
                if (!level.isClientSide) {
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                    player.awardStat(Stats.FILL_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                    DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.BOTTLE_EMPTY);
                    level.setBlockAndUpdate(pos, SBlocks.DRYING_CAULDRON.defaultBlockState());
                }
                if ((blockEntity = level.getBlockEntity(pos)) instanceof DryingCauldronBlockEntity) {
                    DryingCauldronBlockEntity dbe = (DryingCauldronBlockEntity)blockEntity;
                    dbe.result = new ItemStack((ItemLike)HygieneItems.POTASH);
                    dbe.resultCount = 1;
                    dbe.waterContentLeft = DryingCauldronBlockEntity.calculateFromTicks(72000, 1);
                    return true;
                }
            } else {
                BlockEntity dbe = level.getBlockEntity(pos);
                if (dbe instanceof DryingCauldronBlockEntity) {
                    DryingCauldronBlockEntity dbe2 = (DryingCauldronBlockEntity)dbe;
                    if (dbe2.result.getItem() == HygieneItems.POTASH && (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) < 3) {
                        if (!level.isClientSide) {
                            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                            player.awardStat(Stats.USE_CAULDRON);
                            player.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LayeredCauldronBlock.LEVEL));
                            DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.BOTTLE_EMPTY);
                        }
                        ++dbe2.resultCount;
                        dbe2.waterContentLeft += DryingCauldronBlockEntity.calculateFromTicks(72000, 1);
                        return true;
                    }
                }
            }
        } else if (SDataComponents.BIOME_SOURCE_D.hasData(item) && ((Holder.Reference)((HolderLookup.RegistryLookup)level.registryAccess().lookup(Registries.BIOME).get()).get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)((ResourceLocation)SDataComponents.BIOME_SOURCE_D.getData(item)))).get()).is(BiomeTags.IS_OCEAN)) {
            if (item.getItem() == Items.WATER_BUCKET) {
                if (!(level.getBlockEntity(pos) instanceof DryingCauldronBlockEntity)) {
                    BlockEntity dbe;
                    if (!level.isClientSide) {
                        player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET)));
                        player.awardStat(Stats.FILL_CAULDRON);
                        player.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                        DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.BUCKET_EMPTY);
                        level.setBlockAndUpdate(pos, (BlockState)SBlocks.DRYING_CAULDRON.defaultBlockState().setValue((Property)DryingCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
                    }
                    if ((dbe = level.getBlockEntity(pos)) instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe3 = (DryingCauldronBlockEntity)dbe;
                        dbe3.result = new ItemStack((ItemLike)SItems.SEA_SALT);
                        dbe3.resultCount = 144;
                        dbe3.waterContentLeft = DryingCauldronBlockEntity.calculateFromTicks(192000, 3);
                        dbe3.markUpdated();
                        return true;
                    }
                }
            } else if (item.getItem() == Items.POTION && ((PotionContents)item.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
                if (!(level.getBlockEntity(pos) instanceof DryingCauldronBlockEntity)) {
                    BlockEntity blockEntity;
                    if (!level.isClientSide) {
                        player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                        player.awardStat(Stats.FILL_CAULDRON);
                        player.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                        DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.BOTTLE_EMPTY);
                        level.setBlockAndUpdate(pos, SBlocks.DRYING_CAULDRON.defaultBlockState());
                    }
                    if ((blockEntity = level.getBlockEntity(pos)) instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe = (DryingCauldronBlockEntity)blockEntity;
                        dbe.result = new ItemStack((ItemLike)SItems.SEA_SALT);
                        dbe.resultCount = 48;
                        dbe.waterContentLeft = 19200000;
                        dbe.markUpdated();
                        return true;
                    }
                    System.out.println("NO DBE");
                } else {
                    BlockEntity dbe = level.getBlockEntity(pos);
                    if (dbe instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe4 = (DryingCauldronBlockEntity)dbe;
                        if (dbe4.result.getItem() == SItems.SEA_SALT && (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) < 3) {
                            if (!level.isClientSide) {
                                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                                player.awardStat(Stats.USE_CAULDRON);
                                player.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LayeredCauldronBlock.LEVEL));
                                DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.BOTTLE_EMPTY);
                            }
                            dbe4.resultCount += 48;
                            dbe4.waterContentLeft += 19200000;
                            dbe4.markUpdated();
                            return true;
                        }
                    }
                }
            } else if ((item.getItem() == SItems.FILLED_CANTEEN || item.getItem() == SItems.NETHERITE_CANTEEN) && ((PotionContents)item.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
                if (!(level.getBlockEntity(pos) instanceof DryingCauldronBlockEntity)) {
                    BlockEntity blockEntity;
                    if (!level.isClientSide) {
                        int drinksLeft = (Integer)SDataComponents.DRINKS_LEFT_D.getData(item);
                        if (drinksLeft > 3) {
                            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)CanteenItem.addToCanteen(item.copy(), drinksLeft - 3, (PotionContents)item.get(DataComponents.POTION_CONTENTS))));
                        } else {
                            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)(item.getItem() == SItems.FILLED_NETHERITE_CANTEEN ? SItems.NETHERITE_CANTEEN : SItems.CANTEEN))));
                        }
                        player.awardStat(Stats.FILL_CAULDRON);
                        player.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                        DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.BOTTLE_EMPTY);
                        level.setBlockAndUpdate(pos, (BlockState)SBlocks.DRYING_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(Math.min(drinksLeft, 3))));
                    }
                    if ((blockEntity = level.getBlockEntity(pos)) instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe = (DryingCauldronBlockEntity)blockEntity;
                        dbe.result = new ItemStack((ItemLike)SItems.SEA_SALT);
                        dbe.resultCount = 48;
                        dbe.waterContentLeft = 19200000;
                        dbe.markUpdated();
                        return true;
                    }
                    System.out.println("NO DBE");
                } else {
                    BlockEntity dbe = level.getBlockEntity(pos);
                    if (dbe instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe5 = (DryingCauldronBlockEntity)dbe;
                        if (dbe5.result.getItem() == SItems.SEA_SALT && (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) < 3) {
                            if (!level.isClientSide) {
                                int cauldronLevelToFill = 3 - (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                                int drinksLeft = (Integer)SDataComponents.DRINKS_LEFT_D.getData(item);
                                if (drinksLeft > cauldronLevelToFill) {
                                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)CanteenItem.addToCanteen(item.copy(), drinksLeft - cauldronLevelToFill, (PotionContents)item.get(DataComponents.POTION_CONTENTS))));
                                } else {
                                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)(item.getItem() == SItems.FILLED_NETHERITE_CANTEEN ? SItems.NETHERITE_CANTEEN : SItems.CANTEEN))));
                                }
                                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                                player.awardStat(Stats.USE_CAULDRON);
                                player.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                                level.setBlockAndUpdate(pos, (BlockState)SBlocks.DRYING_CAULDRON.defaultBlockState().setValue((Property)DryingCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
                                DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.BOTTLE_EMPTY);
                            }
                            dbe5.resultCount += 48;
                            dbe5.waterContentLeft += 19200000;
                            dbe5.markUpdated();
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void updateItem(Level level, BlockPos pos, SoundEvent sound) {
        level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
    }

    public void tick(ServerLevel level, BlockState state) {
        int combinedPower;
        BlockState blockBelow;
        BlockState initialState = state;
        if (this.result.getItem() == SItems.SEA_SALT) {
            state = (BlockState)state.setValue(DryingCauldronBlock.FLUID, (Comparable)((Object)DryingCauldronBlock.FluidToDry.SEA_SALT));
        } else if (this.result.getItem() == HygieneItems.POTASH) {
            state = (BlockState)state.setValue(DryingCauldronBlock.FLUID, (Comparable)((Object)DryingCauldronBlock.FluidToDry.POTASH));
        }
        int sunPower = 0;
        int camfirePower = 0;
        BlockPos above = this.worldPosition.above();
        boolean flag = level.isRainingAt(above);
        if (level.isDay() && !level.isClientSide) {
            float f = this.getBrightness(level, above);
            if (!flag && level.canSeeSky(above)) {
                sunPower = Mth.ceil((float)(f * 0.6666667f));
            }
        }
        if (flag) {
            sunPower -= 20;
        }
        if (((Boolean)(blockBelow = level.getBlockState(this.worldPosition.below())).getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            if (blockBelow.getBlock() == Blocks.CAMPFIRE) {
                camfirePower = 50;
            } else if (blockBelow.getBlock() == Blocks.SOUL_CAMPFIRE) {
                camfirePower = 70;
            } else if (blockBelow.getBlock() == SBlocks.REALISTIC_CAMPFIRE) {
                camfirePower = (Integer)blockBelow.getValue((Property)RealisticCampfireBlock.HEAT) * 75;
            }
        }
        if ((combinedPower = sunPower + camfirePower) > 0) {
            this.waterContentLeft -= combinedPower;
            this.markUpdated();
        }
        state = (BlockState)state.setValue((Property)DryingCauldronBlock.BOILING, (Comparable)Integer.valueOf(Mth.clamp((int)Mth.ceil((float)((float)combinedPower / 31.0f)), (int)0, (int)10)));
        if (this.waterContentLeft <= 0) {
            this.result.setCount(this.resultCount);
            level.addFreshEntity((Entity)new ItemEntity((Level)level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, this.result.copyAndClear(), 0.0, 0.0, 0.0));
            level.setBlockAndUpdate(this.worldPosition, Blocks.CAULDRON.defaultBlockState());
        } else if (this.result.getItem() == SItems.SEA_SALT) {
            if (this.waterContentLeft <= DryingCauldronBlockEntity.calculateFromTicks(192000, 2) && (Integer)state.getValue((Property)DryingCauldronBlock.LEVEL) == 3) {
                state = (BlockState)state.setValue((Property)DryingCauldronBlock.LEVEL, (Comparable)Integer.valueOf(2));
            } else if (this.waterContentLeft <= DryingCauldronBlockEntity.calculateFromTicks(192000, 1) && (Integer)state.getValue((Property)DryingCauldronBlock.LEVEL) == 2) {
                state = (BlockState)state.setValue((Property)DryingCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1));
            }
        }
        if (initialState != state) {
            level.setBlock(this.worldPosition, state, 3);
            DryingCauldronBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)state);
            this.markUpdated();
        }
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public float getBrightness(ServerLevel level, BlockPos pos) {
        return level.hasChunkAt(pos) ? (float)level.getBrightness(LightLayer.SKY, pos) : 0.0f;
    }
}

