/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.google.gson.JsonObject;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class OnFireCondition
extends TemperatureChangeCondition<Instance> {
    @Override
    public Instance createInstance(JsonObject object) {
        float temperatureIn = 0.0f;
        int fireTimerIn = 0;
        String operationIn = "";
        if (object.has("temperature") && object.get("temperature").isJsonPrimitive()) {
            temperatureIn = object.get("temperature").getAsFloat();
        }
        if (object.has("fireTimer") && object.get("fireTimer").isJsonPrimitive()) {
            fireTimerIn = object.get("fireTimer").getAsInt();
        }
        if (object.has("operation") && object.get("operation").isJsonPrimitive()) {
            operationIn = object.get("operation").getAsString();
        }
        return new Instance(temperatureIn, fireTimerIn, operationIn);
    }

    @Override
    public Instance createInstance(CompoundTag nbt) {
        float temperatureIn = nbt.getFloat("temperature");
        int fireTimerIn = nbt.getInt("fireTimer");
        String operationIn = nbt.getString("operation");
        return new Instance(temperatureIn, fireTimerIn, operationIn);
    }

    static class Instance
    extends TemperatureChangeInstance {
        private int fireTimer;
        private String operation;

        public Instance(float temperatureIn, int fireTimerIn, String operationIn) {
            super(temperatureIn);
            this.fireTimer = fireTimerIn;
            this.operation = operationIn;
        }

        @Override
        public boolean shouldChangeTemperature(Player player) {
            if (player.isOnFire()) {
                if (this.fireTimer > 0) {
                    if (this.operation.equals("=")) {
                        return player.getRemainingFireTicks() == this.fireTimer;
                    }
                    if (this.operation.equals(">=")) {
                        return player.getRemainingFireTicks() >= this.fireTimer;
                    }
                    if (this.operation.equals("<=")) {
                        return player.getRemainingFireTicks() <= this.fireTimer;
                    }
                    if (this.operation.equals(">")) {
                        return player.getRemainingFireTicks() > this.fireTimer;
                    }
                    if (this.operation.equals("<")) {
                        return player.getRemainingFireTicks() < this.fireTimer;
                    }
                    return player.getRemainingFireTicks() < this.fireTimer;
                }
                return true;
            }
            return false;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.putFloat("temperature", this.getTemperature());
            nbt.putInt("fireTimer", this.fireTimer);
            nbt.putString("operation", this.operation);
            return nbt;
        }

        @Override
        public Component getAdditionalContext() {
            if (this.fireTimer > 0) {
                return Component.translatable((String)"temperature_context.on_fire", (Object[])new Object[]{this.operation.equals("") ? "<" : this.operation, this.fireTimer});
            }
            return Component.translatable((String)"temperature_context.on_fire_no_timer");
        }
    }
}

