/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.client.events.TooltipEvents;
import com.stereowalker.survive.client.gui.screens.inventory.SaltBoxScreen;
import com.stereowalker.survive.client.particle.HygieneParticle;
import com.stereowalker.survive.core.TempDisplayMode;
import com.stereowalker.survive.core.particles.SParticleTypes;
import com.stereowalker.survive.hooks.ColdMenu;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.IRoastedEntity;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.inventory.SMenuType;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.DryingCauldronBlock;
import com.stereowalker.survive.world.level.block.PlatedTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.material.SFluids;
import com.stereowalker.unionlib.api.collectors.ColorOverrideCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.MenuCollector;
import com.stereowalker.unionlib.api.collectors.OverlayCollector;
import com.stereowalker.unionlib.api.collectors.ParticleCollector;
import com.stereowalker.unionlib.api.collectors.RenderLayerCollector;
import com.stereowalker.unionlib.api.gui.GuiRenderer;
import com.stereowalker.unionlib.client.gui.screens.config.MinecraftModConfigsScreen;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.ScreenHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.Color;
import java.util.Random;
import net.minecraft.class_1163;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7225;
import net.minecraft.class_757;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableInt;

public class SurviveClientSegment
extends ClientSegment {
    public static final class_2960 GUI_ICONS = VersionHelper.toLoc((String)"survive", (String)"textures/gui/icons.png");
    public static float maxContainerCoolness;

    public class_2960 getModIcon() {
        return VersionHelper.toLoc((String)"survive", (String)"textures/icon.png");
    }

    public class_437 getConfigScreen(class_310 mc, class_437 previousScreen) {
        return new MinecraftModConfigsScreen(previousScreen, (class_2561)class_2561.method_43471((String)"gui.survive.config.title"), new ConfigObject[]{Survive.TEMPERATURE_CONFIG, Survive.HYGIENE_CONFIG, Survive.STAMINA_CONFIG, Survive.THIRST_CONFIG, Survive.WELLBEING_CONFIG, Survive.FOOD_CONFIG, Survive.CONFIG});
    }

    public void setupParticles(ParticleCollector collector) {
        collector.addFactory((class_2396)SParticleTypes.STINK, HygieneParticle.StinkFactory::new);
        collector.addFactory((class_2396)SParticleTypes.CLEAN, HygieneParticle.CleanFactory::new);
    }

    public void setupRenderLayers(RenderLayerCollector collector) {
        class_1921 frendertype = class_1921.method_23583();
        collector.setFluidRenderLayer(frendertype, new class_3611[]{SFluids.PURIFIED_WATER, SFluids.FLOWING_PURIFIED_WATER});
        class_1921 cutout = class_1921.method_23581();
        collector.setBlockRenderLayer(cutout, new class_2248[]{SBlocks.REALISTIC_CAMPFIRE});
    }

    public void setupColorOverrides(ColorOverrideCollector collector) {
        collector.overrideBlocks((state, displayReader, blockPos, tintIndex) -> -12463112, new class_2248[]{SBlocks.PURIFIED_WATER, SBlocks.PURIFIED_WATER_CAULDRON});
        collector.overrideBlocks((state, displayReader, blockPos, tintIndex) -> {
            if (state.method_11654(DryingCauldronBlock.FLUID) == DryingCauldronBlock.FluidToDry.POTASH) {
                return Color.parse((String)"0x483c35").brighter((float)((Integer)state.method_11654((class_2769)DryingCauldronBlock.BOILING)).intValue() * 0.12f).toIntRGB();
            }
            if (state.method_11654(DryingCauldronBlock.FLUID) == DryingCauldronBlock.FluidToDry.SEA_SALT) {
                return Color.fromIntRGB((int)class_1163.method_4961((class_1920)displayReader, (class_2338)blockPos)).brighter((float)((Integer)state.method_11654((class_2769)DryingCauldronBlock.BOILING)).intValue() * 0.12f).toIntRGB();
            }
            return new Color(1.0f, 0.0f, 0.0f).brighter((float)((Integer)state.method_11654((class_2769)DryingCauldronBlock.BOILING)).intValue() * 0.12f).toIntRGB();
        }, new class_2248[]{SBlocks.DRYING_CAULDRON});
        collector.overrideBlocks((state, displayReader, blockPos, tintIndex) -> PlatedTemperatureRegulatorBlock.getColor(state).toIntRGB(), new class_2248[]{SBlocks.PLATED_TEMPERATURE_REGULATOR});
        collector.overrideItems((stack, tintIndex) -> {
            class_1844 contents = (class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
            return tintIndex > 0 ? -1 : (contents.method_57401(SPotions.PURIFIED_WATER.holder()) ? -12463112 : class_5253.class_5254.method_57174((int)contents.method_8064()));
        }, new class_1792[]{class_1802.field_8574, class_1802.field_8436, class_1802.field_8150});
        collector.overrideItems((stack, tintIndex) -> TemperatureRegulatorPlateItem.getColor(stack).toIntARGB(), new class_1792[]{SItems.LARGE_HEATING_PLATE, SItems.LARGE_COOLING_PLATE, SItems.MEDIUM_HEATING_PLATE, SItems.MEDIUM_COOLING_PLATE, SItems.SMALL_HEATING_PLATE, SItems.SMALL_COOLING_PLATE});
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)ClientInserts.SCREEN_RENDER_FINISH, insert -> {
            ColdMenu cold;
            float progress;
            class_465 cont;
            class_1703 patt1$temp;
            class_437 patt0$temp = insert.screen();
            if (patt0$temp instanceof class_465 && (patt1$temp = (cont = (class_465)patt0$temp).method_17577()) instanceof ColdMenu && (progress = (float)(cold = (ColdMenu)patt1$temp).coldness() / (float)cold.maxColdness()) > 0.0f) {
                int i = (cont.field_22789 - cont.field_2792) / 2 + 9;
                int j = (cont.field_22790 - cont.field_2779) / 2;
                if (cont instanceof class_476) {
                    class_476 c = (class_476)cont;
                    j += c.field_2864 * 18;
                }
                insert.guiRenderer().blit(VersionHelper.toLoc((String)"survive:textures/gui/coldness.png"), i, (j += 96) + 17, 0, 0, 158, 22);
                int i1 = 142;
                int j1 = class_3532.method_15386((float)(progress * 142.0f));
                insert.guiRenderer().blit(VersionHelper.toLoc((String)"survive:textures/gui/coldness.png"), i + 8, j + 17 + 4, 0, 30, j1, 10);
            }
        });
        collector.addInsert((InsertHandler)ClientInserts.ITEM_TOOLTIP, insert -> {
            if (insert.player() != null) {
                boolean showWeight = false;
                boolean showTemp = false;
                if (Survive.STAMINA_CONFIG.enabled && Survive.STAMINA_CONFIG.enable_weights || Survive.TEMPERATURE_CONFIG.enabled) {
                    for (class_1304 type : class_1304.values()) {
                        if (!LoaderHelper.canEquip((class_1309)insert.player(), (class_1799)insert.itemStack(), (class_1304)type) || type.method_5925() != class_1304.class_1305.field_6178) continue;
                        showWeight = Survive.STAMINA_CONFIG.enabled && Survive.STAMINA_CONFIG.enable_weights;
                        showTemp = Survive.TEMPERATURE_CONFIG.enabled;
                        break;
                    }
                }
                if (showWeight || showTemp) {
                    TooltipEvents.accessoryTooltip(insert.player(), insert.itemStack(), insert.tooltips(), showWeight, showTemp);
                }
                FoodUtils.applyFoodStatusToTooltip(insert.player(), insert.itemStack(), insert.tooltips());
                if (SDataComponents.BIOME_SOURCE_D.hasData(insert.itemStack()) && ((class_6880.class_6883)((class_7225.class_7226)insert.player().method_37908().method_30349().method_46759(class_7924.field_41236).get()).method_46746(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)((class_2960)SDataComponents.BIOME_SOURCE_D.getData(insert.itemStack())))).get()).method_40220(class_6908.field_36509)) {
                    insert.tooltips().add(class_2561.method_43471((String)"Sea Water"));
                }
            }
        });
    }

    public void setupGuiOverlays(OverlayCollector collector) {
        MutableInt rightHeight = new MutableInt(49);
        collector.register("reset", OverlayCollector.Order.END, (gui, renderer, width, height) -> rightHeight.setValue(49));
        collector.register("thirst_level", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            boolean isMounted = gui.field_2035.field_1724.method_5854() instanceof class_1309;
            if (Survive.THIRST_CONFIG.enabled && !isMounted && !gui.field_2035.field_1690.field_1842 && gui.field_2035.field_1761.method_2908()) {
                int left = width / 2 + 91;
                int top = height - rightHeight.intValue();
                SurviveClientSegment.renderThirst(gui, renderer, left, top, true);
                rightHeight.add(10);
            }
        });
        collector.register("stamina_level", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            boolean isMounted = gui.field_2035.field_1724.method_5854() instanceof class_1309;
            if (Survive.STAMINA_CONFIG.enabled && !isMounted && !gui.field_2035.field_1690.field_1842 && gui.field_2035.field_1761.method_2908()) {
                int left = width / 2 + 91;
                int top = height - rightHeight.intValue();
                SurviveClientSegment.renderEnergyBars(gui, renderer, rightHeight, left, top, true);
            }
        });
        collector.register("tired", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            if (Survive.CONFIG.tired_overlay && gui.field_2035.field_1724.method_6059(SMobEffects.TIREDNESS.holder())) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(class_757::method_34542);
                SurviveClientSegment.renderTiredOverlay(gui, renderer);
            }
        });
        collector.register("heat_stroke", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            SurviveClientSegment.renderHeatStroke(gui, renderer);
        });
        collector.register("temperature", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            if (!gui.field_2035.field_1690.field_1842 && Survive.TEMPERATURE_CONFIG.enabled && !Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.HOTBAR)) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(class_757::method_34542);
                SurviveClientSegment.renderTemperature(gui, ScreenHelper.ScreenOffset.TOP, gui.method_1737(), renderer, true);
            }
        });
        collector.register("nutrition", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            class_1657 patt0$temp = gui.method_1737();
            if (patt0$temp instanceof IRealisticEntity) {
                IRealisticEntity real = (IRealisticEntity)patt0$temp;
                if (Survive.CONFIG.nutrition_enabled && (VersionHelper.VanillaComponents.FOOD.hasData(gui.method_1737().method_6047()) || VersionHelper.VanillaComponents.FOOD.hasData(gui.method_1737().method_6079()) || Survive.CONFIG.always_render_nut)) {
                    ScreenHelper.ScreenOffset position = Survive.CONFIG.nut_offset;
                    int x = ScreenHelper.getXOffset((ScreenHelper.ScreenOffset)position, (class_310)gui.field_2035) + Survive.CONFIG.nut_xLoc;
                    int y = ScreenHelper.getYOffset((ScreenHelper.ScreenOffset)position, (class_310)gui.field_2035) + Survive.CONFIG.nut_yLoc;
                    if (Survive.CONFIG.show_raw_nut_vals) {
                        renderer.drawString("Carbs = " + real.nutritionData().carbs().level(), x, y, class_124.field_1080.method_532().intValue(), false);
                        renderer.drawString("Protein = " + real.nutritionData().protein().level(), x, y + 10, class_124.field_1080.method_532().intValue(), false);
                        renderer.drawString("Fats = " + real.nutritionData().fat().level(), x, y + 20, class_124.field_1080.method_532().intValue(), false);
                    } else {
                        renderer.blit(GUI_ICONS, x + 7, y + 2, 194, 22, 62, 5);
                        renderer.blit(GUI_ICONS, x + 8, y + 3, 195, 28, class_3532.method_15375((float)((float)real.nutritionData().carbs().level() / 50.0f)), 3);
                        renderer.blit(GUI_ICONS, x + 0, y + 0, 246, 11, 9, 9);
                        renderer.blit(GUI_ICONS, x + 7, y + 12, 194, 32, 62, 5);
                        renderer.blit(GUI_ICONS, x + 8, y + 13, 195, 38, class_3532.method_15375((float)((float)real.nutritionData().protein().level() / 50.0f)), 3);
                        renderer.blit(GUI_ICONS, x + 0, y + 10, 226, 1, 9, 9);
                        renderer.blit(GUI_ICONS, x + 7, y + 22, 194, 42, 62, 5);
                        renderer.blit(GUI_ICONS, x + 8, y + 23, 195, 48, class_3532.method_15375((float)((float)real.nutritionData().fat().level() / 50.0f)), 3);
                        renderer.blit(GUI_ICONS, x + 0, y + 20, 236, 11, 9, 9);
                    }
                }
            }
        });
    }

    public static void renderTemperature(class_329 gui, ScreenHelper.ScreenOffset position, class_1657 playerentity, GuiRenderer renderer, boolean forgeOverlay) {
        int x = ScreenHelper.getXOffset((ScreenHelper.ScreenOffset)position, (class_310)gui.field_2035) + Survive.TEMPERATURE_CONFIG.tempXLoc;
        int y = ScreenHelper.getYOffset((ScreenHelper.ScreenOffset)position, (class_310)gui.field_2035) + Survive.TEMPERATURE_CONFIG.tempYLoc;
        class_310.method_1551().method_16011().method_15396("temperature");
        double displayTemp = ((IRealisticEntity)playerentity).temperatureData().getDisplayTemperature();
        String s = ((IRealisticEntity)playerentity).temperatureData().getCelcius() + " \u00b0C";
        if (class_310.method_1551().field_1761.method_2913()) {
            if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.HORIZONTAL_BAR)) {
                if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp >= 1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 79, 138, 11);
                } else if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp <= -1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 90, 138, 11);
                } else {
                    renderer.blit(GUI_ICONS, x, y, 3, 64, 132, 5);
                    renderer.blit(GUI_ICONS, x, y, 3, 69, 132, 5);
                }
                renderer.blit(GUI_ICONS, x + class_3532.method_15357((double)(displayTemp * 44.0)) + 63 + (displayTemp > 0.0 ? 1 : 0), y, 1, 74, 4, 5);
            } else if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.VERTICAL_BAR)) {
                if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp >= 1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 11, 101, 11, 138);
                } else if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp <= -1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 101, 11, 138);
                } else {
                    renderer.blit(GUI_ICONS, x, y, 32, 104, 5, 132);
                    renderer.blit(GUI_ICONS, x, y, 27, 104, 5, 132);
                }
                renderer.blit(GUI_ICONS, x, y - class_3532.method_15357((double)(displayTemp * 44.0)) + 63 - (displayTemp > 0.0 ? 1 : 0), 22, 104, 5, 5);
            } else if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.NUMBERS)) {
                if (Survive.TEMPERATURE_CONFIG.displayTempInFahrenheit) {
                    s = ((IRealisticEntity)playerentity).temperatureData().getFahrenheit() + " \u00b0F";
                }
                if (displayTemp >= 1.0) {
                    renderer.drawString(s, x, y, class_124.field_1065.method_532().intValue(), false);
                } else if (displayTemp <= -1.0) {
                    renderer.drawString(s, x, y, class_124.field_1078.method_532().intValue(), false);
                } else {
                    renderer.drawString(s, x, y, class_124.field_1080.method_532().intValue(), false);
                }
            }
        }
        class_310.method_1551().method_16011().method_15407();
    }

    public static void renderHeatStroke(class_329 gui, GuiRenderer renderer) {
        if (((IRoastedEntity)gui.field_2035.field_1724).getTicksRoasted() > 0) {
            gui.method_31977(renderer.guiGraphics(), Survive.getInstance().location("textures/misc/burning_overlay.png"), ((IRoastedEntity)gui.field_2035.field_1724).getPercentRoasted());
        }
    }

    public static void renderTiredOverlay(class_329 gui, GuiRenderer graphics) {
        class_310.method_1551().method_16011().method_15396("tired");
        int amplifier = class_310.method_1551().field_1724.method_6112(SMobEffects.TIREDNESS.holder()).method_5578() + 1;
        amplifier /= Survive.CONFIG.tiredTimeStacks / 5;
        amplifier = class_3532.method_15340((int)amplifier, (int)0, (int)4);
        gui.method_31977(graphics.guiGraphics(), Survive.getInstance().location("textures/misc/sleep_overlay_" + amplifier + ".png"), 0.5f);
        class_310.method_1551().method_16011().method_15407();
    }

    public static void renderThirst(class_329 gui, GuiRenderer graphics, int j1, int k1, boolean forgeOverlay) {
        class_1657 player = (class_1657)gui.field_2035.method_1560();
        IRealisticEntity realisticPlayer = (IRealisticEntity)player;
        int waterL = realisticPlayer.waterData().getWaterLevel();
        gui.field_2035.method_16011().method_15396("thirst");
        for (int k6 = 0; k6 < 10; ++k6) {
            int i7 = k1;
            int k7 = 16;
            int i8 = 0;
            if (player.method_6059(SMobEffects.THIRST.holder())) {
                k7 += 36;
                i8 = 13;
            }
            if (realisticPlayer.waterData().getHydrationLevel() <= 0.0f && gui.field_2042 % (waterL * 3 + 1) == 0) {
                i7 = k1 + (gui.field_2034.method_43048(3) - 1);
            }
            int k8 = j1 - k6 * 8 - 9;
            graphics.blit(GUI_ICONS, k8, i7, 16 + i8 * 9, 54, 9, 9);
            if (k6 * 2 + 1 < waterL) {
                graphics.blit(GUI_ICONS, k8, i7, k7 + 36, 54, 9, 9);
            }
            if (k6 * 2 + 1 != waterL) continue;
            graphics.blit(GUI_ICONS, k8, i7, k7 + 45, 54, 9, 9);
        }
        gui.field_2035.method_16011().method_15407();
    }

    public static void renderEnergyBars(class_329 gui, GuiRenderer graphics, MutableInt moveUp, int j1, int k1, boolean forgeOverlay) {
        int k7;
        int i7;
        int k6;
        int i;
        Random rand = new Random();
        class_1657 player = (class_1657)gui.field_2035.method_1560();
        IRealisticEntity real = (IRealisticEntity)player;
        float maxStamina = (float)player.method_45325(SAttributes.MAX_STAMINA.holder());
        int l = real.staminaData().getLTS();
        if (real.staminaData().isDeadTired()) {
            l = real.staminaData().getReserveLevel();
        }
        class_310.method_1551().method_16011().method_15396("energy");
        if (!forgeOverlay) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)GUI_ICONS);
        }
        int[] i9 = new int[30];
        for (i = 0; i < 30; ++i) {
            i9[i] = k1 + (rand.nextInt(3) - 1);
        }
        for (i = 0; i < class_3532.method_15386((float)(maxStamina / 20.0f)); ++i) {
            for (k6 = 0; k6 < 10; ++k6) {
                i7 = k1;
                k7 = 16;
                int i8 = 0;
                if (real.staminaData().isDeadTired()) {
                    k7 += 36;
                    i8 = 13;
                }
                if ((float)real.staminaData().getLTS() <= 10.0f && gui.method_1738() % (l * 3 + 1) == 0) {
                    i7 = i9[i];
                }
                int k8 = j1 - k6 * 8 - 9;
                if (k6 * 2 + 1 + 20 * i < class_3532.method_15375((float)maxStamina) + 1) {
                    graphics.blit(GUI_ICONS, k8, i7, 16 + i8 * 9, 36, 9, 9);
                }
                if (k6 * 2 + 1 + 20 * i < l) {
                    graphics.blit(GUI_ICONS, k8, i7, k7 + 36, 36, 9, 9);
                }
                if (k6 * 2 + 1 + 20 * i != l) continue;
                graphics.blit(GUI_ICONS, k8, i7, k7 + 45, 36, 9, 9);
            }
            moveUp.add(10);
        }
        if (real.staminaData().isExerting() || real.staminaData().isShortOfBreath()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            l = real.staminaData().isShortOfBreath() ? real.staminaData().getSTSRecovery() : real.staminaData().getBurstStamina();
            for (i = 0; i < class_3532.method_15386((float)(maxStamina / 20.0f)); ++i) {
                for (k6 = 0; k6 < 10; ++k6) {
                    i7 = k1;
                    k7 = 16;
                    if (real.staminaData().isShortOfBreath()) {
                        k7 += 36;
                    }
                    if ((float)real.staminaData().getLTS() <= 10.0f && gui.method_1738() % (l * 3 + 1) == 0) {
                        i7 = i9[i];
                    }
                    int k8 = j1 - k6 * 8 - 9;
                    if (k6 * 2 + 1 + 20 * i < l) {
                        graphics.blit(GUI_ICONS, k8, i7, k7 + 36, 27, 9, 9);
                    }
                    if (k6 * 2 + 1 + 20 * i != l) continue;
                    graphics.blit(GUI_ICONS, k8, i7, k7 + 45, 27, 9, 9);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        class_310.method_1551().method_16011().method_15407();
    }

    public void setupMenus(MenuCollector collector) {
        collector.addMenu(SMenuType.SALT_BOX, SaltBoxScreen::new);
    }
}

