/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.events;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.compat.SereneSeasonsCompat;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.core.TempMode;
import com.stereowalker.survive.events.TempEvents;
import com.stereowalker.survive.json.EntityTemperatureJsonHolder;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.survive.network.protocol.game.ClientboundDataTransferPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundSurvivalStatsPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.item.enchantment.SEnchantmentHelper;
import com.stereowalker.survive.world.seasons.Season;
import com.stereowalker.survive.world.temperature.TemperatureModifier;
import com.stereowalker.survive.world.temperature.TemperatureQuery;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.UnionMathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableInt;

public class SurviveEvents {
    private static final List<Offset> SPHERE_OFFSETS_RANGE_2 = SurviveEvents.buildSphereOffsets(2);
    private static final List<Offset> SPHERE_OFFSETS_RANGE_5 = SurviveEvents.buildSphereOffsets(5);
    private static final List<Offset> SPHERE_OFFSETS_RANGE_6 = SurviveEvents.buildSphereOffsets(6);

    public static void desyncClient(class_1657 player) {
        if (!player.method_37908().field_9236 && DataMaps.Server.syncedClients.containsKey(player.method_5667())) {
            Survive.getInstance().getLogger().info("Removing Client (" + player.method_5476().getString() + ") From Survive Data Sync List");
            DataMaps.Server.syncedClients.put(player.method_5667(), false);
        }
    }

    public static void sendToClient(class_1309 living) {
        if (living != null && !living.method_37908().field_9236 && living instanceof class_3222) {
            class_3222 player = (class_3222)living;
            new ClientboundSurvivalStatsPacket(player, true).send(player);
            new ClientboundSurvivalStatsPacket(player, false).send(player);
            if (!DataMaps.Server.syncedClients.containsKey(player.method_5667())) {
                DataMaps.Server.syncedClients.put(player.method_5667(), false);
            }
            if (!DataMaps.Server.syncedClients.get(player.method_5667()).booleanValue()) {
                Survive.getInstance().getLogger().info("Syncing All Data To Client (" + player.method_5476().getString() + ")");
                Survive.getInstance().getLogger().info("Syncing Armor Data");
                MutableInt a = new MutableInt(0);
                DataMaps.Server.armor.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((class_2960)key, (JsonHolder)value, a.getValue() == 0).send(player);
                    a.increment();
                });
                Survive.getInstance().getLogger().info("Done with Armors");
                Survive.getInstance().getLogger().info("Syncing Fluid Data");
                MutableInt f = new MutableInt(0);
                DataMaps.Server.fluid.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((class_2960)key, (JsonHolder)value, f.getValue() == 0).send(player);
                    f.increment();
                });
                Survive.getInstance().getLogger().info("Done with Fluids");
                Survive.getInstance().getLogger().info("Syncing Biome Data");
                MutableInt i = new MutableInt(0);
                DataMaps.Server.biome.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((class_2960)key, (JsonHolder)value, i.getValue() == 0).send(player);
                    i.increment();
                });
                Survive.getInstance().getLogger().info("Done with Biomes");
                Survive.getInstance().getLogger().info("Syncing Consummable Data");
                MutableInt c = new MutableInt(0);
                DataMaps.Server.consummableItem.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((class_2960)key, (JsonHolder)value, c.getValue() == 0).send(player);
                    c.increment();
                });
                Survive.getInstance().getLogger().info("Done with Consummables");
                DataMaps.Server.syncedClients.put(player.method_5667(), true);
            }
        }
    }

    public static boolean isSnowingAt(class_1937 world, class_2338 position) {
        if (!world.method_8419()) {
            return false;
        }
        if (!world.method_8311(position)) {
            return false;
        }
        if (world.method_8598(class_2902.class_2903.field_13197, position).method_10264() > position.method_10264()) {
            return false;
        }
        class_1959 biome = (class_1959)world.method_23753(position).comp_349();
        return biome.method_48162(position) == class_1959.class_1963.field_9383 || biome.method_21740(position) <= 0.15f || ModHelper.isPrimalWinterLoaded() || ModHelper.isSereneSeasonsLoaded() && SereneSeasonsCompat.snowsHere(world, position);
    }

    public static void updateEnvTemperature(class_1309 living) {
        class_3222 player;
        if (living != null && living instanceof class_3222) {
            player = (class_3222)living;
            if (!living.method_37908().field_9236) {
                SurviveEntityStats.addWetTime((class_1309)player, player.method_5869() ? 2 : (player.method_5721() ? 1 : -2));
            }
        }
        if (living != null && living instanceof class_3222 && (player = (class_3222)living).method_5805()) {
            for (class_2960 queryId : TemperatureQuery.queries.keySet()) {
                double queryValue = ((TemperatureQuery)TemperatureQuery.queries.get(queryId).method_15442()).run((class_1657)player, ((IRealisticEntity)player).temperatureData().getTemperatureLevel(), player.method_37908(), player.method_24515(), true);
                TemperatureData.setTemperatureModifier((class_1309)player, queryId, queryValue, (TemperatureModifier.ContributingFactor)((Object)TemperatureQuery.queries.get(queryId).method_15441()));
            }
        }
        if (living instanceof class_1657) {
            player = (class_1657)living;
            FoodUtils.giveLifespanToFood((class_2371<class_1799>)player.method_31548().field_7547, player.method_37908().method_8510());
            for (class_1923 chunk : TempEvents.GLOBAL_BLOCK_TEMPS.keySet()) {
                if (player.method_37908().method_8393(chunk.field_9181, chunk.field_9180)) continue;
                TempEvents.discardChunk(chunk);
                TempEvents.log("Discarding Chunks " + String.valueOf(chunk));
            }
        }
    }

    public static float getModifierFromSlot(class_1304 slot) {
        switch (slot) {
            case field_6169: {
                return 0.05f;
            }
            case field_6174: {
                return 0.16f;
            }
            case field_6172: {
                return 0.13f;
            }
            case field_6166: {
                return 0.06f;
            }
        }
        return 0.0f;
    }

    private static List<class_2338> getNeighbors(class_2338 pos) {
        return Lists.newArrayList((Object[])new class_2338[]{pos.method_10084(), pos.method_10074(), pos.method_10095(), pos.method_10072(), pos.method_10067(), pos.method_10078()});
    }

    private static double getBlockTransmissionCost(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (!state.method_26227().method_15769() && !state.method_26227().method_40181().toList().contains(class_3486.field_15518)) {
            return 1.2f;
        }
        if (state.method_51367()) {
            return 5.0;
        }
        return 1.0;
    }

    public static double getEffectiveDistance(class_1937 level, class_2338 startPos, class_2338 target, double maxCost) {
        if (startPos.equals((Object)target)) {
            return 0.0;
        }
        PriorityQueue<PathNode> queue = new PriorityQueue<PathNode>(Comparator.comparingDouble(node -> node.cost));
        HashMap<class_2338, Double> bestCosts = new HashMap<class_2338, Double>();
        bestCosts.put(startPos, 0.0);
        queue.add(new PathNode(startPos, 0.0));
        while (!queue.isEmpty()) {
            PathNode current = queue.poll();
            if (current.pos.equals((Object)target)) {
                return current.cost;
            }
            if (current.cost > maxCost) continue;
            for (class_2338 neighbor : SurviveEvents.getNeighbors(current.pos)) {
                double costToEnter = SurviveEvents.getBlockTransmissionCost(level, neighbor);
                double newCost = current.cost + costToEnter;
                if (!(newCost < bestCosts.getOrDefault(neighbor, Double.POSITIVE_INFINITY))) continue;
                bestCosts.put(neighbor, newCost);
                queue.add(new PathNode(neighbor, newCost));
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    private static List<Offset> buildSphereOffsets(int rangeInBlocks) {
        ArrayList<Offset> finalList = new ArrayList<Offset>();
        for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
            for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                    if (x * x + y * y + z * z > rangeInBlocks * rangeInBlocks) continue;
                    finalList.add(new Offset(x, y, z));
                }
            }
        }
        return Collections.unmodifiableList(finalList);
    }

    public static double getExactTemperature(class_1937 world, class_2338 pos, TempType type) {
        float skyLight = world.method_8398().method_12130().method_15562(class_1944.field_9284).method_15543(pos);
        float gameTime = world.method_8532() % 24000L;
        gameTime /= 66.0f;
        gameTime = (float)Math.sin(Math.toRadians(gameTime));
        switch (type.ordinal()) {
            case 4: {
                float sunIntensity = 5.0f;
                if (world.method_23753(pos).method_40230().isPresent() && DataMaps.Server.biome.containsKey(((class_5321)world.method_23753(pos).method_40230().get()).method_29177())) {
                    sunIntensity = DataMaps.Server.biome.get(((class_5321)world.method_23753(pos).method_40230().get()).method_29177()).getSunIntensity();
                }
                if (skyLight > 5.0f) {
                    return gameTime * sunIntensity;
                }
                return -1.0f * sunIntensity;
            }
            case 0: {
                float biomeTemp = TemperatureUtil.getTemperature((class_6880<class_1959>)world.method_23753(pos), pos) * 2.0f - 2.0f;
                if (ModHelper.isPrimalWinterLoaded()) {
                    biomeTemp = -0.7f;
                }
                return biomeTemp;
            }
            case 1: {
                return TempEvents.tempOrCache(pos, SPHERE_OFFSETS_RANGE_2, SPHERE_OFFSETS_RANGE_5, offsets -> {
                    float totalBlockTemp = 0.0f;
                    int rangeInBlocks = 5;
                    for (Offset offset : offsets) {
                        float sourceRange;
                        float blockTemp = 0.0f;
                        class_2338 heatSource = new class_2338(pos.method_10263() + offset.dx, pos.method_10264() + offset.dy, pos.method_10260() + offset.dz);
                        float blockLight = world.method_8398().method_12130().method_15562(class_1944.field_9282).method_15543(heatSource);
                        class_2680 heatState = world.method_8320(heatSource);
                        if (heatState.method_26204() instanceof TemperatureEmitter) {
                            sourceRange = ((TemperatureEmitter)heatState.method_26204()).getModificationRange(heatState);
                        } else {
                            float f = sourceRange = DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().method_10221((Object)heatState.method_26204())) ? (float)DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().method_10221((Object)heatState.method_26204())).getRange() : 5.0f;
                        }
                        if (!pos.method_19771((class_2382)heatSource, (double)sourceRange)) continue;
                        blockTemp += blockLight / 500.0f;
                        if (heatState.method_26204() instanceof TemperatureEmitter) {
                            blockTemp = ((TemperatureEmitter)heatState.method_26204()).getTemperatureModification(heatState);
                        } else if (TempEvents.STATE_CACHE.containsKey(heatState)) {
                            blockTemp += TempEvents.STATE_CACHE.get(heatState).tempModifier();
                        }
                        boolean doDistanceCalculation = true;
                        if (doDistanceCalculation) {
                            double effectiveDistance = SurviveEvents.getEffectiveDistance(world, heatSource, pos, rangeInBlocks);
                            if (!(effectiveDistance <= (double)rangeInBlocks)) continue;
                            totalBlockTemp = (float)((double)totalBlockTemp + (double)blockTemp * (1.0 - effectiveDistance / (double)rangeInBlocks));
                            continue;
                        }
                        totalBlockTemp += blockTemp;
                    }
                    return Float.valueOf(totalBlockTemp);
                });
            }
            case 3: {
                return skyLight / 7.5f - 1.0f;
            }
            case 2: {
                float totalEntityTemp = 0.0f;
                int rangeInBlocks = 5;
                for (class_1297 entity : world.method_18467(class_1297.class, class_238.method_54784((class_2338)pos.method_10069(rangeInBlocks, rangeInBlocks, rangeInBlocks), (class_2338)pos.method_10069(-rangeInBlocks, -rangeInBlocks, -rangeInBlocks)))) {
                    float sourceRange;
                    float f = sourceRange = DataMaps.Server.entityTemperature.containsKey(RegistryHelper.entityTypes().method_10221((Object)entity.method_5864())) ? DataMaps.Server.entityTemperature.get(RegistryHelper.entityTypes().method_10221((Object)entity.method_5864())).getRange() : 5.0f;
                    if (!pos.method_19771((class_2382)entity.method_24515(), (double)sourceRange) || !DataMaps.Server.entityTemperature.containsKey(RegistryHelper.entityTypes().method_10221((Object)entity.method_5864()))) continue;
                    EntityTemperatureJsonHolder entityTemperatureData = DataMaps.Server.entityTemperature.get(RegistryHelper.entityTypes().method_10221((Object)entity.method_5864()));
                    totalEntityTemp += entityTemperatureData.getTemperatureModifier();
                }
                return totalEntityTemp;
            }
        }
        return 37.0;
    }

    public static double getBlendedTemperature(class_1937 world, class_2338 mainPos, class_2338 blendPos, TempType type) {
        float distance = (float)Math.sqrt(mainPos.method_10262((class_2382)blendPos));
        if ((double)distance <= 5.0) {
            float blendRatio0 = distance / 5.0f;
            float blendRatio1 = 1.0f - blendRatio0;
            double temp0 = SurviveEvents.getExactTemperature(world, blendPos, type);
            double temp1 = SurviveEvents.getExactTemperature(world, mainPos, type);
            return temp0 * (double)blendRatio0 + temp1 * (double)blendRatio1;
        }
        return SurviveEvents.getExactTemperature(world, mainPos, type);
    }

    public static float getAverageTemperature(class_1937 world, class_2338 pos, TempType type, int rangeInBlocks, TempMode mode) {
        float temp = 0.0f;
        int tempAmount = 0;
        for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
            for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                    if (mode == TempMode.BLEND) {
                        temp = (float)((double)temp + SurviveEvents.getBlendedTemperature(world, new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z), pos, type));
                    } else if (mode == TempMode.NORMAL) {
                        temp = (float)((double)temp + SurviveEvents.getExactTemperature(world, new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z), type));
                    }
                    ++tempAmount;
                }
            }
        }
        return temp / (float)tempAmount;
    }

    protected static class_3965 getPlayerPOVHitResult(class_1937 pLevel, class_1657 pPlayer, class_3959.class_242 pFluidMode) {
        class_243 vec3 = pPlayer.method_33571();
        class_243 vec31 = vec3.method_1019(pPlayer.method_5631(pPlayer.method_36455(), pPlayer.method_36454()).method_1021(pPlayer.method_55754()));
        return pLevel.method_17742(new class_3959(vec3, vec31, class_3959.class_3960.field_17559, pFluidMode, (class_1297)pPlayer));
    }

    public static void restoreStats(class_1657 thisPlayer, class_1657 thatPlayer, boolean keepEverything) {
        SurviveEntityStats.getOrCreateModNBT((class_1297)thisPlayer);
        if (keepEverything) {
            IRealisticEntity entity = (IRealisticEntity)thisPlayer;
            IRealisticEntity original = (IRealisticEntity)thatPlayer;
            entity.setTemperatureData(original.temperatureData());
            entity.setNutritionData(original.nutritionData());
            entity.setWellbeingData(original.wellbeingData());
            entity.setHygieneData(original.hygieneData());
            entity.setStaminaData(original.staminaData());
            entity.setSleepData(original.sleepData());
            entity.setWaterData(original.waterData());
            SurviveEntityStats.setWetTime((class_1309)thisPlayer, SurviveEntityStats.getWetTime((class_1309)thatPlayer));
        }
    }

    public static void addReload(class_1936 lvl) {
        TempEvents.buildStateCache();
        Survive.getInstance().getLogger().info("Start Resistering Temperature Queries");
        for (TempType type : TempType.values()) {
            TemperatureQuery.registerQuery("survive:" + type.getName(), TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
                double temperature = type.isUsingExact() ? SurviveEvents.getExactTemperature(level, pos, type) : (double)SurviveEvents.getAverageTemperature(level, pos, type, 5, Survive.TEMPERATURE_CONFIG.tempMode);
                return UnionMathHelper.roundDecimal((int)3, (double)(temperature / type.getReductionAmount()));
            });
        }
        TemperatureQuery.registerQuery("survive:snow", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            double snow = 0.0;
            if (SurviveEvents.isSnowingAt(level, pos)) {
                snow = -2.0;
            }
            return snow;
        });
        TemperatureQuery.registerQuery("survive:season", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            float seasonMod = 0.0f;
            if (ModHelper.isSereneSeasonsLoaded()) {
                Season season = SereneSeasonsCompat.modifyTemperatureBySeason(level, pos);
                seasonMod = level.method_23753(pos).method_40230().isPresent() && DataMaps.Server.biome.containsKey(((class_5321)level.method_23753(pos).method_40230().get()).method_29177()) ? DataMaps.Server.biome.get(((class_5321)level.method_23753(pos).method_40230().get()).method_29177()).getSeasonModifiers().get(season).floatValue() : season.getModifier();
                if (ModHelper.isPrimalWinterLoaded()) {
                    seasonMod = -1.0f;
                }
            }
            return seasonMod;
        });
        TemperatureQuery.registerQuery("survive:dimension", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            for (String dimensionList : ServerConfig.dimensionModifiers) {
                String[] dimension = dimensionList.split(",");
                class_2960 loc = VersionHelper.toLoc((String)dimension[0]);
                if (!RegistryHelper.matchesRegistryKey((class_2960)loc, (class_5321)level.method_27983())) continue;
                return Float.parseFloat(dimension[1]);
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:wetness", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (level.method_23753(pos).method_40230().isPresent() && DataMaps.Server.biome.containsKey(((class_5321)level.method_23753(pos).method_40230().get()).method_29177())) {
                float f = DataMaps.Server.biome.get(((class_5321)level.method_23753(pos).method_40230().get()).method_29177()).getWetnessModifier();
                return (double)SurviveEntityStats.getWetTime((class_1309)player) / -1800.0 * (double)f;
            }
            return (double)SurviveEntityStats.getWetTime((class_1309)player) / -1800.0;
        });
        TemperatureQuery.registerQuery("survive:cooling_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double coolingMod = 0.0;
            coolingMod -= 0.05 * (double)SEnchantmentHelper.getCoolingModifier(player.method_6118(class_1304.field_6169));
            coolingMod -= 0.16 * (double)SEnchantmentHelper.getCoolingModifier(player.method_6118(class_1304.field_6174));
            coolingMod -= 0.13 * (double)SEnchantmentHelper.getCoolingModifier(player.method_6118(class_1304.field_6172));
            return coolingMod -= 0.06 * (double)SEnchantmentHelper.getCoolingModifier(player.method_6118(class_1304.field_6166));
        });
        TemperatureQuery.registerQuery("survive:warming_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double warmingMod = 0.0;
            warmingMod += 0.05 * (double)SEnchantmentHelper.getWarmingModifier(player.method_6118(class_1304.field_6169));
            warmingMod += 0.16 * (double)SEnchantmentHelper.getWarmingModifier(player.method_6118(class_1304.field_6174));
            warmingMod += 0.13 * (double)SEnchantmentHelper.getWarmingModifier(player.method_6118(class_1304.field_6172));
            return warmingMod += 0.06 * (double)SEnchantmentHelper.getWarmingModifier(player.method_6118(class_1304.field_6166));
        });
        TemperatureQuery.registerQuery("survive:thirst_cooldown", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (((IRealisticEntity)player).waterData().shouldTempDrop()) {
                if (applyTemp) {
                    ((IRealisticEntity)player).waterData().applyTempDrop(player);
                }
                return 1.0;
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:adjusted_cooling_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (temp > 37.0) {
                for (class_1304 types : class_1304.values()) {
                    if (!SEnchantmentHelper.hasAdjustedCooling(player.method_6118(types))) continue;
                    return 2.0;
                }
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:adjusted_warming_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (temp < 37.0) {
                for (class_1304 types : class_1304.values()) {
                    if (!SEnchantmentHelper.hasAdjustedWarming(player.method_6118(types))) continue;
                    return 2.0;
                }
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:fats", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            IRealisticEntity real = (IRealisticEntity)player;
            if (Survive.CONFIG.nutrition_enabled && temp < (37.0 + TemperatureUtil.firstCold(player)) / 2.0) {
                if (real.nutritionData().fat().level() > 2500) {
                    real.nutritionData().fat().remove(3);
                    return 6.0;
                }
                if (real.nutritionData().fat().level() > 1500) {
                    real.nutritionData().fat().remove(2);
                    return 3.0;
                }
                if (real.nutritionData().fat().level() > 500) {
                    real.nutritionData().fat().remove(1);
                    return 1.0;
                }
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:armor", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double armorMod = 0.0;
            for (class_1304 slot : class_1304.values()) {
                if (slot.method_5925() != class_1304.class_1305.field_6178 || player.method_6118(slot).method_7960()) continue;
                class_1792 armor = player.method_6118(slot).method_7909();
                float modifier = 1.0f;
                if (DataMaps.Server.armor.containsKey(RegistryHelper.items().method_10221((Object)armor))) {
                    for (Pair<String, TemperatureChangeInstance> instance : DataMaps.Server.armor.get(RegistryHelper.items().method_10221((Object)armor)).getTemperatureModifier()) {
                        if (!((TemperatureChangeInstance)instance.getSecond()).shouldChangeTemperature(player)) continue;
                        modifier = ((TemperatureChangeInstance)instance.getSecond()).getTemperature();
                        break;
                    }
                }
                armorMod += (double)(SurviveEvents.getModifierFromSlot(slot) * modifier);
            }
            return armorMod;
        });
        TemperatureQuery.registerQuery("survive:chilled_effect", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.method_6059(SMobEffects.CHILLED.holder())) {
                return -(0.05f * (float)(player.method_6112(SMobEffects.CHILLED.holder()).method_5578() + 1));
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:heated_effect", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.method_6059(SMobEffects.HEATED.holder())) {
                return 0.05f * (float)(player.method_6112(SMobEffects.HEATED.holder()).method_5578() + 1);
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:main_held_item", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.method_6047().method_7909() == class_1802.field_8810 && DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().method_10221((Object)class_2246.field_10336))) {
                return DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().method_10221((Object)class_2246.field_10336)).getTemperatureModifier();
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:off_held_item", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.method_6079().method_7909() == class_1802.field_8810 && DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().method_10221((Object)class_2246.field_10336))) {
                return DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().method_10221((Object)class_2246.field_10336)).getTemperatureModifier();
            }
            return 0.0;
        });
        System.out.println("Done Resistering Temperature Queries");
    }

    private record PathNode(class_2338 pos, double cost) {
    }

    private record Offset(int dx, int dy, int dz) {
    }

    private static enum TempType {
        BIOME("biome", 6.0, false),
        BLOCK("block", 8.0, true),
        ENTITY("entity", 9.0, true),
        SHADE("shade", 200.0, true),
        SUN("sun", 200.0, true);

        String name;
        double reductionAmount;
        boolean usingExact;

        private TempType(String name, double reductionAmountIn, boolean usingExactIn) {
            this.reductionAmount = reductionAmountIn;
            this.usingExact = usingExactIn;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public double getReductionAmount() {
            return this.reductionAmount;
        }

        public boolean isUsingExact() {
            return this.usingExact;
        }
    }
}

