/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.events;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.IBlockPropertyHandler;
import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TempEvents {
    public static final Map<class_1923, Map<class_2338, Float>> GLOBAL_BLOCK_TEMPS = new ConcurrentHashMap<class_1923, Map<class_2338, Float>>();
    public static final Map<class_2338, Float> INVALID_PRE_COMPUTED_TEMPS = new ConcurrentHashMap<class_2338, Float>();
    private static ExecutorService ex = null;
    public static Logger logger = LogManager.getLogger((String)"TempEvents");
    protected static final Map<class_2680, TempData> STATE_CACHE = new ConcurrentHashMap<class_2680, TempData>();
    protected static final Queue<Function<?, ?>> TO_PROCESS = new LinkedList();

    public static void serverStart(MinecraftServer server) {
        if (ex == null || ex.isShutdown() || ex.isTerminated()) {
            ex = Executors.newSingleThreadExecutor();
        }
    }

    public static void serverStop(MinecraftServer server) {
        ex.shutdown();
        TO_PROCESS.clear();
        GLOBAL_BLOCK_TEMPS.clear();
    }

    public static void log(String m) {
        if (LoaderHelper.isDevEnvironment()) {
            logger.info(m);
        }
    }

    public static void discardChunk(class_1923 chunk) {
        GLOBAL_BLOCK_TEMPS.remove(chunk);
    }

    public static void invalidateBlockTemp(class_2338 block) {
        int rangeInBlocks = 5;
        for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
            for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                    class_2338 heatSource = new class_2338(block.method_10263() + x, block.method_10264() + y, block.method_10260() + z);
                    class_1923 chunk = new class_1923(heatSource);
                    if (!GLOBAL_BLOCK_TEMPS.containsKey(chunk) || !GLOBAL_BLOCK_TEMPS.get(chunk).containsKey(TempEvents.local(chunk, heatSource))) continue;
                    INVALID_PRE_COMPUTED_TEMPS.put(heatSource, GLOBAL_BLOCK_TEMPS.get(chunk).remove(TempEvents.local(chunk, heatSource)));
                }
            }
        }
    }

    public static class_2338 local(class_1923 chunk, class_2338 block) {
        return new class_2338(block.method_10263() - chunk.field_9181 * 16, block.method_10264(), block.method_10260() - chunk.field_9180 * 16);
    }

    public static void cacheTemp(class_2338 block, float temp) {
        class_1923 chunk = new class_1923(block);
        GLOBAL_BLOCK_TEMPS.computeIfAbsent(chunk, k -> new ConcurrentHashMap());
        GLOBAL_BLOCK_TEMPS.get(chunk).put(TempEvents.local(chunk, block), Float.valueOf(temp));
    }

    public static <T> float tempOrCache(class_2338 block, T quick, T full, Function<T, Float> calc) {
        class_1923 chunk = new class_1923(block);
        float temp = calc.apply(quick).floatValue();
        if (GLOBAL_BLOCK_TEMPS.containsKey(chunk) && GLOBAL_BLOCK_TEMPS.get(chunk).containsKey(TempEvents.local(chunk, block))) {
            temp = GLOBAL_BLOCK_TEMPS.get(chunk).get(TempEvents.local(chunk, block)).floatValue();
            return temp;
        }
        if (INVALID_PRE_COMPUTED_TEMPS.containsKey(block)) {
            temp = INVALID_PRE_COMPUTED_TEMPS.remove(block).floatValue();
        }
        TempEvents.cacheTemp(block, temp);
        TO_PROCESS.add(calc);
        ex.submit(() -> {
            while (TO_PROCESS.size() > 5) {
                TO_PROCESS.remove();
            }
            if (TO_PROCESS.size() > 0) {
                long start = System.nanoTime();
                TempEvents.cacheTemp(block, ((Float)TO_PROCESS.remove().apply(full)).floatValue());
                long l = System.nanoTime();
            }
        });
        return temp;
    }

    public static void buildStateCache() {
        Survive.getInstance().getLogger().info("Started Building BlockState temp cache");
        long start = System.nanoTime();
        STATE_CACHE.clear();
        for (class_2248 block : RegistryHelper.blocks()) {
            for (class_2680 state : block.method_9595().method_11662()) {
                if (state.method_26204() instanceof TemperatureEmitter) continue;
                STATE_CACHE.put(state, TempEvents.computeTempDataFor(state));
            }
        }
        long end = System.nanoTime();
        Survive.getInstance().getLogger().info("Finished Building BlockState temp cache in " + (double)(end - start) / 1000000.0 + "ms");
    }

    private static TempData computeTempDataFor(class_2680 heatState) {
        float blockTemp = 0.0f;
        if (DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().method_10221((Object)heatState.method_26204()))) {
            BlockTemperatureJsonHolder blockTemperatureData = DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().method_10221((Object)heatState.method_26204()));
            if (blockTemperatureData.getStateChangeProperty() != null) {
                boolean setTemp = false;
                heatState.method_26204().method_9595().method_11662();
                List<Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>>> changeProperty = blockTemperatureData.getStateChangeProperty();
                block0: for (Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>> handler : changeProperty) {
                    boolean meets = true;
                    for (IBlockPropertyHandler.PropertyPair requirements : (List)handler.getMiddle()) {
                        if (heatState.method_11654((class_2769)requirements.getFirst()).equals(requirements.getSecond())) continue;
                        meets = false;
                        break;
                    }
                    if (!meets) continue;
                    for (String prop2 : ((Map)handler.getRight()).keySet()) {
                        class_2769 property = null;
                        for (class_2769 p : heatState.method_28501()) {
                            if (!p.equals(((IBlockPropertyHandler)handler.getLeft()).derivedProperty())) continue;
                            property = p;
                            break;
                        }
                        if (property == null) {
                            logger.error("Could not find property {} in block {}", ((IBlockPropertyHandler)handler.getLeft()).derivedProperty(), (Object)heatState);
                            continue;
                        }
                        if (!heatState.method_11654(property).equals(((IBlockPropertyHandler)handler.getLeft()).getValue(prop2))) continue;
                        blockTemp += ((Float)((Map)handler.getRight()).get(prop2)).floatValue();
                        setTemp = true;
                        break block0;
                    }
                }
                if (!setTemp) {
                    blockTemp += blockTemperatureData.getTemperatureModifier();
                }
            } else {
                blockTemp += blockTemperatureData.getTemperatureModifier();
                if (blockTemperatureData.usesLevelProperty()) {
                    if (heatState.method_28498((class_2769)class_2741.field_12538)) {
                        blockTemp *= (float)(((Integer)heatState.method_11654((class_2769)class_2741.field_12538) + 1) / 16);
                    } else if (heatState.method_28498((class_2769)class_2741.field_17586)) {
                        blockTemp *= (float)(((Integer)heatState.method_11654((class_2769)class_2741.field_17586) + 1) / 9);
                    } else if (heatState.method_28498((class_2769)class_2741.field_12490)) {
                        blockTemp *= (float)((Integer)heatState.method_11654((class_2769)class_2741.field_12490) / 8);
                    } else if (heatState.method_28498((class_2769)class_2741.field_12513)) {
                        blockTemp *= (float)(((Integer)heatState.method_11654((class_2769)class_2741.field_12513) + 1) / 4);
                    }
                }
            }
        }
        return new TempData(blockTemp, 1.0f);
    }

    protected record TempData(float tempModifier, float conductionCoeff) {
    }

    protected static class JobEntry {
        final class_2338 pos;
        final long enqueuedAt;

        public JobEntry(class_2338 pos) {
            this.pos = pos;
            this.enqueuedAt = System.nanoTime();
        }
    }
}

