/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json.property;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stereowalker.survive.api.IBlockPropertyHandler;
import com.stereowalker.survive.json.property.EnumBlockPropertyHandlerImpl;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2746;
import net.minecraft.class_2758;

public abstract class BlockPropertyHandlerImpl<X extends Comparable<X>>
implements IBlockPropertyHandler<X> {
    String name;

    public static void init() {
        new BlockPropertyHandlerImpl<Boolean>("boolean"){

            @Override
            public Map<String, Float> deserialize(JsonObject object) {
                HashMap m = Maps.newHashMap();
                for (Map.Entry pr2 : object.get("values").getAsJsonObject().entrySet()) {
                    m.put((String)pr2.getKey() + "b", Float.valueOf(((JsonElement)pr2.getValue()).getAsFloat()));
                }
                return m;
            }

            @Override
            public IBlockPropertyHandler.PropertyPair<Boolean> requirements(JsonObject object) {
                return IBlockPropertyHandler.PropertyPair.create(class_2746.method_11825((String)object.get("property").getAsString()), object.get("value").getAsBoolean());
            }

            public class_2746 derivedProperty() {
                return class_2746.method_11825((String)this.name);
            }

            @Override
            public Boolean getValue(String value) {
                return Boolean.parseBoolean(value.substring(0, value.length() - 1));
            }
        };
        new BlockPropertyHandlerImpl<Integer>("integer"){
            int min;
            int max;

            @Override
            public Map<String, Float> deserialize(JsonObject object) {
                this.min = object.get("min").getAsInt();
                this.max = object.get("max").getAsInt();
                HashMap m = Maps.newHashMap();
                for (Map.Entry pr2 : object.get("values").getAsJsonObject().entrySet()) {
                    m.put((String)pr2.getKey() + "i", Float.valueOf(((JsonElement)pr2.getValue()).getAsFloat()));
                }
                return m;
            }

            public class_2758 derivedProperty() {
                return class_2758.method_11867((String)this.name, (int)this.min, (int)this.max);
            }

            @Override
            public IBlockPropertyHandler.PropertyPair<Integer> requirements(JsonObject object) {
                return IBlockPropertyHandler.PropertyPair.create(class_2758.method_11867((String)object.get("property").getAsString(), (int)object.get("min").getAsInt(), (int)object.get("max").getAsInt()), object.get("value").getAsInt());
            }

            @Override
            public Integer getValue(String value) {
                return Integer.parseInt(value.substring(0, value.length() - 1));
            }
        };
        new EnumBlockPropertyHandlerImpl();
    }

    protected BlockPropertyHandlerImpl(String key) {
        SAVED_PROPERTIES.put(key, this);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static Map<String, Float> deserialize(IBlockPropertyHandler<?> handler, JsonObject object) {
        handler.setName(object.get("name").getAsString());
        object.remove("name");
        return handler.deserialize(object);
    }
}

