/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.world.effect.SMobEffects;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class CustomFoodData
extends class_1702 {
    int uncleanConsumption = 0;
    boolean causeAche = false;
    boolean wellFed = false;
    FoodUtils.State isSpoiled = FoodUtils.State.Okay;

    public CustomFoodData(class_1702 originalFoodData) {
        this.field_7756 = originalFoodData.field_7756;
        this.method_7581(originalFoodData.method_7589());
        this.method_35218(originalFoodData.method_35219());
        this.field_7755 = originalFoodData.field_7755;
    }

    public void method_7585(int pFoodLevelModifier, float pSaturationLevelModifier) {
        int foodLevel = this.field_7756;
        float satMod = 1.0f;
        if (this.IsSpoiled() == FoodUtils.State.Spoiled) {
            pFoodLevelModifier /= 2;
        }
        if (this.IsSpoiled() == FoodUtils.State.Fresh) {
            satMod = 1.5f;
        } else if (this.IsSpoiled() == FoodUtils.State.Good) {
            satMod = 1.1f;
        } else if (this.IsSpoiled() == FoodUtils.State.Spoiling) {
            satMod = 0.9f;
        } else if (this.IsSpoiled() == FoodUtils.State.Spoiled) {
            satMod = 0.5f;
        }
        super.method_7585(pFoodLevelModifier, pSaturationLevelModifier * satMod);
        int capacity = 20;
        if (ServerConfig.stomachCapacity == StomachCapacity.DOUBLED) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == StomachCapacity.LIMITED && this.field_7756 < 20) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == StomachCapacity.LIMITED && this.field_7756 >= 20) {
            capacity = this.field_7756;
        }
        if (ServerConfig.stomachCapacity != StomachCapacity.VANILLA) {
            this.field_7756 = Math.min(pFoodLevelModifier + foodLevel, capacity);
            if (this.field_7756 == 20 && foodLevel < 20) {
                this.wellFed = true;
            } else {
                this.causeAche = this.field_7756 > 20 && foodLevel < 20 && pFoodLevelModifier / 2 < this.field_7756 - 20 ? true : this.field_7756 > 20 && foodLevel >= 20;
            }
        }
    }

    public void consumeUnclean() {
        ++this.uncleanConsumption;
    }

    public void markAsSpoiled(class_1799 stack, class_1309 living) {
        this.isSpoiled = FoodUtils.foodStatus(stack, living.method_37908());
        if (this.IsSpoiled() == FoodUtils.State.Spoiled) {
            living.method_6092(new class_1293(class_1294.field_5916, 1200));
            living.method_6092(new class_1293(class_1294.field_5903, 1200));
        }
    }

    public void method_7588(class_1657 pPlayer) {
        class_1267 difficulty = pPlayer.method_37908().method_8407();
        if (this.wellFed) {
            if (this.field_7756 == 20) {
                pPlayer.method_6092(new class_1293(SMobEffects.WELL_FED.holder(), 300, 0));
            } else {
                this.wellFed = false;
            }
        }
        if (ServerConfig.stomachCapacity != StomachCapacity.VANILLA) {
            int amplifier = -1;
            int duration = 210;
            if (this.field_7756 > 36) {
                amplifier = 4;
            } else if (this.field_7756 > 32) {
                amplifier = 3;
            } else if (this.field_7756 > 28) {
                amplifier = 2;
            } else if (this.field_7756 > 24) {
                amplifier = 1;
            } else if (this.field_7756 > 20) {
                amplifier = 0;
            }
            class_1293 upsetStomach = pPlayer.method_6112(SMobEffects.UPSET_STOMACH.holder());
            if (!(pPlayer.method_7325() || pPlayer.method_7337() || amplifier <= 0 || upsetStomach != null && upsetStomach.method_5584() > 210 && upsetStomach.method_5578() >= amplifier)) {
                pPlayer.method_6092(new class_1293(SMobEffects.UPSET_STOMACH.holder(), duration, amplifier));
            }
        }
        if (Survive.WELLBEING_CONFIG.enabled && this.uncleanConsumption >= 3) {
            ((IRealisticEntity)pPlayer).wellbeingData().setTimer(2400, 6000, "eating bad food");
            this.uncleanConsumption = 0;
        }
        if (this.field_7756 >= 40 && (pPlayer.method_6032() > 10.0f || difficulty == class_1267.field_5807 || pPlayer.method_6032() > 1.0f && difficulty == class_1267.field_5802)) {
            int tickTimer2 = this.field_7755;
            this.field_7755 = 0;
            super.method_7588(pPlayer);
            this.field_7755 = tickTimer2 + 1;
            if (this.field_7755 >= 10) {
                pPlayer.method_5643(SDamageSources.source(pPlayer.method_37908().method_30349(), SDamageTypes.OVEREAT), 1.0f);
                this.field_7755 = 0;
            }
        } else {
            super.method_7588(pPlayer);
        }
    }

    public boolean canConsumeFood() {
        switch (ServerConfig.stomachCapacity.ordinal()) {
            case 2: {
                return this.method_7587();
            }
            case 1: {
                return this.method_7587();
            }
            case 0: {
                return this.field_7756 < 40;
            }
        }
        return this.method_7587();
    }

    public void method_7584(class_2487 pCompoundTag) {
        super.method_7584(pCompoundTag);
        if (pCompoundTag.method_10573("foodLevel", 99)) {
            this.uncleanConsumption = pCompoundTag.method_10550("foodUncleanConsumption");
            this.causeAche = pCompoundTag.method_10577("foodCauseAche");
            this.wellFed = pCompoundTag.method_10577("foodWellFed");
        }
    }

    public void method_7582(class_2487 pCompoundTag) {
        super.method_7582(pCompoundTag);
        pCompoundTag.method_10548("foodUncleanConsumption", (float)this.uncleanConsumption);
        pCompoundTag.method_10556("foodCauseAche", this.causeAche);
        pCompoundTag.method_10556("foodWellFed", this.wellFed);
    }

    public FoodUtils.State IsSpoiled() {
        return this.isSpoiled;
    }

    public static enum StomachCapacity {
        DOUBLED,
        LIMITED,
        VANILLA;

    }
}

