/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.particles.SParticleTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import java.util.Random;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2487;

public class HygieneData
extends SurviveData {
    private int uncleanLevel = 15;
    private int hygieneTimer;

    public void clean(int cleanLevelIn, boolean isSkinnyDipping) {
        if (this.uncleanLevel > 7 && isSkinnyDipping || !isSkinnyDipping) {
            this.uncleanLevel = Math.max(this.uncleanLevel - cleanLevelIn, 0);
        }
    }

    public void dirty(int dirtyLevelIn) {
        this.uncleanLevel = Math.max(dirtyLevelIn + this.uncleanLevel, 0);
    }

    @Override
    public void clientTick(class_1657 player) {
        if (!player.method_7337() && !player.method_7325()) {
            Random rand;
            if (this.needsABath()) {
                rand = new Random();
                for (int i = 0; i < (this.uncleanLevel - 25) / 20 + 2; ++i) {
                    player.method_37908().method_8406((class_2394)SParticleTypes.STINK, player.method_23322(0.5), player.method_23319() - 0.25, player.method_23325(0.5), (rand.nextDouble() - 0.5) * 0.5, -rand.nextDouble() * 0.5, (rand.nextDouble() - 0.5) * 0.5);
                }
            }
            if (this.isSqueakyClean()) {
                rand = new Random();
                player.method_37908().method_8406((class_2394)SParticleTypes.CLEAN, player.method_23322(0.5), player.method_23319() - 0.25, player.method_23325(0.5), (rand.nextDouble() - 0.5) * 0.5, -rand.nextDouble() * 0.5, (rand.nextDouble() - 0.5) * 0.5);
            }
        }
    }

    @Override
    public void tick(class_1657 player) {
        if (!player.method_7337() && !player.method_7325()) {
            ++this.hygieneTimer;
            if (this.hygieneTimer >= 200 && player.method_5721()) {
                this.clean(1, true);
                this.hygieneTimer = 0;
            } else if (Survive.HYGIENE_CONFIG.dirtyTickRate >= 0 && this.hygieneTimer >= Survive.HYGIENE_CONFIG.dirtyTickRate) {
                this.dirty(1);
                this.hygieneTimer = 0;
            }
            if (Survive.HYGIENE_CONFIG.illnessLevel >= 0 && this.uncleanLevel > Survive.HYGIENE_CONFIG.illnessLevel && Survive.WELLBEING_CONFIG.enabled) {
                ((IRealisticEntity)player).wellbeingData().setTimer(6000, 24000, "staying dirty too long");
            }
        } else {
            this.hygieneTimer = 0;
        }
    }

    @Override
    public void read(class_2487 compound) {
        if (compound.method_10573("uncleanLevel", 99)) {
            this.uncleanLevel = compound.method_10550("uncleanLevel");
            this.hygieneTimer = compound.method_10550("hygieneTimer");
        }
    }

    @Override
    public void write(class_2487 compound, boolean reducedData) {
        compound.method_10548("uncleanLevel", (float)this.uncleanLevel);
        compound.method_10569("hygieneTimer", this.hygieneTimer);
    }

    public int getUncleanLevel() {
        return this.uncleanLevel;
    }

    public boolean isSqueakyClean() {
        return this.uncleanLevel < 5;
    }

    public boolean needsABath() {
        return this.uncleanLevel > 30;
    }

    public boolean shouldBeAvoidedByAnimals() {
        return this.uncleanLevel > 35;
    }

    public boolean shouldBeAvoidedByPigs() {
        return this.uncleanLevel > 45;
    }

    @Override
    public void save(class_1309 player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.HYGIENE_CONFIG.enabled;
    }
}

