/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.needs.Stamina;
import com.stereowalker.survive.core.WeightHandler;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.network.protocol.game.ServerboundArmorStaminaPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundRelaxPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.unionlib.api.insert.InsertResultCanceller;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Random;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class StaminaData
extends SurviveData
implements Stamina {
    private int longStamina;
    private int shortStamina;
    private int energyReserveLevel = 6;
    private float longExhaustion;
    private float shortExhaustion;
    private int energyTimer;
    private int shortTermTimer;
    private int shortRecoveryTimer;
    private boolean isStraining;
    private int prevEnergyLevel;
    private int maxLongStamina;
    private int maxBurstStamina = 10;

    public StaminaData(double maxStamina) {
        this.longStamina = class_3532.method_15357((double)maxStamina);
        this.prevEnergyLevel = class_3532.method_15357((double)maxStamina);
        this.shortStamina = this.maxBurstStamina;
    }

    public void relax(int energyLevelIn, double maxStamina) {
        int remaining = 0;
        remaining = this.energyReserveLevel + energyLevelIn - 6;
        this.energyReserveLevel = Math.min(energyLevelIn + this.energyReserveLevel, 6);
        if (remaining > 0) {
            this.longStamina = Math.min(remaining + this.longStamina, class_3532.method_15357((double)maxStamina));
        }
    }

    public void eat(class_1792 pItem, class_1799 pStack, class_1309 entity) {
        if (VersionHelper.VanillaComponents.FOOD.hasData(pStack) && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().method_10221((Object)pItem)) && entity instanceof class_3222 && !entity.method_37908().field_9236) {
            class_3222 player = (class_3222)entity;
            this.relax(DataMaps.Server.consummableItem.get(RegistryHelper.items().method_10221((Object)pItem)).getEnergyAmount(), player.method_45325(SAttributes.MAX_STAMINA.holder()));
        }
    }

    @Override
    public void clientTick(class_1657 player) {
        if (player.method_5765() && player.field_6012 % 400 == 399 && player.method_5854().method_18798().field_1352 == 0.0 && player.method_5854().method_18798().field_1350 == 0.0) {
            new ServerboundRelaxPacket(1).send();
        }
        if (player.field_6012 % 90 == 89 && player.method_37908().method_8407() != class_1267.field_5801) {
            new ServerboundArmorStaminaPacket().send();
        }
    }

    @Override
    public void tick(class_1657 player) {
        IRealisticEntity realPlayer = (IRealisticEntity)player;
        this.maxLongStamina = class_3532.method_15357((double)player.method_45325(SAttributes.MAX_STAMINA.holder()));
        if (player.method_6113() && player.method_37908().method_8530() && this.longStamina < this.maxLongStamina / 2) {
            player.field_7487 = 0;
        }
        class_1267 difficulty = player.method_37908().method_8407();
        int energyToRegen = 1 + (player.method_6059(SMobEffects.WELL_FED.holder()) ? new Random().nextInt(2) : 0);
        this.prevEnergyLevel = this.longStamina;
        if (this.longExhaustion > 20.0f) {
            this.longExhaustion -= 20.0f;
            if (difficulty != class_1267.field_5801) {
                if (this.longStamina > 0) {
                    this.longStamina = Math.max(this.longStamina - 1, 0);
                } else if (this.energyReserveLevel > 0) {
                    this.energyReserveLevel = Math.max(this.energyReserveLevel - 1, 0);
                }
            }
        }
        if (!this.isStraining && this.shortTermTimer > 0) {
            this.isStraining = true;
            this.maxBurstStamina = 10;
            if (Survive.CONFIG.nutrition_enabled) {
                int carb = realPlayer.nutritionData().carbs().level();
                this.maxBurstStamina = carb > 2000 ? class_3532.method_48781((float)((float)(carb - 2000) / 1000.0f), (int)12, (int)20) : (carb > 1000 ? class_3532.method_48781((float)((float)(carb - 1000) / 1000.0f), (int)7, (int)12) : (carb > 0 ? class_3532.method_48781((float)((float)carb / 2000.0f), (int)3, (int)7) : class_3532.method_48781((float)((float)(1000 + carb) / 1000.0f), (int)1, (int)3)));
            }
            this.shortExhaustion = 0.0f;
            this.shortStamina = this.maxBurstStamina;
        } else if (this.isStraining && this.shortTermTimer > 0) {
            --this.shortTermTimer;
            if (this.shortExhaustion > 5.0f) {
                this.shortExhaustion -= 5.0f;
                if (difficulty != class_1267.field_5801 && this.shortStamina > 0) {
                    this.shortStamina = Math.max(this.shortStamina - 1, 0);
                }
            }
            if (this.shortStamina <= 0) {
                this.shortTermTimer = 0;
            }
        } else if (!this.isStraining && this.shortTermTimer <= 0) {
            --this.shortRecoveryTimer;
        } else if (this.isStraining && this.shortTermTimer <= 0) {
            this.isStraining = false;
            this.shortRecoveryTimer = this.maxBurstStamina - this.shortStamina;
            this.addExhaustion((float)this.shortRecoveryTimer * 7.8f, false);
            realPlayer.nutritionData().carbs().remove(this.shortRecoveryTimer * 10);
            this.shortRecoveryTimer *= 13;
            player.method_6092(new class_1293(SMobEffects.FATIGUE.holder(), this.shortRecoveryTimer, 1, false, true));
        }
        if (this.isTired() && Survive.CONFIG.nutrition_enabled && ((IRealisticEntity)player).nutritionData().fat().level() >= 20) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxLongStamina);
                realPlayer.nutritionData().fat().remove(20);
                this.energyTimer = 0;
            }
        } else if (this.isTired() && !Survive.CONFIG.nutrition_enabled && player.method_7344().method_7586() > Survive.STAMINA_CONFIG.min_food && WeightHandler.getTotalArmorWeight((class_1309)player) / Survive.STAMINA_CONFIG.max_weight < 1.0f) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxLongStamina);
                player.method_7344().method_7583(2.0f);
                this.energyTimer = 0;
            }
        } else if (player.method_6113()) {
            ++this.energyTimer;
            if ((double)this.energyTimer >= Math.floor((float)Survive.STAMINA_CONFIG.sleepTime / (float)(this.maxLongStamina + 6))) {
                this.relax(energyToRegen, this.maxLongStamina);
                this.energyTimer = 0;
            }
        } else if (this.longStamina <= 0 && this.energyReserveLevel <= 0) {
            ++this.energyTimer;
            if (this.energyTimer >= 20) {
                player.method_5643(SDamageSources.source(player.method_37908().method_30349(), SDamageTypes.OVERWORK), 3.0f);
                this.energyTimer = 0;
            }
        } else {
            this.energyTimer = 0;
        }
        if (difficulty == class_1267.field_5801 && player.method_37908().method_8450().method_8355(class_1928.field_19395) && this.isTired() && player.field_6012 % 10 == 0) {
            this.setEnergyLevel(this.getLTS() + 1);
        }
    }

    @Override
    public void read(class_2487 compound) {
        if (compound.method_10573("longStamina", 99)) {
            this.maxBurstStamina = compound.method_10550("maxBurstStamina");
            this.maxLongStamina = compound.method_10550("maxLongStamina");
            this.longStamina = compound.method_10550("longStamina");
            this.longExhaustion = compound.method_10583("longExhaustion");
            this.shortStamina = compound.method_10550("shortStamina");
            this.shortExhaustion = compound.method_10583("shortExhaustion");
            this.shortTermTimer = compound.method_10550("shortTermTimer");
            this.shortRecoveryTimer = compound.method_10550("shortRecoveryTimer");
            this.isStraining = compound.method_10577("isStraining");
            this.energyTimer = compound.method_10550("energyTickTimer");
            this.energyReserveLevel = compound.method_10550("energyReserveLevel");
        }
    }

    @Override
    public void write(class_2487 compound, boolean reducedData) {
        compound.method_10569("maxBurstStamina", this.maxBurstStamina);
        compound.method_10569("maxLongStamina", this.maxLongStamina);
        compound.method_10569("longStamina", this.longStamina);
        compound.method_10569("shortStamina", this.shortStamina);
        compound.method_10556("isStraining", this.isStraining);
        compound.method_10569("energyReserveLevel", this.energyReserveLevel);
        if (!reducedData) {
            compound.method_10548("shortExhaustion", this.shortExhaustion);
            compound.method_10548("longExhaustion", this.longExhaustion);
            compound.method_10569("energyTickTimer", this.energyTimer);
            compound.method_10569("shortTermTimer", this.shortTermTimer);
        }
        compound.method_10569("shortRecoveryTimer", this.shortRecoveryTimer);
    }

    public int getLTS() {
        return this.longStamina;
    }

    @Override
    public int getBurstStamina() {
        return this.shortStamina;
    }

    public int getSTSRecovery() {
        return this.maxBurstStamina - class_3532.method_15375((float)((float)this.shortRecoveryTimer / 13.0f));
    }

    public boolean isTired() {
        return this.longStamina < this.maxLongStamina;
    }

    public boolean isExerting() {
        return this.isStraining;
    }

    @Override
    public boolean isShortOfBreath() {
        return this.shortRecoveryTimer > 0;
    }

    @Override
    public boolean isDeadTired() {
        return this.longStamina <= 0;
    }

    public void addExhaustion(float exhaustion, boolean strain) {
        if (strain && !this.isShortOfBreath()) {
            this.shortExhaustion = Math.min(this.shortExhaustion + exhaustion, 40.0f);
            this.shortTermTimer = 100;
        } else {
            this.longExhaustion = Math.min(this.longExhaustion + exhaustion, 40.0f);
        }
    }

    public int getReserveLevel() {
        return this.energyReserveLevel;
    }

    public void setEnergyLevel(int energyLevelIn) {
        this.longStamina = energyLevelIn;
    }

    public void setEnergyReserveLevel(int energyReserveLevelIn) {
        this.energyReserveLevel = energyReserveLevelIn;
    }

    @Override
    public void save(class_1309 player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.STAMINA_CONFIG.enabled;
    }

    public static void clickItem(class_1657 player, class_1937 level, class_1268 hand, InsertResultCanceller<class_1271<class_1799>> cancel) {
        if (cancel.wasCancelled() || !(player instanceof class_1657) || ((class_1271)cancel.cancelResult()).method_5467().method_23665()) {
            // empty if block
        }
    }
}

