/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.needs.Water;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.needs.CustomFoodData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.Random;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_9334;

public class WaterData
extends SurviveData
implements Water {
    private int tempDropTicks = 0;
    private int waterLevel = 20;
    private float waterHydrationLevel = 4.0f;
    private float waterExhaustionLevel;
    private int waterTimer;
    private int prevWaterLevel = 20;
    private int uncleanConsumption = 0;
    private int uncleanStacks = 0;

    public void drink(int waterLevelIn, float waterHydrationModifier, int uncleanStack, boolean isUnclean) {
        int capacity = 20;
        if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.DOUBLED) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.LIMITED && this.waterLevel < 20) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.LIMITED && this.waterLevel >= 20) {
            capacity = this.waterLevel;
        }
        this.waterLevel = Math.min(waterLevelIn + this.waterLevel, capacity);
        if (this.waterHydrationLevel >= waterHydrationModifier) {
            this.waterHydrationLevel = waterHydrationModifier;
        } else if (this.waterHydrationLevel < waterHydrationModifier) {
            this.waterHydrationLevel = class_3532.method_15363((float)(this.waterHydrationLevel + waterHydrationModifier * Survive.THIRST_CONFIG.hydration_restoration), (float)1.0f, (float)waterHydrationModifier);
        }
        if (isUnclean) {
            this.uncleanStacks += uncleanStack;
            ++this.uncleanConsumption;
        }
    }

    public void drink(float thirstConsumption, int uncleanStack, boolean isUnclean) {
        this.waterExhaustionLevel += thirstConsumption;
        if (isUnclean) {
            this.uncleanStacks += uncleanStack;
            ++this.uncleanConsumption;
        }
    }

    public void drink(class_1792 pItem, class_1799 pStack, class_1309 entity) {
        if (entity != null && entity instanceof class_3222) {
            class_2960 biomeSource;
            class_3222 player = (class_3222)entity;
            class_1844 potion = (class_1844)pStack.method_57824(class_9334.field_49651);
            float biomef = -1.0f;
            int stacks = 0;
            if (SDataComponents.BIOME_SOURCE_D.hasData(pStack) && DataMaps.Server.biome.containsKey(biomeSource = (class_2960)SDataComponents.BIOME_SOURCE_D.getData(pStack))) {
                BiomeJsonHolder biomeData = DataMaps.Server.biome.get(biomeSource);
                biomef = biomeData.getThirstChance();
                stacks = biomeData.getUnwellIntensity();
            }
            if (potion != null && DataMaps.Server.potionDrink.containsKey(RegistryHelper.potions().method_10221((Object)((class_1842)((class_6880)potion.comp_2378().get()).comp_349())))) {
                drinkData = DataMaps.Server.potionDrink.get(RegistryHelper.potions().method_10221((Object)((class_1842)((class_6880)potion.comp_2378().get()).comp_349())));
                if (drinkData.getThirstConsumption() > 0.0f) {
                    this.drink(drinkData.getThirstConsumption(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                } else {
                    this.drink(drinkData.getThirstAmount(), drinkData.getHydrationAmount(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                }
                if (drinkData.isHeated()) {
                    entity.method_6092(new class_1293(SMobEffects.HEATED.holder(), 600));
                }
                if (drinkData.isChilled()) {
                    entity.method_6092(new class_1293(SMobEffects.CHILLED.holder(), 600));
                }
                if (drinkData.isEnergizing()) {
                    entity.method_6092(new class_1293(SMobEffects.ENERGIZED.holder(), 6000));
                }
            } else if (DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().method_10221((Object)pItem))) {
                drinkData = DataMaps.Server.consummableItem.get(RegistryHelper.items().method_10221((Object)pItem));
                if (drinkData.getThirstConsumption() > 0.0f) {
                    this.drink(drinkData.getThirstConsumption(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                } else {
                    this.drink(drinkData.getThirstAmount(), drinkData.getHydrationAmount(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                }
                if (drinkData.isHeated()) {
                    entity.method_6092(new class_1293(SMobEffects.HEATED.holder(), 600));
                }
                if (drinkData.isChilled()) {
                    entity.method_6092(new class_1293(SMobEffects.CHILLED.holder(), 600));
                }
                if (drinkData.isEnergizing()) {
                    entity.method_6092(new class_1293(SMobEffects.ENERGIZED.holder(), 6000));
                }
            }
        }
    }

    @Override
    public void tick(class_1657 player) {
        this.waterHydrationLevel = class_3532.method_15363((float)this.waterHydrationLevel, (float)1.0f, (float)4.0f);
        if (Survive.THIRST_CONFIG.idle_thirst_tick_rate > -1 && player.field_6012 % Survive.THIRST_CONFIG.idle_thirst_tick_rate == Survive.THIRST_CONFIG.idle_thirst_tick_rate - 1) {
            this.addExhaustion(player, Survive.THIRST_CONFIG.idle_thirst_exhaustion);
        }
        class_1267 difficulty = player.method_37908().method_8407();
        this.prevWaterLevel = this.waterLevel;
        if (ServerConfig.stomachCapacity != CustomFoodData.StomachCapacity.VANILLA) {
            int amplifier = -1;
            int duration = 210;
            if (this.waterLevel > 36) {
                amplifier = 4;
            } else if (this.waterLevel > 32) {
                amplifier = 3;
            } else if (this.waterLevel > 28) {
                amplifier = 2;
            } else if (this.waterLevel > 24) {
                amplifier = 1;
            } else if (this.waterLevel > 20) {
                amplifier = 0;
            }
            class_1293 upsetStomach = player.method_6112(SMobEffects.UPSET_STOMACH.holder());
            if (!(player.method_7325() || player.method_7337() || amplifier <= 0 || upsetStomach != null && upsetStomach.method_5584() > 210 && upsetStomach.method_5578() >= amplifier)) {
                player.method_6092(new class_1293(SMobEffects.UPSET_STOMACH.holder(), duration, amplifier));
            }
        }
        if (this.waterExhaustionLevel > this.waterHydrationLevel) {
            this.waterExhaustionLevel -= this.waterHydrationLevel;
            if (this.waterHydrationLevel > 2.8f) {
                this.waterHydrationLevel = Math.max(this.waterHydrationLevel - 0.1f, 2.8f);
            }
            if (difficulty != class_1267.field_5801) {
                this.waterLevel = Math.max(this.waterLevel - 1, 0);
            }
        }
        boolean flag = player.method_37908().method_8450().method_8355(class_1928.field_19395);
        if (this.waterLevel >= 40) {
            ++this.waterTimer;
            if (this.waterTimer >= 10) {
                if (player.method_6032() > 10.0f || difficulty == class_1267.field_5807 || player.method_6032() > 1.0f && difficulty == class_1267.field_5802) {
                    player.method_5643(SDamageSources.source(player.method_37908().method_30349(), SDamageTypes.OVERHYDRATE), 1.0f);
                }
                this.waterTimer = 0;
            }
        } else if (flag && this.waterLevel >= 16 && this.tempDropTicks < 10 && ((IRealisticEntity)player).temperatureData().getTemperatureLevel() > (37.0 + TemperatureUtil.firstHeat(player)) / 2.0) {
            ++this.waterTimer;
            if (this.waterTimer >= 80) {
                ++this.tempDropTicks;
                this.addExhaustion(6.0f);
                this.waterTimer = 0;
            }
        } else if (this.waterLevel <= 0) {
            ++this.waterTimer;
            if (this.waterTimer >= 80) {
                if (player.method_6032() > 10.0f || difficulty == class_1267.field_5807 || player.method_6032() > 1.0f && difficulty == class_1267.field_5802) {
                    player.method_5643(SDamageSources.source(player.method_37908().method_30349(), SDamageTypes.DEHYDRATE), 1.0f);
                }
                this.waterTimer = 0;
            }
        } else {
            this.waterTimer = 0;
        }
        if (Survive.WELLBEING_CONFIG.enabled && this.uncleanConsumption >= 3) {
            ((IRealisticEntity)player).wellbeingData().setTimer(2400, 6000, class_3532.method_15386((float)((float)this.uncleanStacks / (float)this.uncleanConsumption)), "drinking unpurified water");
            this.uncleanConsumption = 0;
        }
    }

    public void applyTempDrop(class_1657 player) {
        --this.tempDropTicks;
    }

    public boolean shouldTempDrop() {
        return this.tempDropTicks > 0;
    }

    @Override
    public void read(class_2487 compound) {
        if (compound.method_10573("waterLevel", 99)) {
            this.tempDropTicks = compound.method_10550("tempDropTicks");
            this.waterLevel = compound.method_10550("waterLevel");
            this.waterTimer = compound.method_10550("waterTickTimer");
            this.waterHydrationLevel = compound.method_10583("waterHydrationLevel");
            this.waterExhaustionLevel = compound.method_10583("waterExhaustionLevel");
            this.uncleanConsumption = compound.method_10550("uncleanComsumption");
            this.uncleanStacks = compound.method_10550("uncleanStacks");
        }
    }

    @Override
    public void write(class_2487 compound, boolean reducedData) {
        compound.method_10569("tempDropTicks", this.tempDropTicks);
        compound.method_10569("waterLevel", this.waterLevel);
        compound.method_10569("waterTickTimer", this.waterTimer);
        compound.method_10548("waterHydrationLevel", this.waterHydrationLevel);
        compound.method_10548("waterExhaustionLevel", this.waterExhaustionLevel);
        compound.method_10569("uncleanComsumption", this.uncleanConsumption);
        compound.method_10569("uncleanStacks", this.uncleanStacks);
    }

    @Override
    public int getWaterLevel() {
        return this.waterLevel;
    }

    public boolean needWater() {
        switch (ServerConfig.stomachCapacity) {
            case VANILLA: {
                return this.waterLevel < 20;
            }
            case LIMITED: {
                return this.waterLevel < 20;
            }
            case DOUBLED: {
                return this.waterLevel < 40;
            }
        }
        return this.waterLevel < 20;
    }

    private void addExhaustion(float exhaustion) {
        this.waterExhaustionLevel = Math.min(this.waterExhaustionLevel + exhaustion, 40.0f);
    }

    public void addExhaustion(class_1657 player, float exhaustion) {
        if (!player.method_31549().field_7480 && !player.method_37908().field_9236) {
            this.addExhaustion(exhaustion);
        }
    }

    public float getHydrationLevel() {
        return this.waterHydrationLevel;
    }

    public void setWaterLevel(int waterLevelIn) {
        this.waterLevel = waterLevelIn;
    }

    public void setWaterHydrationLevel(float waterHydrationLevelIn) {
        this.waterHydrationLevel = waterHydrationLevelIn;
    }

    @Override
    public void save(class_1309 player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.THIRST_CONFIG.enabled;
    }

    public static boolean applyThirst(class_1309 entity, float probabiltiy) {
        Random rand;
        if (probabiltiy > 0.0f && (rand = new Random()).nextFloat() < probabiltiy) {
            entity.method_6092(new class_1293(SMobEffects.THIRST.holder(), 600));
            return true;
        }
        return false;
    }
}

