/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.network.protocol.game.ClientboundDrinkSoundPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3621;
import net.minecraft.class_5321;
import net.minecraft.class_5556;
import net.minecraft.class_9129;

public class ServerboundInteractWithWaterPacket
extends ServerboundUnionPacket {
    private class_2338 pos;
    private float addThirst;
    private double waterAmount;
    private double hydrationAmount;
    private class_1268 hand;
    public static class_2960 id = VersionHelper.toLoc((String)"survive", (String)"serverbound_interact_with_water");

    public ServerboundInteractWithWaterPacket(class_2338 pos, float addThirst, double waterAmount, double hydrationAmount, class_1268 hand) {
        super(null);
        this.pos = pos;
        this.addThirst = addThirst;
        this.waterAmount = waterAmount;
        this.hydrationAmount = hydrationAmount;
        this.hand = hand;
    }

    public ServerboundInteractWithWaterPacket(class_2338 pos, float addThirst, double waterAmount, class_1268 hand) {
        this(pos, addThirst, waterAmount, 0.0, hand);
    }

    public ServerboundInteractWithWaterPacket(class_9129 packetBuffer) {
        super(packetBuffer);
        this.pos = packetBuffer.method_10811();
        this.addThirst = packetBuffer.readFloat();
        this.hand = (class_1268)packetBuffer.method_10818(class_1268.class);
        this.waterAmount = packetBuffer.readDouble();
        this.hydrationAmount = packetBuffer.readDouble();
    }

    public void encode(class_2540 byteBuf) {
        byteBuf.method_10807(this.pos);
        byteBuf.method_52941(this.addThirst);
        byteBuf.method_10817((Enum)this.hand);
        byteBuf.method_52940(this.waterAmount);
        byteBuf.method_52940(this.hydrationAmount);
    }

    public static boolean canDrinkThis(class_3610 fluid, boolean canDrinkFlowingIfInfinite) {
        if (fluid.method_15771()) {
            return true;
        }
        return fluid.method_15772() instanceof class_3621 && canDrinkFlowingIfInfinite;
    }

    public static boolean shouldRemoveSource(class_3610 fluid) {
        return (!(fluid.method_15772() instanceof class_3621) || Survive.THIRST_CONFIG.shouldRemoveSourceWaterBlock) && fluid.method_15771();
    }

    public boolean handleOnServer(class_3222 sender) {
        if (Survive.THIRST_CONFIG.enabled) {
            class_1799 heldItem = sender.method_5998(this.hand);
            class_2680 block = sender.method_37908().method_8320(this.pos);
            class_3610 fluid = sender.method_37908().method_8316(this.pos);
            if (heldItem.method_7960()) {
                WaterData waterStats;
                if (sender.method_18276() && (waterStats = ((IRealisticEntity)sender).waterData()).needWater()) {
                    boolean flag = false;
                    if (block.method_26204() == class_2246.field_27097) {
                        class_5556.method_31650((class_2680)block, (class_1937)sender.method_37908(), (class_2338)this.pos);
                        flag = true;
                    } else if (ServerboundInteractWithWaterPacket.canDrinkThis(fluid, Survive.THIRST_CONFIG.drinkFromFlowingWater)) {
                        if (ServerboundInteractWithWaterPacket.shouldRemoveSource(fluid)) {
                            sender.method_37908().method_8501(this.pos, class_2246.field_10124.method_9564());
                        }
                        flag = true;
                    } else if (sender.method_37908().method_8520(this.pos)) {
                        flag = true;
                    }
                    if (flag) {
                        int stacks = 0;
                        if (DataMaps.Server.biome.containsKey(((class_5321)sender.method_37908().method_23753(this.pos).method_40230().get()).method_29177())) {
                            BiomeJsonHolder biomeData = DataMaps.Server.biome.get(((class_5321)sender.method_37908().method_23753(this.pos).method_40230().get()).method_29177());
                            stacks = biomeData.getUnwellIntensity();
                        }
                        waterStats.drink((int)this.waterAmount, (float)this.hydrationAmount, stacks, WaterData.applyThirst((class_1309)sender, this.addThirst));
                    }
                    sender.method_37908().method_8396((class_1657)sender, this.pos, new class_1799((class_1935)class_1802.field_8574).method_21832(), class_3419.field_15248, 0.5f, sender.method_37908().field_9229.method_43057() * 0.1f + 0.9f);
                    sender.method_6104(class_1268.field_5808);
                    new ClientboundDrinkSoundPacket(this.pos).send(sender);
                }
            } else if (heldItem.method_7909() == class_1802.field_8428 && ServerboundInteractWithWaterPacket.isValidContainerSource(this.waterAmount)) {
                heldItem.method_7934(1);
                if (this.addThirst > 0.0f) {
                    sender.method_7270(new class_1799((class_1935)SItems.WATER_BOWL));
                } else {
                    sender.method_7270(new class_1799((class_1935)SItems.PURIFIED_WATER_BOWL));
                }
            }
        }
        return true;
    }

    public static boolean isValidContainerSource(double waterAmount) {
        return waterAmount >= 3.0;
    }

    public static boolean isValidStack(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8428 || stack.method_7960();
    }

    public class_2960 id() {
        return id;
    }
}

