/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7923;

public class BlockDataManager
implements IResourceReloadListener<Map<class_2960, BlockTemperatureJsonHolder>> {
    public CompletableFuture<Map<class_2960, BlockTemperatureJsonHolder>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, BlockTemperatureJsonHolder> drinkMap = new HashMap<class_2960, BlockTemperatureJsonHolder>();
            for (Map.Entry resource : manager.method_14488("survive_modifiers/blocks", s -> s.toString().endsWith(".json")).entrySet()) {
                class_2960 blockId = VersionHelper.toLoc((String)((class_2960)resource.getKey()).method_12836(), (String)((class_2960)resource.getKey()).method_12832().replace("survive_modifiers/blocks/", "").replace(".json", ""));
                if (class_7923.field_41175.method_10250(blockId)) {
                    try (InputStream stream = ((class_3298)resource.getValue()).method_14482();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        BlockTemperatureJsonHolder blockData = new BlockTemperatureJsonHolder(blockId, object);
                        Survive.getInstance().getLogger().info("Found block temperature modifier for the item " + String.valueOf(blockId));
                        drinkMap.put(blockId, blockData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading the block temperature modifier for the item " + String.valueOf(blockId) + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such block exists with the block id " + String.valueOf(blockId) + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<class_2960, BlockTemperatureJsonHolder> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (class_2960 drinkId : data.keySet()) {
                Survive.registerBlockTemperatures(drinkId, (BlockTemperatureJsonHolder)data.get(drinkId));
            }
        });
    }

    public class_2960 id() {
        return VersionHelper.toLoc((String)"survive:block_data");
    }
}

