/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3542;

public class NeedsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"needs").requires(p_137384_ -> p_137384_.method_9259(2))).then(class_2170.method_9247((String)"restore").then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"cleansing").executes(e -> NeedsCommand.restore((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.CLEANSING, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"hunger").executes(e -> NeedsCommand.restore((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HUNGER, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"hydration").executes(e -> NeedsCommand.restore((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HYDRATION, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"saturation").executes(e -> NeedsCommand.restore((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SATURATION, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"sleep").executes(e -> NeedsCommand.restore((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SLEEP, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"stamina").executes(e -> NeedsCommand.restore((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.STAMINA, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"thirst").executes(e -> NeedsCommand.restore((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.THIRST, class_2186.method_9312((CommandContext)e, (String)"targets")))))))).then(class_2170.method_9247((String)"deplete").then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"cleansing").executes(e -> NeedsCommand.deplete((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.CLEANSING, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"hunger").executes(e -> NeedsCommand.deplete((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HUNGER, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"hydration").executes(e -> NeedsCommand.deplete((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HYDRATION, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"saturation").executes(e -> NeedsCommand.deplete((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SATURATION, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"sleep").executes(e -> NeedsCommand.deplete((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SLEEP, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"stamina").executes(e -> NeedsCommand.deplete((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.STAMINA, class_2186.method_9312((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"thirst").executes(e -> NeedsCommand.deplete((class_2168)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.THIRST, class_2186.method_9312((CommandContext)e, (String)"targets")))))))).then(class_2170.method_9247((String)"query").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"cleansing").executes(e -> NeedsCommand.query((class_2168)e.getSource(), NeedType.CLEANSING, class_2186.method_9315((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"hunger").executes(e -> NeedsCommand.query((class_2168)e.getSource(), NeedType.HUNGER, class_2186.method_9315((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"hydration").executes(e -> NeedsCommand.query((class_2168)e.getSource(), NeedType.HYDRATION, class_2186.method_9315((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"saturation").executes(e -> NeedsCommand.query((class_2168)e.getSource(), NeedType.SATURATION, class_2186.method_9315((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"sleep").executes(e -> NeedsCommand.query((class_2168)e.getSource(), NeedType.SLEEP, class_2186.method_9315((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"stamina").executes(e -> NeedsCommand.query((class_2168)e.getSource(), NeedType.STAMINA, class_2186.method_9315((CommandContext)e, (String)"targets"))))).then(class_2170.method_9247((String)"thirst").executes(e -> NeedsCommand.query((class_2168)e.getSource(), NeedType.THIRST, class_2186.method_9315((CommandContext)e, (String)"targets")))))));
    }

    private static int restore(class_2168 source, float amount, NeedType type, Collection<class_3222> pTargets) throws CommandSyntaxException {
        for (class_3222 player : pTargets) {
            IRealisticEntity realisticPlayer = (IRealisticEntity)player;
            WaterData waterData = realisticPlayer.waterData();
            switch (type.ordinal()) {
                case 0: {
                    realisticPlayer.staminaData().relax(class_3532.method_15375((float)amount), player.method_45325(SAttributes.MAX_STAMINA.holder()));
                    break;
                }
                case 1: {
                    player.method_7344().method_7580(class_3532.method_15375((float)amount));
                    break;
                }
                case 2: {
                    player.method_7344().method_7581(amount);
                    break;
                }
                case 3: {
                    realisticPlayer.hygieneData().clean(class_3532.method_15375((float)amount), true);
                    break;
                }
                case 4: {
                    realisticPlayer.sleepData().addAwakeTime(player, -class_3532.method_15375((float)amount));
                    break;
                }
                case 5: {
                    waterData.drink(class_3532.method_15375((float)amount), waterData.getHydrationLevel(), 0, false);
                    break;
                }
                case 6: {
                    waterData.drink(0, waterData.getHydrationLevel() + amount, 0, false);
                }
            }
        }
        if (pTargets.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)("commands.needs.restore." + type.method_15434() + ".success.single"), (Object[])new Object[]{Float.valueOf(amount), ((class_3222)pTargets.iterator().next()).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)("commands.needs.restore." + type.method_15434() + ".success.multiple"), (Object[])new Object[]{Float.valueOf(amount), pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int deplete(class_2168 source, float amount, NeedType type, Collection<class_3222> pTargets) throws CommandSyntaxException {
        for (class_3222 player : pTargets) {
            IRealisticEntity realisticPlayer = (IRealisticEntity)player;
            WaterData waterData = realisticPlayer.waterData();
            switch (type.ordinal()) {
                case 0: {
                    realisticPlayer.staminaData().setEnergyLevel(realisticPlayer.staminaData().getLTS() - class_3532.method_15375((float)amount));
                    break;
                }
                case 1: {
                    player.method_7344().method_7580(player.method_7344().method_7586() - class_3532.method_15375((float)amount));
                    break;
                }
                case 2: {
                    player.method_7344().method_7581(player.method_7344().method_7589() - amount);
                    break;
                }
                case 3: {
                    realisticPlayer.hygieneData().dirty(class_3532.method_15375((float)amount));
                    break;
                }
                case 4: {
                    realisticPlayer.sleepData().addAwakeTime(player, class_3532.method_15375((float)amount));
                    break;
                }
                case 5: {
                    waterData.setWaterLevel(waterData.getWaterLevel() - class_3532.method_15375((float)amount));
                    break;
                }
                case 6: {
                    waterData.setWaterHydrationLevel(waterData.getHydrationLevel() - amount);
                }
            }
        }
        if (pTargets.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)("commands.needs.deplete." + type.method_15434() + ".success.single"), (Object[])new Object[]{Float.valueOf(amount), ((class_3222)pTargets.iterator().next()).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)("commands.needs.deplete." + type.method_15434() + ".success.multiple"), (Object[])new Object[]{Float.valueOf(amount), pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int query(class_2168 source, NeedType type, class_3222 pTarget) throws CommandSyntaxException {
        IRealisticEntity realisticPlayer = (IRealisticEntity)pTarget;
        float result = 0.0f;
        switch (type.ordinal()) {
            case 0: {
                result = realisticPlayer.staminaData().getLTS();
                break;
            }
            case 1: {
                result = pTarget.method_7344().method_7586();
                break;
            }
            case 2: {
                result = pTarget.method_7344().method_7589();
                break;
            }
            case 3: {
                result = realisticPlayer.hygieneData().getUncleanLevel();
                break;
            }
            case 4: {
                result = realisticPlayer.sleepData().getAwakeTimer();
                break;
            }
            case 5: {
                result = realisticPlayer.waterData().getWaterLevel();
                break;
            }
            case 6: {
                result = realisticPlayer.waterData().getHydrationLevel();
            }
        }
        float r = result;
        source.method_9226(() -> class_2561.method_43469((String)("commands.needs.query." + type.method_15434()), (Object[])new Object[]{pTarget.method_5476(), Float.valueOf(r)}), true);
        return class_3532.method_15375((float)result);
    }

    static enum NeedType implements class_3542
    {
        STAMINA("stamina"),
        HUNGER("hunger"),
        SATURATION("saturation"),
        CLEANSING("cleansing"),
        SLEEP("sleep"),
        THIRST("thirst"),
        HYDRATION("hydration");

        String name;

        private NeedType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

