/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.level.block.AbstractTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.state.properties.SBlockStateProperties;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateSize;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateType;
import com.stereowalker.unionlib.util.math.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import net.minecraft.class_8567;

public class PlatedTemperatureRegulatorBlock
extends AbstractTemperatureRegulatorBlock
implements TemperatureEmitter {
    public static final class_2754<TempRegulationPlateType> TEMP_REG_TYPE = SBlockStateProperties.TEMP_REG_TYPE;
    public static final class_2746 POWERED = class_2741.field_12484;

    public PlatedTemperatureRegulatorBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(TEMP_REG_TYPE, (Comparable)((Object)TempRegulationPlateType.HEATER))).method_11657((class_2769)RADIATOR_SIZE, (Comparable)((Object)TempRegulationPlateSize.LARGE))).method_11657((class_2769)PLATE_COUNT, (Comparable)Integer.valueOf(0))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 pContext) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)pContext.method_7715().method_10153())).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pContext.method_8045(), pContext.method_8037(), pContext.method_8038())));
    }

    public void method_9612(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2248 pBlock, class_2338 pFromPos, boolean pIsMoving) {
        if (PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (class_2350)pState.method_11654((class_2769)FACING)) && !((Boolean)pState.method_11654((class_2769)POWERED)).booleanValue()) {
            pLevel.method_8501(pPos, (class_2680)pState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)));
        } else if (!PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (class_2350)pState.method_11654((class_2769)FACING)) && ((Boolean)pState.method_11654((class_2769)POWERED)).booleanValue()) {
            pLevel.method_8501(pPos, (class_2680)pState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public List<class_1799> method_9560(class_2680 pState, class_8567.class_8568 pBuilder) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        drops.addAll(super.method_9560(pState, pBuilder));
        for (int i = 0; i < (Integer)pState.method_11654((class_2769)AbstractTemperatureRegulatorBlock.PLATE_COUNT); ++i) {
            drops.add(this.getPlateStack(pState));
        }
        return drops;
    }

    public static boolean hasPowerInEitherDirection(class_1937 pLevel, class_2338 pPos, class_2350 pDirection) {
        return pLevel.method_49807(pPos.method_10093(pDirection), pDirection) || pLevel.method_49807(pPos.method_10093(pDirection.method_10153()), pDirection.method_10153());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(new class_2769[]{TEMP_REG_TYPE, RADIATOR_SIZE, PLATE_COUNT, FACING, POWERED, WATERLOGGED});
    }

    @Override
    public boolean canAddPlate(class_2680 pState, class_1799 plate) {
        TempRegulationPlateType newControl = null;
        TempRegulationPlateSize newSize = null;
        if (plate.method_7909() instanceof TemperatureRegulatorPlateItem) {
            newControl = ((TemperatureRegulatorPlateItem)plate.method_7909()).getType();
            newSize = ((TemperatureRegulatorPlateItem)plate.method_7909()).getSize();
        }
        return pState.method_11654(TEMP_REG_TYPE) == newControl && pState.method_11654((class_2769)RADIATOR_SIZE) == newSize;
    }

    public static Color getColor(class_2680 pState) {
        if (pState.method_26204() instanceof PlatedTemperatureRegulatorBlock) {
            if (((Boolean)pState.method_11654((class_2769)POWERED)).booleanValue()) {
                switch ((TempRegulationPlateType)((Object)pState.method_11654(TEMP_REG_TYPE))) {
                    case HEATER: {
                        return Color.parse((String)"#bd6d3f");
                    }
                    case CHILLER: {
                        return Color.parse((String)"#7ab2d3");
                    }
                }
            } else {
                return ((TempRegulationPlateType)((Object)pState.method_11654(TEMP_REG_TYPE))).getColor();
            }
        }
        return Color.named((String)"white");
    }

    @Override
    public boolean canRemovePlates(class_2680 pState) {
        return true;
    }

    @Override
    public class_1799 getPlateStack(class_2680 pState) {
        if (pState.method_11654((class_2769)RADIATOR_SIZE) == TempRegulationPlateSize.LARGE && pState.method_11654(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new class_1799((class_1935)SItems.LARGE_HEATING_PLATE);
        }
        if (pState.method_11654((class_2769)RADIATOR_SIZE) == TempRegulationPlateSize.LARGE && pState.method_11654(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new class_1799((class_1935)SItems.LARGE_COOLING_PLATE);
        }
        if (pState.method_11654((class_2769)RADIATOR_SIZE) == TempRegulationPlateSize.MEDIUM && pState.method_11654(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new class_1799((class_1935)SItems.MEDIUM_HEATING_PLATE);
        }
        if (pState.method_11654((class_2769)RADIATOR_SIZE) == TempRegulationPlateSize.MEDIUM && pState.method_11654(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new class_1799((class_1935)SItems.MEDIUM_COOLING_PLATE);
        }
        if (pState.method_11654((class_2769)RADIATOR_SIZE) == TempRegulationPlateSize.SMALL && pState.method_11654(TEMP_REG_TYPE) == TempRegulationPlateType.HEATER) {
            return new class_1799((class_1935)SItems.SMALL_HEATING_PLATE);
        }
        if (pState.method_11654((class_2769)RADIATOR_SIZE) == TempRegulationPlateSize.SMALL && pState.method_11654(TEMP_REG_TYPE) == TempRegulationPlateType.CHILLER) {
            return new class_1799((class_1935)SItems.SMALL_COOLING_PLATE);
        }
        return class_1799.field_8037;
    }

    @Override
    public float getTemperatureModification(class_2680 pState) {
        if (((Boolean)pState.method_11654((class_2769)POWERED)).booleanValue()) {
            float blockTemp = (float)((Integer)pState.method_11654((class_2769)AbstractTemperatureRegulatorBlock.PLATE_COUNT)).intValue() * ((TempRegulationPlateSize)((Object)pState.method_11654(AbstractTemperatureRegulatorBlock.RADIATOR_SIZE))).getModifier();
            switch ((TempRegulationPlateType)((Object)pState.method_11654(TEMP_REG_TYPE))) {
                case CHILLER: {
                    blockTemp *= -1.0f;
                    break;
                }
                case HEATER: {
                    blockTemp *= 1.0f;
                    break;
                }
                default: {
                    blockTemp *= 0.0f;
                }
            }
            return blockTemp;
        }
        return 0.0f;
    }

    @Override
    public float getModificationRange(class_2680 pState) {
        return ((TempRegulationPlateSize)((Object)pState.method_11654(AbstractTemperatureRegulatorBlock.RADIATOR_SIZE))).getRange();
    }
}

