/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block.entity;

import com.stereowalker.survive.world.level.block.RealisticCampfireBlock;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public class RealisticCampfireBlockEntity
extends class_2586
implements class_3829 {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final class_2371<class_1799> items = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];
    private int fuelTime = 0;
    private final class_1863.class_7266<class_9696, class_3920> quickCheck = class_1863.method_42302((class_3956)class_3956.field_17549);

    public RealisticCampfireBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(SBlockEntityType.REALISIC_CAMPFIRE, pPos, pBlockState);
    }

    public static void cookTick(class_1937 pLevel, class_2338 pPos, class_2680 pState, RealisticCampfireBlockEntity pBlockEntity) {
        boolean flag = false;
        for (int i = 0; i < pBlockEntity.items.size(); ++i) {
            class_9696 singlerecipeinput;
            class_1799 itemstack1;
            class_1799 itemstack = (class_1799)pBlockEntity.items.get(i);
            if (itemstack.method_7960()) continue;
            flag = true;
            int n = i;
            pBlockEntity.cookingProgress[n] = pBlockEntity.cookingProgress[n] + 1;
            if (pBlockEntity.cookingProgress[i] < pBlockEntity.cookingTime[i] || !(itemstack1 = pBlockEntity.quickCheck.method_42303((class_9695)(singlerecipeinput = new class_9696(itemstack)), pLevel).map(p_341839_ -> ((class_3920)p_341839_.comp_1933()).method_59982(singlerecipeinput, (class_7225.class_7874)pLevel.method_30349())).orElse(itemstack)).method_45435(pLevel.method_45162())) continue;
            class_1264.method_5449((class_1937)pLevel, (double)pPos.method_10263(), (double)pPos.method_10264(), (double)pPos.method_10260(), (class_1799)itemstack1);
            pBlockEntity.items.set(i, (Object)class_1799.field_8037);
            pLevel.method_8413(pPos, pState, pState, 3);
            pLevel.method_43276((class_6880)class_5712.field_28733, pPos, class_5712.class_7397.method_43287((class_2680)pState));
        }
        flag = true;
        --pBlockEntity.fuelTime;
        if (pBlockEntity.fuelTime <= 0 || pLevel.method_8520(pPos.method_10084()) || !((Boolean)pState.method_11654((class_2769)RealisticCampfireBlock.LIT)).booleanValue()) {
            pLevel.method_8652(pPos, (class_2680)((class_2680)pState.method_11657((class_2769)RealisticCampfireBlock.LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RealisticCampfireBlock.HEAT, (Comparable)Integer.valueOf(0)), 3);
        } else if (pBlockEntity.fuelTime >= 2250) {
            pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)RealisticCampfireBlock.HEAT, (Comparable)Integer.valueOf(4)), 3);
        } else if (pBlockEntity.fuelTime >= 1500) {
            pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)RealisticCampfireBlock.HEAT, (Comparable)Integer.valueOf(3)), 3);
        } else if (pBlockEntity.fuelTime >= 750) {
            pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)RealisticCampfireBlock.HEAT, (Comparable)Integer.valueOf(2)), 3);
        } else if (pBlockEntity.fuelTime >= 0) {
            pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)RealisticCampfireBlock.HEAT, (Comparable)Integer.valueOf(1)), 3);
        }
        if (flag) {
            RealisticCampfireBlockEntity.method_31663((class_1937)pLevel, (class_2338)pPos, (class_2680)pState);
        }
    }

    public static void cooldownTick(class_1937 pLevel, class_2338 pPos, class_2680 pState, RealisticCampfireBlockEntity pBlockEntity) {
        boolean flag = false;
        if (pBlockEntity.fuelTime <= 0) {
            pLevel.method_8652(pPos, (class_2680)((class_2680)pState.method_11657((class_2769)RealisticCampfireBlock.LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RealisticCampfireBlock.HEAT, (Comparable)Integer.valueOf(0)), 3);
        } else if (((Boolean)pState.method_11654((class_2769)RealisticCampfireBlock.LIT)).booleanValue() && pBlockEntity.fuelTime > 0 && !pLevel.method_8520(pPos)) {
            pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)RealisticCampfireBlock.HEAT, (Comparable)Integer.valueOf(class_3532.method_15386((float)((float)pBlockEntity.fuelTime / 1000.0f)))), 3);
        }
        for (int i = 0; i < pBlockEntity.items.size(); ++i) {
            if (pBlockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            pBlockEntity.cookingProgress[i] = class_3532.method_15340((int)(pBlockEntity.cookingProgress[i] - 2), (int)0, (int)pBlockEntity.cookingTime[i]);
        }
        if (flag) {
            RealisticCampfireBlockEntity.method_31663((class_1937)pLevel, (class_2338)pPos, (class_2680)pState);
        }
    }

    public static void particleTick(class_1937 pLevel, class_2338 pPos, class_2680 pState, RealisticCampfireBlockEntity pBlockEntity) {
        class_5819 randomsource = pLevel.field_9229;
        if (randomsource.method_43057() < 0.11f) {
            for (int i = 0; i < randomsource.method_43048(2) + 2; ++i) {
                RealisticCampfireBlock.makeParticles(pLevel, pPos, (Boolean)pState.method_11654((class_2769)RealisticCampfireBlock.field_17353), false);
            }
        }
        int l = ((class_2350)pState.method_11654((class_2769)RealisticCampfireBlock.FACING)).method_10161();
        for (int j = 0; j < pBlockEntity.items.size(); ++j) {
            if (((class_1799)pBlockEntity.items.get(j)).method_7960() || !(randomsource.method_43057() < 0.2f)) continue;
            class_2350 direction = class_2350.method_10139((int)Math.floorMod(j + l, 4));
            float f = 0.3125f;
            double d0 = (double)pPos.method_10263() + 0.5 - (double)((float)direction.method_10148() * 0.3125f) + (double)((float)direction.method_10170().method_10148() * 0.3125f);
            double d1 = (double)pPos.method_10264() + 0.5;
            double d2 = (double)pPos.method_10260() + 0.5 - (double)((float)direction.method_10165() * 0.3125f) + (double)((float)direction.method_10170().method_10165() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                pLevel.method_8406((class_2394)class_2398.field_11251, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    protected void method_11014(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11014(pTag, pRegistries);
        this.items.clear();
        class_1262.method_5429((class_2487)pTag, this.items, (class_7225.class_7874)pRegistries);
        if (pTag.method_10573("CookingTimes", 11)) {
            int[] aint = pTag.method_10561("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (pTag.method_10573("CookingTotalTimes", 11)) {
            int[] aint1 = pTag.method_10561("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
        this.fuelTime = pTag.method_10550("fuelTime");
    }

    protected void method_11007(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11007(pTag, pRegistries);
        class_1262.method_5427((class_2487)pTag, this.items, (boolean)true, (class_7225.class_7874)pRegistries);
        pTag.method_10539("CookingTimes", this.cookingProgress);
        pTag.method_10539("CookingTotalTimes", this.cookingTime);
        pTag.method_10569("fuelTime", this.fuelTime);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 pRegistries) {
        class_2487 compoundtag = new class_2487();
        class_1262.method_5427((class_2487)compoundtag, this.items, (boolean)true, (class_7225.class_7874)pRegistries);
        return compoundtag;
    }

    public Optional<class_8786<class_3920>> getCookableRecipe(class_1799 pStack) {
        return this.items.stream().noneMatch(class_1799::method_7960) ? Optional.empty() : this.quickCheck.method_42303((class_9695)new class_9696(pStack), this.field_11863);
    }

    public boolean placeFood(@Nullable class_1309 pEntity, class_1799 pFood, int pCookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemstack = (class_1799)this.items.get(i);
            if (!itemstack.method_7960()) continue;
            this.cookingTime[i] = pCookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)pFood.method_60504(1, pEntity));
            this.field_11863.method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)pEntity, (class_2680)this.method_11010()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void method_5448() {
        this.items.clear();
    }

    public void dowse() {
        if (this.field_11863 != null) {
            this.markUpdated();
        }
    }

    protected void method_57568(class_2586.class_9473 pComponentInput) {
        super.method_57568(pComponentInput);
        ((class_9288)pComponentInput.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.getItems());
    }

    protected void method_57567(class_9323.class_9324 pComponents) {
        super.method_57567(pComponents);
        pComponents.method_57840(class_9334.field_49622, (Object)class_9288.method_57493(this.getItems()));
    }

    public void method_57569(class_2487 pTag) {
        pTag.method_10551("Items");
    }

    public boolean placeFuel(@Nullable class_1309 pEntity, class_1799 pFood) {
        int fuelAdded = class_2609.method_11196().getOrDefault(pFood.method_7909(), 0);
        if (pFood.method_7909() != class_1802.field_8187 && this.fuelTime + fuelAdded <= 3000) {
            this.fuelTime += fuelAdded;
            pFood.method_7934(1);
            this.field_11863.method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)pEntity, (class_2680)this.method_11010()));
            this.markUpdated();
            return true;
        }
        return false;
    }
}

