/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.google.gson.JsonObject;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class OnFireCondition
extends TemperatureChangeCondition<Instance> {
    @Override
    public Instance createInstance(JsonObject object) {
        float temperatureIn = 0.0f;
        int fireTimerIn = 0;
        String operationIn = "";
        if (object.has("temperature") && object.get("temperature").isJsonPrimitive()) {
            temperatureIn = object.get("temperature").getAsFloat();
        }
        if (object.has("fireTimer") && object.get("fireTimer").isJsonPrimitive()) {
            fireTimerIn = object.get("fireTimer").getAsInt();
        }
        if (object.has("operation") && object.get("operation").isJsonPrimitive()) {
            operationIn = object.get("operation").getAsString();
        }
        return new Instance(temperatureIn, fireTimerIn, operationIn);
    }

    @Override
    public Instance createInstance(class_2487 nbt) {
        float temperatureIn = nbt.method_10583("temperature");
        int fireTimerIn = nbt.method_10550("fireTimer");
        String operationIn = nbt.method_10558("operation");
        return new Instance(temperatureIn, fireTimerIn, operationIn);
    }

    static class Instance
    extends TemperatureChangeInstance {
        private int fireTimer;
        private String operation;

        public Instance(float temperatureIn, int fireTimerIn, String operationIn) {
            super(temperatureIn);
            this.fireTimer = fireTimerIn;
            this.operation = operationIn;
        }

        @Override
        public boolean shouldChangeTemperature(class_1657 player) {
            if (player.method_5809()) {
                if (this.fireTimer > 0) {
                    if (this.operation.equals("=")) {
                        return player.method_20802() == this.fireTimer;
                    }
                    if (this.operation.equals(">=")) {
                        return player.method_20802() >= this.fireTimer;
                    }
                    if (this.operation.equals("<=")) {
                        return player.method_20802() <= this.fireTimer;
                    }
                    if (this.operation.equals(">")) {
                        return player.method_20802() > this.fireTimer;
                    }
                    if (this.operation.equals("<")) {
                        return player.method_20802() < this.fireTimer;
                    }
                    return player.method_20802() < this.fireTimer;
                }
                return true;
            }
            return false;
        }

        @Override
        public class_2487 serialize() {
            class_2487 nbt = new class_2487();
            nbt.method_10548("temperature", this.getTemperature());
            nbt.method_10569("fireTimer", this.fireTimer);
            nbt.method_10582("operation", this.operation);
            return nbt;
        }

        @Override
        public class_2561 getAdditionalContext() {
            if (this.fireTimer > 0) {
                return class_2561.method_43469((String)"temperature_context.on_fire", (Object[])new Object[]{this.operation.equals("") ? "<" : this.operation, this.fireTimer});
            }
            return class_2561.method_43471((String)"temperature_context.on_fire_no_timer");
        }
    }
}

