/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.hooks;

import com.google.common.collect.ImmutableMap;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public interface ColdStorage {
    public float coldness();

    public float maxColdness();

    public void setColdness(float var1);

    public long lastAccessed();

    public void setLastAccessed(long var1);

    public float lossFactor();

    public int slotCount();

    public ItemStack get(int var1);

    public void set(int var1, ItemStack var2);

    default public ContainerData data() {
        return new ContainerData(){

            public void m_8050_(int pIndex, int pValue) {
                if (pIndex == 0) {
                    ColdStorage.this.setColdness(pValue);
                }
            }

            public int m_6499_() {
                return 2;
            }

            public int m_6413_(int pIndex) {
                if (pIndex == 0) {
                    return Mth.m_14167_((float)ColdStorage.this.coldness());
                }
                if (pIndex == 1) {
                    return Mth.m_14167_((float)ColdStorage.this.maxColdness());
                }
                return 0;
            }
        };
    }

    default public void decrementColdness(long by) {
        this.setColdness(this.coldness() - this.lossFactor() * (float)by);
        if (this.coldness() < 0.0f) {
            this.setColdness(0.0f);
        }
    }

    default public float preservatonEfficiency() {
        return 1.0f - this.lossFactor();
    }

    default public void load2(CompoundTag pTag) {
        this.setColdness(pTag.m_128457_("coldness"));
        this.setLastAccessed(pTag.m_128454_("lastAccessed"));
    }

    default public void save(CompoundTag pTag) {
        pTag.m_128350_("coldness", this.coldness());
        pTag.m_128356_("lastAccessed", this.lastAccessed());
    }

    default public void coldTick(Level pLevel) {
        if (Survive.FOOD_CONFIG.enabled) {
            ItemStack stack;
            ImmutableMap COOLNESS = new ImmutableMap.Builder().put((Object)SItems.ICE_CUBE, (Object)Float.valueOf(38.0f)).put((Object)Items.f_41980_, (Object)Float.valueOf(342.0f)).build();
            long gameTime = pLevel.m_46467_();
            if (this.lastAccessed() == 0L) {
                this.setLastAccessed(gameTime);
            }
            long timeSinceLastOpened = gameTime - this.lastAccessed();
            int foodAmount = 0;
            for (int i = 0; i < this.slotCount(); ++i) {
                ItemStack stack2 = this.get(i);
                if (!VersionHelper.VanillaComponents.FOOD.hasData(stack2)) continue;
                FoodUtils.giveLifespanToFood(stack2, gameTime);
                foodAmount += stack2.m_41613_();
            }
            float coldnessValue = this.coldness();
            if (foodAmount > 0) {
                for (int i = 0; i < this.slotCount() && !(coldnessValue >= this.maxColdness()); ++i) {
                    int take;
                    float remainingColdness = this.maxColdness() - coldnessValue;
                    stack = this.get(i);
                    if (COOLNESS.containsKey(stack.m_41720_())) {
                        take = Math.min(Mth.m_14143_((float)(remainingColdness / ((Float)COOLNESS.get(stack.m_41720_())).floatValue())), stack.m_41613_());
                        coldnessValue += ((Float)COOLNESS.get(stack.m_41720_())).floatValue() * (float)take;
                        stack.m_41774_(take);
                    }
                    if (stack.m_41720_() == Items.f_42201_) {
                        take = Math.min(Mth.m_14143_((float)(remainingColdness / 3078.0f)), stack.m_41613_());
                        coldnessValue += 3078.0f * (float)take;
                        stack.m_41774_(take);
                    }
                    if (stack.m_41720_() != Items.f_42363_) continue;
                    take = Math.min(Mth.m_14143_((float)(remainingColdness / 27702.0f)), stack.m_41613_());
                    coldnessValue += 27702.0f * (float)take;
                    stack.m_41774_(take);
                }
                this.setColdness(coldnessValue);
            }
            this.setLastAccessed(gameTime);
            if (this.coldness() > 0.0f) {
                float efficiency = (float)timeSinceLastOpened * this.preservatonEfficiency();
                if (timeSinceLastOpened <= 2L) {
                    efficiency = 1.0f;
                }
                for (int i = 0; i < this.slotCount(); ++i) {
                    stack = this.get(i);
                    if (!SDataComponents.FOOD_STATUS_D.hasData(stack)) continue;
                    float eff = efficiency;
                    SDataComponents.FOOD_STATUS_D.editData(stack, food_status -> food_status.extendTime(eff));
                }
                this.decrementColdness(timeSinceLastOpened * (long)foodAmount);
            }
        }
    }
}

