/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.particles.SParticleTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class HygieneData
extends SurviveData {
    private int uncleanLevel = 15;
    private int hygieneTimer;

    public void clean(int cleanLevelIn, boolean isSkinnyDipping) {
        if (this.uncleanLevel > 7 && isSkinnyDipping || !isSkinnyDipping) {
            this.uncleanLevel = Math.max(this.uncleanLevel - cleanLevelIn, 0);
        }
    }

    public void dirty(int dirtyLevelIn) {
        this.uncleanLevel = Math.max(dirtyLevelIn + this.uncleanLevel, 0);
    }

    @Override
    public void clientTick(Player player) {
        if (!player.m_7500_() && !player.m_5833_()) {
            Random rand;
            if (this.needsABath()) {
                rand = new Random();
                for (int i = 0; i < (this.uncleanLevel - 25) / 20 + 2; ++i) {
                    player.m_9236_().m_7106_((ParticleOptions)SParticleTypes.STINK, player.m_20208_(0.5), player.m_20187_() - 0.25, player.m_20262_(0.5), (rand.nextDouble() - 0.5) * 0.5, -rand.nextDouble() * 0.5, (rand.nextDouble() - 0.5) * 0.5);
                }
            }
            if (this.isSqueakyClean()) {
                rand = new Random();
                player.m_9236_().m_7106_((ParticleOptions)SParticleTypes.CLEAN, player.m_20208_(0.5), player.m_20187_() - 0.25, player.m_20262_(0.5), (rand.nextDouble() - 0.5) * 0.5, -rand.nextDouble() * 0.5, (rand.nextDouble() - 0.5) * 0.5);
            }
        }
    }

    @Override
    public void tick(Player player) {
        if (!player.m_7500_() && !player.m_5833_()) {
            ++this.hygieneTimer;
            if (this.hygieneTimer >= 200 && player.m_20070_()) {
                this.clean(1, true);
                this.hygieneTimer = 0;
            } else if (Survive.HYGIENE_CONFIG.dirtyTickRate >= 0 && this.hygieneTimer >= Survive.HYGIENE_CONFIG.dirtyTickRate) {
                this.dirty(1);
                this.hygieneTimer = 0;
            }
            if (Survive.HYGIENE_CONFIG.illnessLevel >= 0 && this.uncleanLevel > Survive.HYGIENE_CONFIG.illnessLevel && Survive.WELLBEING_CONFIG.enabled) {
                ((IRealisticEntity)player).wellbeingData().setTimer(6000, 24000, "staying dirty too long");
            }
        } else {
            this.hygieneTimer = 0;
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("uncleanLevel", 99)) {
            this.uncleanLevel = compound.m_128451_("uncleanLevel");
            this.hygieneTimer = compound.m_128451_("hygieneTimer");
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.m_128350_("uncleanLevel", (float)this.uncleanLevel);
        compound.m_128405_("hygieneTimer", this.hygieneTimer);
    }

    public int getUncleanLevel() {
        return this.uncleanLevel;
    }

    public boolean isSqueakyClean() {
        return this.uncleanLevel < 5;
    }

    public boolean needsABath() {
        return this.uncleanLevel > 30;
    }

    public boolean shouldBeAvoidedByAnimals() {
        return this.uncleanLevel > 35;
    }

    public boolean shouldBeAvoidedByPigs() {
        return this.uncleanLevel > 45;
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.HYGIENE_CONFIG.enabled;
    }
}

