/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.google.common.collect.ImmutableMap;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.json.ArmorJsonHolder;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ClientboundDataTransferPacket
extends ClientboundUnionPacket {
    private ResourceLocation stat;
    private JsonHolder settings;
    private boolean clear;
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"clientbound_data_transfer");

    public ClientboundDataTransferPacket(ResourceLocation statIn, JsonHolder settingsIn, boolean clear) {
        super(Survive.getInstance().channel);
        this.stat = statIn;
        this.settings = settingsIn;
        this.clear = clear;
    }

    public ClientboundDataTransferPacket(FriendlyByteBuf byteBuf) {
        super(byteBuf, Survive.getInstance().channel);
        this.stat = byteBuf.m_130281_();
        String cl = byteBuf.m_130277_();
        this.settings = JsonHolder.deserialize(byteBuf.m_130260_(), (Class)JsonHolder.HOLD.get((Object)cl));
        this.clear = byteBuf.readBoolean();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.m_130085_(this.stat);
        byteBuf.m_130070_(this.settings.getClass().descriptorString());
        byteBuf.m_130079_(this.settings.serialize());
        byteBuf.writeBoolean(this.clear);
    }

    public boolean runOnClient(Player sender) {
        HashMap<ResourceLocation, ArmorJsonHolder> statMap;
        JsonHolder jsonHolder = this.settings;
        if (jsonHolder instanceof ArmorJsonHolder) {
            ArmorJsonHolder armor = (ArmorJsonHolder)jsonHolder;
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Armor Data");
                DataMaps.Client.armor = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<ResourceLocation, ArmorJsonHolder>)DataMaps.Client.armor);
            statMap.put(this.stat, armor);
            DataMaps.Client.armor = ImmutableMap.copyOf(statMap);
        }
        if ((statMap = this.settings) instanceof FluidJsonHolder) {
            FluidJsonHolder fluid = (FluidJsonHolder)((Object)statMap);
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Fluid Data");
                DataMaps.Client.fluid = ImmutableMap.of();
            }
            statMap = new HashMap<ResourceLocation, ArmorJsonHolder>();
            statMap.putAll((Map<ResourceLocation, ArmorJsonHolder>)DataMaps.Client.fluid);
            statMap.put(this.stat, (ArmorJsonHolder)((Object)fluid));
            DataMaps.Client.fluid = ImmutableMap.copyOf(statMap);
        }
        if ((statMap = this.settings) instanceof BiomeJsonHolder) {
            BiomeJsonHolder biome = (BiomeJsonHolder)((Object)statMap);
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Biome Data");
                DataMaps.Client.biome = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<ResourceLocation, ArmorJsonHolder>)DataMaps.Client.biome);
            statMap.put(this.stat, (ArmorJsonHolder)((Object)biome));
            DataMaps.Client.biome = ImmutableMap.copyOf(statMap);
        }
        if ((statMap = this.settings) instanceof FoodJsonHolder) {
            FoodJsonHolder consummable = (FoodJsonHolder)((Object)statMap);
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Consummable Data");
                DataMaps.Client.consummableItem = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<ResourceLocation, ArmorJsonHolder>)DataMaps.Client.consummableItem);
            statMap.put(this.stat, (ArmorJsonHolder)((Object)consummable));
            DataMaps.Client.consummableItem = ImmutableMap.copyOf(statMap);
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

