/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.level.block.PlatedTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.block.state.properties.SBlockStateProperties;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateSize;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractTemperatureRegulatorBlock
extends Block {
    public static final EnumProperty<TempRegulationPlateSize> RADIATOR_SIZE = SBlockStateProperties.TEMP_REG_SIZE;
    public static final IntegerProperty PLATE_COUNT = SBlockStateProperties.PLATE_COUNT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public AbstractTemperatureRegulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(RADIATOR_SIZE, (Comparable)((Object)TempRegulationPlateSize.SMALL))).m_61124_((Property)PLATE_COUNT, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_43719_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public abstract boolean canAddPlate(BlockState var1, ItemStack var2);

    public abstract boolean canRemovePlates(BlockState var1);

    public abstract ItemStack getPlateStack(BlockState var1);

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack pStack = pPlayer.m_21120_(pHand);
        int plate_count = (Integer)pState.m_61143_((Property)PLATE_COUNT);
        if (plate_count < 4 && this.canAddPlate(pState, pStack)) {
            return this.handlePlates(pStack, pState, pLevel, pPos, true);
        }
        if (plate_count > 0 && this.canRemovePlates(pState) && pStack.m_41619_()) {
            pPlayer.m_36356_(this.getPlateStack(pState));
            return this.handlePlates(pStack, pState, pLevel, pPos, false);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult handlePlates(ItemStack plate, BlockState pState, Level pLevel, BlockPos pPos, boolean add) {
        int plate_count = (Integer)pState.m_61143_((Property)PLATE_COUNT);
        int newCount = plate_count + (add ? 1 : -1);
        boolean alteredPlates = false;
        TempRegulationPlateType newState = null;
        TempRegulationPlateSize newSize = null;
        if (plate.m_41720_() instanceof TemperatureRegulatorPlateItem) {
            newState = ((TemperatureRegulatorPlateItem)plate.m_41720_()).getType();
            newSize = ((TemperatureRegulatorPlateItem)plate.m_41720_()).getSize();
        }
        if (add) {
            plate.m_41774_(1);
        }
        if (add && plate_count == 0) {
            pLevel.m_46597_(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)SBlocks.PLATED_TEMPERATURE_REGULATOR.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING)))).m_61124_(PlatedTemperatureRegulatorBlock.TEMP_REG_TYPE, (Comparable)((Object)newState))).m_61124_(RADIATOR_SIZE, (Comparable)((Object)newSize))).m_61124_((Property)PLATE_COUNT, (Comparable)Integer.valueOf(newCount))).m_61124_((Property)PlatedTemperatureRegulatorBlock.POWERED, (Comparable)Boolean.valueOf(PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (Direction)pState.m_61143_((Property)FACING)))));
            alteredPlates = true;
        } else if (!add && plate_count == 1) {
            pLevel.m_46597_(pPos, (BlockState)((BlockState)((BlockState)SBlocks.TEMPERATURE_REGULATOR.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING)))).m_61124_(RADIATOR_SIZE, (Comparable)((Object)TempRegulationPlateSize.SMALL))).m_61124_((Property)PLATE_COUNT, (Comparable)Integer.valueOf(0)));
            alteredPlates = true;
        } else {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)PLATE_COUNT, (Comparable)Integer.valueOf(newCount)));
            alteredPlates = true;
        }
        if (alteredPlates) {
            pLevel.m_7785_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f + pLevel.f_46441_.m_188501_(), 0.0f, false);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{RADIATOR_SIZE, FACING, PLATE_COUNT, WATERLOGGED});
    }
}

