/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.core.cauldron.SCauldronInteraction;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.world.level.block.SaltBoxBlock;
import com.stereowalker.survive.world.level.block.entity.DryingCauldronBlockEntity;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DryingCauldronBlock
extends LayeredCauldronBlock
implements EntityBlock {
    public static final IntegerProperty BOILING = IntegerProperty.m_61631_((String)"boiling", (int)0, (int)10);
    public static final EnumProperty<FluidToDry> FLUID = EnumProperty.m_61587_((String)"fluid", FluidToDry.class);

    public DryingCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, precipitation -> false, SCauldronInteraction.DRYING);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(1))).m_61124_((Property)BOILING, (Comparable)Integer.valueOf(0))).m_61124_(FLUID, (Comparable)((Object)FluidToDry.SEA_SALT)));
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        int boiling = (Integer)pState.m_61143_((Property)BOILING);
        if (boiling > 0 && this.m_151979_(pState, pPos, pEntity)) {
            pEntity.m_6469_(SDamageSources.source(pLevel.m_9598_(), SDamageTypes.BOIL), (float)boiling / 5.0f);
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Integer)pState.m_61143_((Property)f_153514_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_153514_, FLUID, BOILING});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_ && DryingCauldronBlockEntity.setResult(pLevel, pPlayer.m_21120_(pHand), pPos, pPlayer, pHand)) {
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : SaltBoxBlock.createTickerHelperExposed(pBlockEntityType, SBlockEntityType.DRYING_CAULDRON, (level, pos, state, blockentity) -> blockentity.tick((ServerLevel)pLevel, state));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DryingCauldronBlockEntity(pos, state);
    }

    public void m_214162_(BlockState pState, Level level, BlockPos pPos, RandomSource random) {
        int boil = (Integer)pState.m_61143_((Property)BOILING);
        double x = (double)pPos.m_123341_() + 0.5;
        double y = (double)pPos.m_123342_() + this.m_142446_(pState);
        double z = (double)pPos.m_123343_() + 0.5;
        if (boil <= 0 || random.m_188500_() < 0.1) {
            // empty if block
        }
        if (random.m_188500_() < 0.5) {
            for (int i = 0; i < boil; ++i) {
                double xOff = random.m_188500_() * (double)0.9f - (double)0.45f;
                double zOff = random.m_188500_() * (double)0.9f - (double)0.45f;
                if (boil % 2 == 0) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x + xOff, y, z + zOff, 0.0, 0.0, 0.0);
                    continue;
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x + xOff, y, z + zOff, 0.0, random.m_188500_() * (double)0.1f, 0.0);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public static enum FluidToDry implements StringRepresentable
    {
        SEA_SALT,
        POTASH;


        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SEA_SALT -> "sea_salt";
                case POTASH -> "potash";
            };
        }
    }
}

