/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block.entity;

import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.HygieneItems;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.DryingCauldronBlock;
import com.stereowalker.survive.world.level.block.RealisticCampfireBlock;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class DryingCauldronBlockEntity
extends BlockEntity {
    ItemStack result;
    int resultCount;
    int waterContentLeft;

    public DryingCauldronBlockEntity(BlockPos pos, BlockState blockState) {
        super(SBlockEntityType.DRYING_CAULDRON, pos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("waterContentLeft", this.waterContentLeft);
        tag.m_128405_("resultCount", this.resultCount);
        tag.m_128365_("result", (Tag)this.result.m_41739_(new CompoundTag()));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.waterContentLeft = tag.m_128451_("waterContentLeft");
        this.resultCount = tag.m_128451_("resultCount");
        this.result = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("result")));
    }

    public static int calculateFromTicks(int ticks, int level) {
        return Mth.m_14167_((float)((float)ticks * 300.0f * ((float)level / 3.0f)));
    }

    public ItemStack getResult() {
        return this.result == null ? ItemStack.f_41583_ : this.result.m_41777_();
    }

    public static boolean setResult(Level level, ItemStack item, BlockPos pos, Player player, InteractionHand hand) {
        BlockState state = level.m_8055_(pos);
        if (item.m_41720_() == HygieneItems.POTASH_SOLUTION) {
            if (!(level.m_7702_(pos) instanceof DryingCauldronBlockEntity)) {
                BlockEntity blockEntity;
                if (!level.f_46443_) {
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    player.m_36220_(Stats.f_12943_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)item.m_41720_()));
                    DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.f_11769_);
                    level.m_46597_(pos, SBlocks.DRYING_CAULDRON.m_49966_());
                }
                if ((blockEntity = level.m_7702_(pos)) instanceof DryingCauldronBlockEntity) {
                    DryingCauldronBlockEntity dbe = (DryingCauldronBlockEntity)blockEntity;
                    dbe.result = new ItemStack((ItemLike)HygieneItems.POTASH);
                    dbe.resultCount = 1;
                    dbe.waterContentLeft = DryingCauldronBlockEntity.calculateFromTicks(72000, 1);
                    return true;
                }
            } else {
                BlockEntity dbe = level.m_7702_(pos);
                if (dbe instanceof DryingCauldronBlockEntity) {
                    DryingCauldronBlockEntity dbe2 = (DryingCauldronBlockEntity)dbe;
                    if (dbe2.result.m_41720_() == HygieneItems.POTASH && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) < 3) {
                        if (!level.f_46443_) {
                            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                            player.m_36220_(Stats.f_12944_);
                            player.m_36246_(Stats.f_12982_.m_12902_((Object)item.m_41720_()));
                            level.m_46597_(pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                            DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.f_11769_);
                        }
                        ++dbe2.resultCount;
                        dbe2.waterContentLeft += DryingCauldronBlockEntity.calculateFromTicks(72000, 1);
                        return true;
                    }
                }
            }
        } else if (SDataComponents.BIOME_SOURCE_D.hasData(item) && ((Holder.Reference)((HolderLookup.RegistryLookup)level.m_9598_().m_254861_(Registries.f_256952_).get()).m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)((ResourceLocation)SDataComponents.BIOME_SOURCE_D.getData(item)))).get()).m_203656_(BiomeTags.f_207603_)) {
            if (item.m_41720_() == Items.f_42447_) {
                if (!(level.m_7702_(pos) instanceof DryingCauldronBlockEntity)) {
                    BlockEntity dbe;
                    if (!level.f_46443_) {
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
                        player.m_36220_(Stats.f_12943_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)item.m_41720_()));
                        DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.f_11778_);
                        level.m_46597_(pos, (BlockState)SBlocks.DRYING_CAULDRON.m_49966_().m_61124_((Property)DryingCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
                    }
                    if ((dbe = level.m_7702_(pos)) instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe3 = (DryingCauldronBlockEntity)dbe;
                        dbe3.result = new ItemStack((ItemLike)SItems.SEA_SALT);
                        dbe3.resultCount = 144;
                        dbe3.waterContentLeft = DryingCauldronBlockEntity.calculateFromTicks(192000, 3);
                        dbe3.markUpdated();
                        return true;
                    }
                }
            } else if (item.m_41720_() == Items.f_42589_ && PotionUtils.m_43579_((ItemStack)item) == Potions.f_43599_) {
                if (!(level.m_7702_(pos) instanceof DryingCauldronBlockEntity)) {
                    BlockEntity blockEntity;
                    if (!level.f_46443_) {
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                        player.m_36220_(Stats.f_12943_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)item.m_41720_()));
                        DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.f_11769_);
                        level.m_46597_(pos, SBlocks.DRYING_CAULDRON.m_49966_());
                    }
                    if ((blockEntity = level.m_7702_(pos)) instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe = (DryingCauldronBlockEntity)blockEntity;
                        dbe.result = new ItemStack((ItemLike)SItems.SEA_SALT);
                        dbe.resultCount = 48;
                        dbe.waterContentLeft = 19200000;
                        dbe.markUpdated();
                        return true;
                    }
                    System.out.println("NO DBE");
                } else {
                    BlockEntity dbe = level.m_7702_(pos);
                    if (dbe instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe4 = (DryingCauldronBlockEntity)dbe;
                        if (dbe4.result.m_41720_() == SItems.SEA_SALT && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) < 3) {
                            if (!level.f_46443_) {
                                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                                player.m_36220_(Stats.f_12944_);
                                player.m_36246_(Stats.f_12982_.m_12902_((Object)item.m_41720_()));
                                level.m_46597_(pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                                DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.f_11769_);
                            }
                            dbe4.resultCount += 48;
                            dbe4.waterContentLeft += 19200000;
                            dbe4.markUpdated();
                            return true;
                        }
                    }
                }
            } else if ((item.m_41720_() == SItems.FILLED_CANTEEN || item.m_41720_() == SItems.NETHERITE_CANTEEN) && PotionUtils.m_43579_((ItemStack)item) == Potions.f_43599_) {
                if (!(level.m_7702_(pos) instanceof DryingCauldronBlockEntity)) {
                    BlockEntity blockEntity;
                    if (!level.f_46443_) {
                        int drinksLeft = (Integer)SDataComponents.DRINKS_LEFT_D.getData(item);
                        if (drinksLeft > 3) {
                            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)CanteenItem.addToCanteen(item.m_41777_(), drinksLeft - 3, PotionUtils.m_43579_((ItemStack)item))));
                        } else {
                            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)(item.m_41720_() == SItems.FILLED_NETHERITE_CANTEEN ? SItems.NETHERITE_CANTEEN : SItems.CANTEEN))));
                        }
                        player.m_36220_(Stats.f_12943_);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)item.m_41720_()));
                        DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.f_11769_);
                        level.m_46597_(pos, (BlockState)SBlocks.DRYING_CAULDRON.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(Math.min(drinksLeft, 3))));
                    }
                    if ((blockEntity = level.m_7702_(pos)) instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe = (DryingCauldronBlockEntity)blockEntity;
                        dbe.result = new ItemStack((ItemLike)SItems.SEA_SALT);
                        dbe.resultCount = 48;
                        dbe.waterContentLeft = 19200000;
                        dbe.markUpdated();
                        return true;
                    }
                    System.out.println("NO DBE");
                } else {
                    BlockEntity dbe = level.m_7702_(pos);
                    if (dbe instanceof DryingCauldronBlockEntity) {
                        DryingCauldronBlockEntity dbe5 = (DryingCauldronBlockEntity)dbe;
                        if (dbe5.result.m_41720_() == SItems.SEA_SALT && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) < 3) {
                            if (!level.f_46443_) {
                                int cauldronLevelToFill = 3 - (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                                int drinksLeft = (Integer)SDataComponents.DRINKS_LEFT_D.getData(item);
                                if (drinksLeft > cauldronLevelToFill) {
                                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)CanteenItem.addToCanteen(item.m_41777_(), drinksLeft - cauldronLevelToFill, PotionUtils.m_43579_((ItemStack)item))));
                                } else {
                                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)(item.m_41720_() == SItems.FILLED_NETHERITE_CANTEEN ? SItems.NETHERITE_CANTEEN : SItems.CANTEEN))));
                                }
                                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                                player.m_36220_(Stats.f_12944_);
                                player.m_36246_(Stats.f_12982_.m_12902_((Object)item.m_41720_()));
                                level.m_46597_(pos, (BlockState)SBlocks.DRYING_CAULDRON.m_49966_().m_61124_((Property)DryingCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
                                DryingCauldronBlockEntity.updateItem(level, pos, SoundEvents.f_11769_);
                            }
                            dbe5.resultCount += 48;
                            dbe5.waterContentLeft += 19200000;
                            dbe5.markUpdated();
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void updateItem(Level level, BlockPos pos, SoundEvent sound) {
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_(null, GameEvent.f_157769_, pos);
    }

    public void tick(ServerLevel level, BlockState state) {
        int combinedPower;
        BlockState blockBelow;
        BlockState initialState = state;
        if (this.result.m_41720_() == SItems.SEA_SALT) {
            state = (BlockState)state.m_61124_(DryingCauldronBlock.FLUID, (Comparable)((Object)DryingCauldronBlock.FluidToDry.SEA_SALT));
        } else if (this.result.m_41720_() == HygieneItems.POTASH) {
            state = (BlockState)state.m_61124_(DryingCauldronBlock.FLUID, (Comparable)((Object)DryingCauldronBlock.FluidToDry.POTASH));
        }
        int sunPower = 0;
        int camfirePower = 0;
        BlockPos above = this.f_58858_.m_7494_();
        boolean flag = level.m_46758_(above);
        if (level.m_46461_() && !level.f_46443_) {
            float f = this.getBrightness(level, above);
            if (!flag && level.m_45527_(above)) {
                sunPower = Mth.m_14167_((float)(f * 0.6666667f));
            }
        }
        if (flag) {
            sunPower -= 20;
        }
        if (((Boolean)(blockBelow = level.m_8055_(this.f_58858_.m_7495_())).m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (blockBelow.m_60734_() == Blocks.f_50683_) {
                camfirePower = 50;
            } else if (blockBelow.m_60734_() == Blocks.f_50684_) {
                camfirePower = 70;
            } else if (blockBelow.m_60734_() == SBlocks.REALISTIC_CAMPFIRE) {
                camfirePower = (Integer)blockBelow.m_61143_((Property)RealisticCampfireBlock.HEAT) * 75;
            }
        }
        if ((combinedPower = sunPower + camfirePower) > 0) {
            this.waterContentLeft -= combinedPower;
            this.markUpdated();
        }
        state = (BlockState)state.m_61124_((Property)DryingCauldronBlock.BOILING, (Comparable)Integer.valueOf(Mth.m_14045_((int)Mth.m_14167_((float)((float)combinedPower / 31.0f)), (int)0, (int)10)));
        if (this.waterContentLeft <= 0) {
            this.result.m_41764_(this.resultCount);
            level.m_7967_((Entity)new ItemEntity((Level)level, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, this.result.m_278832_(), 0.0, 0.0, 0.0));
            level.m_46597_(this.f_58858_, Blocks.f_50256_.m_49966_());
        } else if (this.result.m_41720_() == SItems.SEA_SALT) {
            if (this.waterContentLeft <= DryingCauldronBlockEntity.calculateFromTicks(192000, 2) && (Integer)state.m_61143_((Property)DryingCauldronBlock.f_153514_) == 3) {
                state = (BlockState)state.m_61124_((Property)DryingCauldronBlock.f_153514_, (Comparable)Integer.valueOf(2));
            } else if (this.waterContentLeft <= DryingCauldronBlockEntity.calculateFromTicks(192000, 1) && (Integer)state.m_61143_((Property)DryingCauldronBlock.f_153514_) == 2) {
                state = (BlockState)state.m_61124_((Property)DryingCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1));
            }
        }
        if (initialState != state) {
            level.m_7731_(this.f_58858_, state, 3);
            DryingCauldronBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)state);
            this.markUpdated();
        }
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public float getBrightness(ServerLevel level, BlockPos pos) {
        return level.m_46805_(pos) ? (float)level.m_45517_(LightLayer.SKY, pos) : 0.0f;
    }
}

