/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.google.gson.JsonObject;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import com.stereowalker.unionlib.util.RegistryHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class BiomeNotCondition
extends TemperatureChangeCondition<Instance> {
    @Override
    public Instance createInstance(JsonObject object) {
        float temperatureIn = 0.0f;
        String biomeIn = "";
        if (object.has("temperature") && object.get("temperature").isJsonPrimitive()) {
            temperatureIn = object.get("temperature").getAsFloat();
        }
        if (object.has("biome") && object.get("biome").isJsonPrimitive()) {
            biomeIn = object.get("biome").getAsString();
        }
        return new Instance(temperatureIn, new ResourceLocation(biomeIn));
    }

    @Override
    public Instance createInstance(CompoundTag nbt) {
        float temperatureIn = nbt.m_128457_("temperature");
        String biomeIn = nbt.m_128461_("biome");
        return new Instance(temperatureIn, new ResourceLocation(biomeIn));
    }

    static class Instance
    extends TemperatureChangeInstance {
        private ResourceLocation biome;

        public Instance(float temperatureIn, ResourceLocation biomeIn) {
            super(temperatureIn);
            this.biome = biomeIn;
        }

        @Override
        public boolean shouldChangeTemperature(Player player) {
            if (player.m_9236_().m_204166_(player.m_20183_()).m_203543_().isPresent()) {
                return !RegistryHelper.matchesRegistryKey((ResourceLocation)this.biome, (ResourceKey)((ResourceKey)player.m_9236_().m_204166_(player.m_20183_()).m_203543_().get()));
            }
            return true;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128350_("temperature", this.getTemperature());
            nbt.m_128359_("biome", this.biome.toString());
            return nbt;
        }

        @Override
        public Component getAdditionalContext() {
            return Component.m_237110_((String)"temperature_context.not_biome", (Object[])new Object[]{this.biome});
        }
    }
}

