/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.google.gson.JsonObject;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class OnFireCondition
extends TemperatureChangeCondition<Instance> {
    @Override
    public Instance createInstance(JsonObject object) {
        float temperatureIn = 0.0f;
        int fireTimerIn = 0;
        String operationIn = "";
        if (object.has("temperature") && object.get("temperature").isJsonPrimitive()) {
            temperatureIn = object.get("temperature").getAsFloat();
        }
        if (object.has("fireTimer") && object.get("fireTimer").isJsonPrimitive()) {
            fireTimerIn = object.get("fireTimer").getAsInt();
        }
        if (object.has("operation") && object.get("operation").isJsonPrimitive()) {
            operationIn = object.get("operation").getAsString();
        }
        return new Instance(temperatureIn, fireTimerIn, operationIn);
    }

    @Override
    public Instance createInstance(CompoundTag nbt) {
        float temperatureIn = nbt.m_128457_("temperature");
        int fireTimerIn = nbt.m_128451_("fireTimer");
        String operationIn = nbt.m_128461_("operation");
        return new Instance(temperatureIn, fireTimerIn, operationIn);
    }

    static class Instance
    extends TemperatureChangeInstance {
        private int fireTimer;
        private String operation;

        public Instance(float temperatureIn, int fireTimerIn, String operationIn) {
            super(temperatureIn);
            this.fireTimer = fireTimerIn;
            this.operation = operationIn;
        }

        @Override
        public boolean shouldChangeTemperature(Player player) {
            if (player.m_6060_()) {
                if (this.fireTimer > 0) {
                    if (this.operation.equals("=")) {
                        return player.m_20094_() == this.fireTimer;
                    }
                    if (this.operation.equals(">=")) {
                        return player.m_20094_() >= this.fireTimer;
                    }
                    if (this.operation.equals("<=")) {
                        return player.m_20094_() <= this.fireTimer;
                    }
                    if (this.operation.equals(">")) {
                        return player.m_20094_() > this.fireTimer;
                    }
                    if (this.operation.equals("<")) {
                        return player.m_20094_() < this.fireTimer;
                    }
                    return player.m_20094_() < this.fireTimer;
                }
                return true;
            }
            return false;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128350_("temperature", this.getTemperature());
            nbt.m_128405_("fireTimer", this.fireTimer);
            nbt.m_128359_("operation", this.operation);
            return nbt;
        }

        @Override
        public Component getAdditionalContext() {
            if (this.fireTimer > 0) {
                return Component.m_237110_((String)"temperature_context.on_fire", (Object[])new Object[]{this.operation.equals("") ? "<" : this.operation, this.fireTimer});
            }
            return Component.m_237115_((String)"temperature_context.on_fire_no_timer");
        }
    }
}

