/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.core.registries.SurviveRegistries;
import com.stereowalker.survive.world.seasons.Season;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class BiomeJsonHolder
implements JsonHolder {
    private static final Marker BLOCK_TEMPERATURE_DATA = MarkerManager.getMarker((String)"BLOCK_TEMPERATURE_DATA");
    private ResourceLocation biomeID;
    private final float thirst_chance;
    private final int unwell_intensity;
    private final float temperature;
    private final float wetnessModifier;
    private final float sun_intensity;
    private final Pair<Float, Float> altitude_level_modifier;
    private final Map<Season, Float> seasonModifiers;
    String wo;

    public BiomeJsonHolder(CompoundTag nbt) {
        this.wo = "NOTHING";
        this.biomeID = VersionHelper.toLoc((String)nbt.getString("id"));
        this.thirst_chance = nbt.getFloat("thirst_chance");
        this.unwell_intensity = nbt.getInt("unwell_intensity");
        this.temperature = nbt.getFloat("temperature");
        this.wetnessModifier = nbt.getFloat("wetnessModifier");
        this.sun_intensity = nbt.getFloat("sun_intensity");
        this.altitude_level_modifier = null;
        this.seasonModifiers = null;
    }

    public BiomeJsonHolder(ResourceLocation biomeID, JsonObject object) {
        HashMap seasonModifiersIn;
        Pair altitude_level_modifierIn;
        float sunIntensitIn;
        float temperatureIn;
        block17: {
            this.wo = "NOTHING";
            String ALTITUDE_LEVEL_MODIFIER = "altitude_level_modifier";
            String SEASON_MODIFIER = "season_modifier";
            temperatureIn = 0.0f;
            sunIntensitIn = 5.0f;
            altitude_level_modifierIn = Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
            seasonModifiersIn = Maps.newHashMap();
            this.biomeID = biomeID;
            this.wetnessModifier = this.workOnFloatIfAvailable("wetness_modifier", object, 1.0f);
            this.thirst_chance = this.workOnFloatIfAvailable("thirst_chance", object, -1.0f);
            this.unwell_intensity = this.workOnIntIfAvailable("unwell_intensity", object, 3);
            if (object.entrySet().size() != 0) {
                try {
                    this.stopWorking();
                    if (this.hasMemberAndIsPrimitive("temperature", object)) {
                        temperatureIn = this.workOnFloat("temperature", object);
                    }
                    if (this.hasMemberAndIsPrimitive("sun_intensity", object)) {
                        sunIntensitIn = this.workOnFloat("sun_intensity", object);
                    }
                    if (this.hasMemberAndIsObject(SEASON_MODIFIER, object)) {
                        this.setWorkingOn(SEASON_MODIFIER);
                        for (Map.Entry elem : object.get(SEASON_MODIFIER).getAsJsonObject().entrySet()) {
                            Season season = null;
                            this.setWorkingOn((String)elem.getKey());
                            season = (Season)SurviveRegistries.SEASON.get(VersionHelper.toLoc((String)((String)elem.getKey())));
                            if (season != null) {
                                if (((JsonElement)elem.getValue()).isJsonPrimitive()) {
                                    seasonModifiersIn.put(season, Float.valueOf(((JsonElement)elem.getValue()).getAsFloat()));
                                    continue;
                                }
                                Survive.getInstance().getLogger().error("Error loading biome data {} from JSON: The season's modifier does not exist", (Object)biomeID);
                                continue;
                            }
                            Survive.getInstance().getLogger().error("Error loading biome data {} from JSON: The season {} does not exist", (Object)biomeID, (Object)VersionHelper.toLoc((String)((String)elem.getKey())));
                        }
                        this.stopWorking();
                    }
                    if (!this.hasMemberAndIsObject(ALTITUDE_LEVEL_MODIFIER, object)) break block17;
                    this.setWorkingOn(ALTITUDE_LEVEL_MODIFIER);
                    JsonObject sea = object.getAsJsonObject(ALTITUDE_LEVEL_MODIFIER);
                    if (sea.entrySet().size() != 0) {
                        this.stopWorking();
                        try {
                            if (this.hasMemberAndIsPrimitive("upper", sea)) {
                                this.setWorkingOn("upper");
                                altitude_level_modifierIn = Pair.of((Object)Float.valueOf(sea.get("upper").getAsFloat()), (Object)((Float)altitude_level_modifierIn.getSecond()));
                                this.stopWorking();
                            }
                            if (this.hasMemberAndIsPrimitive("lower", object)) {
                                this.setWorkingOn("lower");
                                altitude_level_modifierIn = Pair.of((Object)((Float)altitude_level_modifierIn.getFirst()), (Object)Float.valueOf(sea.get("lower").getAsFloat()));
                                this.stopWorking();
                            }
                        }
                        catch (ClassCastException e) {
                            Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)biomeID, (Object)this.getworkingOn());
                        }
                        catch (NumberFormatException e) {
                            Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)biomeID, (Object)this.getworkingOn());
                        }
                    }
                    this.stopWorking();
                }
                catch (ClassCastException e) {
                    Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)biomeID, (Object)this.getworkingOn());
                }
                catch (NumberFormatException e) {
                    Survive.getInstance().getLogger().warn(BLOCK_TEMPERATURE_DATA, "Loading block temperature data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)biomeID, (Object)this.getworkingOn());
                }
            }
        }
        for (Season season : SurviveRegistries.SEASON) {
            if (seasonModifiersIn.containsKey(season)) continue;
            seasonModifiersIn.put(season, Float.valueOf(season.getModifier()));
        }
        this.seasonModifiers = seasonModifiersIn;
        this.temperature = temperatureIn;
        this.sun_intensity = sunIntensitIn;
        this.altitude_level_modifier = altitude_level_modifierIn;
    }

    public ResourceLocation getItemID() {
        return this.biomeID;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getWetnessModifier() {
        return this.wetnessModifier;
    }

    public Pair<Float, Float> getAltitudeLevelModifier() {
        return this.altitude_level_modifier;
    }

    public Map<Season, Float> getSeasonModifiers() {
        return this.seasonModifiers;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("id", this.biomeID.toString());
        nbt.putInt("unwell_intensity", this.unwell_intensity);
        nbt.putFloat("thirst_chance", this.thirst_chance);
        nbt.putFloat("temperature", this.temperature);
        nbt.putFloat("wetnessModifier", this.wetnessModifier);
        nbt.putFloat("sun_intensity", this.sun_intensity);
        return nbt;
    }

    @Override
    public String getworkingOn() {
        return this.wo;
    }

    @Override
    public void setWorkingOn(String member) {
        this.wo = member;
    }

    public float getSunIntensity() {
        return this.sun_intensity;
    }

    @Override
    public JsonHolder deserialize(CompoundTag input) {
        return new BiomeJsonHolder(input);
    }

    public float getThirstChance() {
        return this.thirst_chance;
    }

    public int getUnwellIntensity() {
        return this.unwell_intensity;
    }
}

