/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.json.ConsummableJsonHolder;
import com.stereowalker.survive.needs.CustomFoodData;
import com.stereowalker.survive.needs.HygieneData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.NutritionData;
import com.stereowalker.survive.needs.SleepData;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.needs.WellbeingData;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements IRealisticEntity {
    @Shadow
    protected FoodData foodData;
    @Shadow
    private int sleepCounter;
    private TemperatureData temperatureData = new TemperatureData();
    private WellbeingData wellbeingData = new WellbeingData();
    private NutritionData nutritionData = new NutritionData();
    private HygieneData hygieneData = new HygieneData();
    private StaminaData staminaData = new StaminaData(this.getAttributeValue(SAttributes.MAX_STAMINA.holder()));
    private SleepData sleepData = new SleepData();
    private WaterData waterData = new WaterData();

    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initInject(CallbackInfo ci) {
        this.foodData = new CustomFoodData(this.foodData);
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    public void eatInject(Level pLevel, ItemStack pFood, CallbackInfoReturnable<ItemStack> cir) {
        FoodData foodData;
        if (VersionHelper.VanillaComponents.FOOD.hasData(pFood) && (foodData = this.foodData) instanceof CustomFoodData) {
            CustomFoodData custom = (CustomFoodData)foodData;
            FoodProperties foodproperties = (FoodProperties)VersionHelper.VanillaComponents.FOOD.getData(pFood);
            for (FoodProperties.PossibleEffect effect : foodproperties.effects()) {
                if (effect.effect().getEffect() != MobEffects.HUNGER && custom.IsSpoiled() != FoodUtils.State.Spoiled) continue;
                custom.consumeUnclean();
                break;
            }
        }
        this.staminaData().eat(pFood.getItem(), pFood, this);
        this.waterData().drink(pFood.getItem(), pFood, this);
        this.getRealFoodData().markAsSpoiled(pFood, this);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;updateIsUnderwater()Z")})
    public void tickInject(CallbackInfo ci) {
        SurviveEntityStats.addStatsOnSpawn((Player)this);
        if (!this.level().isClientSide && (Player)this instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)this;
            if (Survive.THIRST_CONFIG.enabled && player.level().getDifficulty() == Difficulty.PEACEFUL && player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && this.waterData().needWater() && player.tickCount % 10 == 0) {
                this.waterData().setWaterLevel(this.waterData().getWaterLevel() + 1);
            }
        }
        if (!this.level().isClientSide) {
            this.staminaData().baseTick((Player)this);
            this.hygieneData().baseTick((Player)this);
            this.nutritionData.baseTick((Player)this);
            this.temperatureData().baseTick((Player)this);
            this.waterData().baseTick((Player)this);
            this.wellbeingData.baseTick((Player)this);
            this.sleepData().baseTick((Player)this);
        }
    }

    @Redirect(method={"canEat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;needsFood()Z"))
    public boolean makeEdible(FoodData foodData) {
        if (foodData instanceof CustomFoodData) {
            return ((CustomFoodData)foodData).canConsumeFood();
        }
        return foodData.needsFood();
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"jumpFromGround"})
    public void morphExhaustionDuringJump(Player player, float value) {
        this.bypassFoodExhaustion(value, value * 2.5f, Mth.ceil((float)(value * 2.5f)), "Jumped", this.isSprinting());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"actuallyHurt"})
    public void morphExhaustion(Player player, float value) {
        this.bypassFoodExhaustion(value, value * 2.5f, Mth.ceil((float)(value * 2.5f)), "Got hurt", false);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"attack"})
    public void morphStaminaDuringAttack(Player player, float value) {
        this.bypassFoodExhaustion(value, 1.25f, Mth.ceil((float)(value * 2.5f)), "Player Attacked", true);
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/item/ItemStack;)V")})
    public void addNutrients(Level arg0, ItemStack p_213357_2_, CallbackInfoReturnable<ItemStack> cir) {
        if (Survive.CONFIG.nutrition_enabled) {
            float protein = 1.0f;
            float carbs = 1.0f;
            float fats = 1.0f;
            if (DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().getKey((Object)p_213357_2_.getItem()))) {
                ConsummableJsonHolder data = DataMaps.Server.consummableItem.get(RegistryHelper.items().getKey((Object)p_213357_2_.getItem()));
                protein = data.getProteinRatio();
                carbs = data.getCarbohydrateRatio();
                fats = data.getFatRatio();
            }
            FoodProperties food = (FoodProperties)VersionHelper.VanillaComponents.FOOD.getData(p_213357_2_);
            float total = protein + carbs + fats;
            this.nutritionData.carbs().add(food.nutrition() * Mth.ceil((float)(carbs / total * 100.0f)));
            this.nutritionData.protein().add(food.nutrition() * Mth.ceil((float)(protein / total * 100.0f)));
            this.nutritionData.fat().add(food.nutrition() * Mth.ceil((float)(fats / total * 100.0f)));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.contains("surviveData", 10)) {
            CompoundTag surviveData = pCompound.getCompound("surviveData");
            if (surviveData.contains("temperature", 10)) {
                this.temperatureData.read(surviveData.getCompound("temperature"));
            }
            if (surviveData.contains("wellbeing", 10)) {
                this.wellbeingData.read(surviveData.getCompound("wellbeing"));
            }
            if (surviveData.contains("nutrition", 10)) {
                this.nutritionData.read(surviveData.getCompound("nutrition"));
            }
            if (surviveData.contains("hygiene", 10)) {
                this.hygieneData.read(surviveData.getCompound("hygiene"));
            }
            if (surviveData.contains("stamina", 10)) {
                this.staminaData.read(surviveData.getCompound("stamina"));
            }
            if (surviveData.contains("sleep", 10)) {
                this.sleepData.read(surviveData.getCompound("sleep"));
            }
            if (surviveData.contains("water", 10)) {
                this.waterData.read(surviveData.getCompound("water"));
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        CompoundTag surviveData = new CompoundTag();
        surviveData.put("temperature", (Tag)this.temperatureData.write(false));
        surviveData.put("wellbeing", (Tag)this.wellbeingData.write(false));
        surviveData.put("nutrition", (Tag)this.nutritionData.write(false));
        surviveData.put("hygiene", (Tag)this.hygieneData.write(false));
        surviveData.put("stamina", (Tag)this.staminaData.write(false));
        surviveData.put("sleep", (Tag)this.sleepData.write(false));
        surviveData.put("water", (Tag)this.waterData.write(false));
        pCompound.put("surviveData", (Tag)surviveData);
    }

    @Override
    public StaminaData staminaData() {
        return this.staminaData;
    }

    @Override
    public void setStaminaData(StaminaData data) {
        this.staminaData = data;
    }

    @Override
    public HygieneData hygieneData() {
        return this.hygieneData;
    }

    @Override
    public void setHygieneData(HygieneData data) {
        this.hygieneData = data;
    }

    @Override
    public NutritionData nutritionData() {
        return this.nutritionData;
    }

    @Override
    public void setNutritionData(NutritionData data) {
        this.nutritionData = data;
    }

    @Override
    public TemperatureData temperatureData() {
        return this.temperatureData;
    }

    @Override
    public void setTemperatureData(TemperatureData data) {
        this.temperatureData = data;
    }

    @Override
    public WaterData waterData() {
        return this.waterData;
    }

    @Override
    public void setWaterData(WaterData data) {
        this.waterData = data;
    }

    @Override
    public WellbeingData wellbeingData() {
        return this.wellbeingData;
    }

    @Override
    public void setWellbeingData(WellbeingData data) {
        this.wellbeingData = data;
    }

    @Override
    public SleepData sleepData() {
        return this.sleepData;
    }

    @Override
    public void setSleepData(SleepData data) {
        this.sleepData = data;
    }

    @Override
    public CustomFoodData getRealFoodData() {
        if (this.foodData instanceof CustomFoodData) {
            return (CustomFoodData)this.foodData;
        }
        return null;
    }
}

