/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item.crafting;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.crafting.SRecipeSerializer;
import com.stereowalker.unionlib.util.LoaderHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CanteenFillingRecipe
extends CustomRecipe {
    public CanteenFillingRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(CraftingContainer inv, Level worldIn) {
        PotionContents savedPotion = null;
        int bottles = 0;
        int canteens = 0;
        boolean nether = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.getItem() == SItems.CANTEEN) {
                ++canteens;
            }
            if (stack.getItem() == SItems.NETHERITE_CANTEEN) {
                ++canteens;
                nether = true;
            } else if (stack.getItem() == Items.POTION) {
                if (savedPotion == null) {
                    savedPotion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                    ++bottles;
                } else {
                    if (!((Potion)((Holder)savedPotion.potion().get()).value()).equals(((Holder)((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).potion().get()).value())) return false;
                    ++bottles;
                }
            } else if (!stack.isEmpty()) {
                return false;
            }
            if (bottles <= Survive.THIRST_CONFIG.canteenFillAmount(nether)) continue;
            return false;
        }
        if (savedPotion == null) return false;
        if (bottles > Survive.THIRST_CONFIG.canteenFillAmount(nether)) return false;
        if (canteens != 1) return false;
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, HolderLookup.Provider ra) {
        int count = 0;
        PotionContents savedPotion = null;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.getItem() != Items.POTION) continue;
            ++count;
            savedPotion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        }
        if (savedPotion != null && count > 0) {
            return CanteenItem.addToCanteen(new ItemStack((ItemLike)SItems.FILLED_CANTEEN), count, savedPotion);
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList nonnulllist = NonNullList.withSize((int)pContainer.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = pContainer.getItem(i);
            if (LoaderHelper.hasCraftRemainder((ItemStack)item)) {
                nonnulllist.set(i, (Object)LoaderHelper.craftRemainder((ItemStack)item));
            }
            if (item.getItem() != Items.POTION) continue;
            nonnulllist.set(i, (Object)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SRecipeSerializer.CRAFTING_SPECIAL_CANTEEN_FILLING;
    }
}

