/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.level.block.PlatedTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.block.state.properties.SBlockStateProperties;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateSize;
import com.stereowalker.survive.world.level.block.state.properties.TempRegulationPlateType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractTemperatureRegulatorBlock
extends Block {
    public static final EnumProperty<TempRegulationPlateSize> RADIATOR_SIZE = SBlockStateProperties.TEMP_REG_SIZE;
    public static final IntegerProperty PLATE_COUNT = SBlockStateProperties.PLATE_COUNT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = DirectionalBlock.FACING;

    public AbstractTemperatureRegulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(RADIATOR_SIZE, (Comparable)((Object)TempRegulationPlateSize.SMALL))).setValue((Property)PLATE_COUNT, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace());
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public abstract boolean canAddPlate(BlockState var1, ItemStack var2);

    public abstract boolean canRemovePlates(BlockState var1);

    public abstract ItemStack getPlateStack(BlockState var1);

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int plate_count = (Integer)pState.getValue((Property)PLATE_COUNT);
        if (plate_count < 4 && this.canAddPlate(pState, pStack)) {
            return this.handlePlates(pStack, pState, pLevel, pPos, true);
        }
        if (plate_count > 0 && this.canRemovePlates(pState) && pStack.isEmpty()) {
            pPlayer.addItem(this.getPlateStack(pState));
            return this.handlePlates(pStack, pState, pLevel, pPos, false);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemInteractionResult handlePlates(ItemStack plate, BlockState pState, Level pLevel, BlockPos pPos, boolean add) {
        int plate_count = (Integer)pState.getValue((Property)PLATE_COUNT);
        int newCount = plate_count + (add ? 1 : -1);
        boolean alteredPlates = false;
        TempRegulationPlateType newState = null;
        TempRegulationPlateSize newSize = null;
        if (plate.getItem() instanceof TemperatureRegulatorPlateItem) {
            newState = ((TemperatureRegulatorPlateItem)plate.getItem()).getType();
            newSize = ((TemperatureRegulatorPlateItem)plate.getItem()).getSize();
        }
        if (add) {
            plate.shrink(1);
        }
        if (add && plate_count == 0) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)SBlocks.PLATED_TEMPERATURE_REGULATOR.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)pState.getValue((Property)FACING)))).setValue(PlatedTemperatureRegulatorBlock.TEMP_REG_TYPE, (Comparable)((Object)newState))).setValue(RADIATOR_SIZE, (Comparable)((Object)newSize))).setValue((Property)PLATE_COUNT, (Comparable)Integer.valueOf(newCount))).setValue((Property)PlatedTemperatureRegulatorBlock.POWERED, (Comparable)Boolean.valueOf(PlatedTemperatureRegulatorBlock.hasPowerInEitherDirection(pLevel, pPos, (Direction)pState.getValue((Property)FACING)))));
            alteredPlates = true;
        } else if (!add && plate_count == 1) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)SBlocks.TEMPERATURE_REGULATOR.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)pState.getValue((Property)FACING)))).setValue(RADIATOR_SIZE, (Comparable)((Object)TempRegulationPlateSize.SMALL))).setValue((Property)PLATE_COUNT, (Comparable)Integer.valueOf(0)));
            alteredPlates = true;
        } else {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)PLATE_COUNT, (Comparable)Integer.valueOf(newCount)));
            alteredPlates = true;
        }
        if (alteredPlates) {
            pLevel.playLocalSound((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f + pLevel.random.nextFloat(), 0.0f, false);
        }
        return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{RADIATOR_SIZE, FACING, PLATE_COUNT, WATERLOGGED});
    }
}

