/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FoodUtils {
    public static void giveLifespanToFood(NonNullList<ItemStack> items, long gametime) {
        if (Survive.FOOD_CONFIG.enabled) {
            items.forEach(stack -> {
                long lifespan;
                if (VersionHelper.VanillaComponents.FOOD.hasData(stack) && !SDataComponents.FOOD_STATUS_D.hasData(stack) && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)stack.m_41720_())) && (lifespan = (long)DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)stack.m_41720_())).lifespan()) > 0L) {
                    long shaveAMinuteOff = gametime - gametime % 1200L;
                    SDataComponents.FOOD_STATUS_D.setData(stack, (Object)new FoodStatus(shaveAMinuteOff, lifespan, 0.0));
                }
            });
        } else {
            items.forEach(stack -> {
                if (SDataComponents.FOOD_STATUS_D.hasData(stack)) {
                    SDataComponents.FOOD_STATUS_D.removeData(stack);
                }
            });
        }
    }

    public static void giveLifespanToFood(ItemStack stack, long gametime) {
        if (Survive.FOOD_CONFIG.enabled) {
            long lifespan;
            if (VersionHelper.VanillaComponents.FOOD.hasData(stack) && !SDataComponents.FOOD_STATUS_D.hasData(stack) && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)stack.m_41720_())) && (lifespan = (long)DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)stack.m_41720_())).lifespan()) > 0L) {
                long shaveAMinuteOff = gametime - gametime % 1200L;
                SDataComponents.FOOD_STATUS_D.setData(stack, (Object)new FoodStatus(shaveAMinuteOff, lifespan, 0.0));
            }
        } else if (SDataComponents.FOOD_STATUS_D.hasData(stack)) {
            SDataComponents.FOOD_STATUS_D.removeData(stack);
        }
    }

    public static void applyFoodStatusToTooltip(Player player, ItemStack stack, List<Component> tip) {
        if (VersionHelper.VanillaComponents.FOOD.hasData(stack)) {
            if (Survive.FOOD_CONFIG.enabled) {
                State state = FoodUtils.foodStatus(stack, player.m_9236_());
                if (state == State.Fresh) {
                    tip.add((Component)Component.m_237113_((String)"Fresh").m_6270_(Style.f_131099_.m_178520_(0x88FF88)));
                } else if (state == State.Good) {
                    tip.add((Component)Component.m_237113_((String)"Good").m_6270_(Style.f_131099_.m_178520_(65280)));
                } else if (state == State.Spoiling) {
                    tip.add((Component)Component.m_237113_((String)"Spoiling").m_6270_(Style.f_131099_.m_178520_(0xAAFF00)));
                } else if (state == State.Spoiled) {
                    tip.add((Component)Component.m_237113_((String)"Spoiled").m_6270_(Style.f_131099_.m_178520_(0x88AA00)));
                } else {
                    tip.add((Component)Component.m_237113_((String)"Okay").m_6270_(Style.f_131099_.m_178520_(0xFFFF00)));
                }
            }
            if (SDataComponents.FOOD_STATUS_D.hasData(stack)) {
                FoodStatus fd = (FoodStatus)SDataComponents.FOOD_STATUS_D.getData(stack);
                if (fd.saltDose > 500.0) {
                    tip.add((Component)Component.m_237113_((String)"Deathly Salted").m_6270_(Style.f_131099_));
                } else if (fd.saltDose > 250.0) {
                    tip.add((Component)Component.m_237113_((String)"Heavily Salted").m_6270_(Style.f_131099_));
                } else if (fd.saltDose > 125.0) {
                    tip.add((Component)Component.m_237113_((String)"Salted").m_6270_(Style.f_131099_));
                } else if (fd.saltDose > 10.0) {
                    tip.add((Component)Component.m_237113_((String)"Lightly Salted").m_6270_(Style.f_131099_));
                }
            }
        }
    }

    public static State foodStatus(ItemStack stack, Level level) {
        if (SDataComponents.FOOD_STATUS_D.hasData(stack) && (level.f_46443_ ? DataMaps.Client.consummableItem : DataMaps.Server.consummableItem).containsKey(RegistryHelper.items().m_7981_((Object)stack.m_41720_())) && Survive.FOOD_CONFIG.enabled) {
            FoodJsonHolder food = (FoodJsonHolder)(level.f_46443_ ? DataMaps.Client.consummableItem : DataMaps.Server.consummableItem).get(RegistryHelper.items().m_7981_((Object)stack.m_41720_()));
            long timeTill = ((FoodStatus)SDataComponents.FOOD_STATUS_D.getData(stack)).expireTime() - level.m_46467_();
            long timeSince = (long)food.lifespan() - timeTill;
            if (timeTill < 0L) {
                return State.Spoiled;
            }
            if (timeTill <= (long)(food.ticksFresh() * 2)) {
                return State.Spoiling;
            }
            if (timeSince <= (long)food.ticksFresh()) {
                return State.Fresh;
            }
            if (timeSince <= (long)(food.ticksFresh() * 3)) {
                return State.Good;
            }
        }
        return State.Okay;
    }

    public record FoodStatus(long creationTime, double lifespan, double saltDose) {
        public static final Codec<FoodStatus> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("creation_time").forGetter(FoodStatus::creationTime), (App)Codec.DOUBLE.fieldOf("lifespan").forGetter(FoodStatus::lifespan), (App)Codec.DOUBLE.fieldOf("salt_dose").forGetter(FoodStatus::saltDose)).apply((Applicative)builder, FoodStatus::new));

        public long expireTime() {
            return this.creationTime + (long)Math.floor(this.lifespan);
        }

        public FoodStatus extendTime(float extension) {
            return new FoodStatus(this.creationTime, this.lifespan + (double)extension, this.saltDose);
        }

        public FoodStatus increaseSalt(float extension) {
            return new FoodStatus(this.creationTime, this.lifespan, this.saltDose + (double)extension);
        }
    }

    public static enum State {
        Fresh,
        Good,
        Okay,
        Spoiling,
        Spoiled;

    }

    public static enum Saltiness {
        None,
        Light,
        Average,
        Heavy,
        Extreme;

    }
}

