/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.events;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.IBlockPropertyHandler;
import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TempEvents {
    public static final Map<ChunkPos, Map<BlockPos, Float>> GLOBAL_BLOCK_TEMPS = new ConcurrentHashMap<ChunkPos, Map<BlockPos, Float>>();
    public static final Map<BlockPos, Float> INVALID_PRE_COMPUTED_TEMPS = new ConcurrentHashMap<BlockPos, Float>();
    private static ExecutorService ex = null;
    public static Logger logger = LogManager.getLogger((String)"TempEvents");
    protected static final Map<BlockState, TempData> STATE_CACHE = new ConcurrentHashMap<BlockState, TempData>();
    protected static final Queue<Function<?, ?>> TO_PROCESS = new LinkedList();

    public static void serverStart(MinecraftServer server) {
        if (ex == null || ex.isShutdown() || ex.isTerminated()) {
            ex = Executors.newSingleThreadExecutor();
        }
    }

    public static void serverStop(MinecraftServer server) {
        ex.shutdown();
        TO_PROCESS.clear();
        GLOBAL_BLOCK_TEMPS.clear();
    }

    public static void log(String m) {
        if (LoaderHelper.isDevEnvironment()) {
            logger.info(m);
        }
    }

    public static void discardChunk(ChunkPos chunk) {
        GLOBAL_BLOCK_TEMPS.remove(chunk);
    }

    public static void invalidateBlockTemp(BlockPos block) {
        int rangeInBlocks = 5;
        for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
            for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                    BlockPos heatSource = new BlockPos(block.m_123341_() + x, block.m_123342_() + y, block.m_123343_() + z);
                    ChunkPos chunk = new ChunkPos(heatSource);
                    if (!GLOBAL_BLOCK_TEMPS.containsKey(chunk) || !GLOBAL_BLOCK_TEMPS.get(chunk).containsKey(TempEvents.local(chunk, heatSource))) continue;
                    INVALID_PRE_COMPUTED_TEMPS.put(heatSource, GLOBAL_BLOCK_TEMPS.get(chunk).remove(TempEvents.local(chunk, heatSource)));
                }
            }
        }
    }

    public static BlockPos local(ChunkPos chunk, BlockPos block) {
        return new BlockPos(block.m_123341_() - chunk.f_45578_ * 16, block.m_123342_(), block.m_123343_() - chunk.f_45579_ * 16);
    }

    public static void cacheTemp(BlockPos block, float temp) {
        ChunkPos chunk = new ChunkPos(block);
        GLOBAL_BLOCK_TEMPS.computeIfAbsent(chunk, k -> new ConcurrentHashMap());
        GLOBAL_BLOCK_TEMPS.get(chunk).put(TempEvents.local(chunk, block), Float.valueOf(temp));
    }

    public static <T> float tempOrCache(BlockPos block, T quick, T full, Function<T, Float> calc) {
        ChunkPos chunk = new ChunkPos(block);
        float temp = calc.apply(quick).floatValue();
        if (GLOBAL_BLOCK_TEMPS.containsKey(chunk) && GLOBAL_BLOCK_TEMPS.get(chunk).containsKey(TempEvents.local(chunk, block))) {
            temp = GLOBAL_BLOCK_TEMPS.get(chunk).get(TempEvents.local(chunk, block)).floatValue();
            return temp;
        }
        if (INVALID_PRE_COMPUTED_TEMPS.containsKey(block)) {
            temp = INVALID_PRE_COMPUTED_TEMPS.remove(block).floatValue();
        }
        TempEvents.cacheTemp(block, temp);
        TO_PROCESS.add(calc);
        ex.submit(() -> {
            while (TO_PROCESS.size() > 5) {
                TO_PROCESS.remove();
            }
            if (TO_PROCESS.size() > 0) {
                long start = System.nanoTime();
                TempEvents.cacheTemp(block, ((Float)TO_PROCESS.remove().apply(full)).floatValue());
                long l = System.nanoTime();
            }
        });
        return temp;
    }

    public static void buildStateCache() {
        Survive.getInstance().getLogger().info("Started Building BlockState temp cache");
        long start = System.nanoTime();
        STATE_CACHE.clear();
        for (Block block : RegistryHelper.blocks()) {
            for (BlockState state : block.m_49965_().m_61056_()) {
                if (state.m_60734_() instanceof TemperatureEmitter) continue;
                STATE_CACHE.put(state, TempEvents.computeTempDataFor(state));
            }
        }
        long end = System.nanoTime();
        Survive.getInstance().getLogger().info("Finished Building BlockState temp cache in " + (double)(end - start) / 1000000.0 + "ms");
    }

    private static TempData computeTempDataFor(BlockState heatState) {
        float blockTemp = 0.0f;
        if (DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().m_7981_((Object)heatState.m_60734_()))) {
            BlockTemperatureJsonHolder blockTemperatureData = DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().m_7981_((Object)heatState.m_60734_()));
            if (blockTemperatureData.getStateChangeProperty() != null) {
                boolean setTemp = false;
                heatState.m_60734_().m_49965_().m_61056_();
                List<Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>>> changeProperty = blockTemperatureData.getStateChangeProperty();
                block0: for (Triple<IBlockPropertyHandler<?>, List<IBlockPropertyHandler.PropertyPair<?>>, Map<String, Float>> handler : changeProperty) {
                    boolean meets = true;
                    for (IBlockPropertyHandler.PropertyPair requirements : (List)handler.getMiddle()) {
                        if (heatState.m_61143_((Property)requirements.getFirst()).equals(requirements.getSecond())) continue;
                        meets = false;
                        break;
                    }
                    if (!meets) continue;
                    for (String prop2 : ((Map)handler.getRight()).keySet()) {
                        Property property = null;
                        for (Property p : heatState.m_61147_()) {
                            if (!p.equals(((IBlockPropertyHandler)handler.getLeft()).derivedProperty())) continue;
                            property = p;
                            break;
                        }
                        if (property == null) {
                            logger.error("Could not find property {} in block {}", ((IBlockPropertyHandler)handler.getLeft()).derivedProperty(), (Object)heatState);
                            continue;
                        }
                        if (!heatState.m_61143_(property).equals(((IBlockPropertyHandler)handler.getLeft()).getValue(prop2))) continue;
                        blockTemp += ((Float)((Map)handler.getRight()).get(prop2)).floatValue();
                        setTemp = true;
                        break block0;
                    }
                }
                if (!setTemp) {
                    blockTemp += blockTemperatureData.getTemperatureModifier();
                }
            } else {
                blockTemp += blockTemperatureData.getTemperatureModifier();
                if (blockTemperatureData.usesLevelProperty()) {
                    if (heatState.m_61138_((Property)BlockStateProperties.f_61422_)) {
                        blockTemp *= (float)(((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61422_) + 1) / 16);
                    } else if (heatState.m_61138_((Property)BlockStateProperties.f_61419_)) {
                        blockTemp *= (float)(((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61419_) + 1) / 9);
                    } else if (heatState.m_61138_((Property)BlockStateProperties.f_61420_)) {
                        blockTemp *= (float)((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61420_) / 8);
                    } else if (heatState.m_61138_((Property)BlockStateProperties.f_61418_)) {
                        blockTemp *= (float)(((Integer)heatState.m_61143_((Property)BlockStateProperties.f_61418_) + 1) / 4);
                    }
                }
            }
        }
        return new TempData(blockTemp, 1.0f);
    }

    protected record TempData(float tempModifier, float conductionCoeff) {
    }

    protected static class JobEntry {
        final BlockPos pos;
        final long enqueuedAt;

        public JobEntry(BlockPos pos) {
            this.pos = pos;
            this.enqueuedAt = System.nanoTime();
        }
    }
}

