/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.json.ConsummableJsonHolder;
import com.stereowalker.survive.needs.CustomFoodData;
import com.stereowalker.survive.needs.HygieneData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.NutritionData;
import com.stereowalker.survive.needs.SleepData;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.needs.WellbeingData;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements IRealisticEntity {
    @Shadow
    protected FoodData f_36097_;
    @Shadow
    private int f_36110_;
    private TemperatureData temperatureData = new TemperatureData();
    private WellbeingData wellbeingData = new WellbeingData();
    private NutritionData nutritionData = new NutritionData();
    private HygieneData hygieneData = new HygieneData();
    private StaminaData staminaData = new StaminaData(this.m_246858_(SAttributes.MAX_STAMINA.holder()));
    private SleepData sleepData = new SleepData();
    private WaterData waterData = new WaterData();

    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initInject(CallbackInfo ci) {
        this.f_36097_ = new CustomFoodData(this.f_36097_);
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    public void eatInject(Level pLevel, ItemStack pFood, CallbackInfoReturnable<ItemStack> cir) {
        FoodData foodData;
        if (VersionHelper.VanillaComponents.FOOD.hasData(pFood) && (foodData = this.f_36097_) instanceof CustomFoodData) {
            CustomFoodData custom = (CustomFoodData)foodData;
            FoodProperties foodproperties = (FoodProperties)VersionHelper.VanillaComponents.FOOD.getData(pFood);
            for (Pair effect : foodproperties.m_38749_()) {
                if (((MobEffectInstance)effect.getFirst()).m_19544_() != MobEffects.f_19612_ && custom.IsSpoiled() != FoodUtils.State.Spoiled) continue;
                custom.consumeUnclean();
                break;
            }
        }
        this.staminaData().eat(pFood.m_41720_(), pFood, this);
        this.waterData().drink(pFood.m_41720_(), pFood, this);
        this.getRealFoodData().markAsSpoiled(pFood, this);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;updateIsUnderwater()Z")})
    public void tickInject(CallbackInfo ci) {
        SurviveEntityStats.addStatsOnSpawn((Player)this);
        if (!this.m_9236_().f_46443_ && (Player)this instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)this;
            if (Survive.THIRST_CONFIG.enabled && player.m_9236_().m_46791_() == Difficulty.PEACEFUL && player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && this.waterData().needWater() && player.f_19797_ % 10 == 0) {
                this.waterData().setWaterLevel(this.waterData().getWaterLevel() + 1);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.staminaData().baseTick((Player)this);
            this.hygieneData().baseTick((Player)this);
            this.nutritionData.baseTick((Player)this);
            this.temperatureData().baseTick((Player)this);
            this.waterData().baseTick((Player)this);
            this.wellbeingData.baseTick((Player)this);
            this.sleepData().baseTick((Player)this);
        }
    }

    @Redirect(method={"canEat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;needsFood()Z"))
    public boolean makeEdible(FoodData foodData) {
        if (foodData instanceof CustomFoodData) {
            return ((CustomFoodData)foodData).canConsumeFood();
        }
        return foodData.m_38721_();
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"jumpFromGround"})
    public void morphExhaustionDuringJump(Player player, float value) {
        this.bypassFoodExhaustion(value, value * 2.5f, Mth.m_14167_((float)(value * 2.5f)), "Jumped", this.m_20142_());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"actuallyHurt"})
    public void morphExhaustion(Player player, float value) {
        this.bypassFoodExhaustion(value, value * 2.5f, Mth.m_14167_((float)(value * 2.5f)), "Got hurt", false);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"attack"})
    public void morphStaminaDuringAttack(Player player, float value) {
        this.bypassFoodExhaustion(value, 1.25f, Mth.m_14167_((float)(value * 2.5f)), "Player Attacked", true);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"checkMovementStatistics"})
    public void morphExhaustionMovement(Player player, float value) {
        this.bypassFoodExhaustion(value, value * 2.5f, Mth.m_14167_((float)(value * 2.5f)), "Movement", player.m_20142_() || player.m_6069_());
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V")})
    public void addNutrients(Level arg0, ItemStack p_213357_2_, CallbackInfoReturnable<ItemStack> cir) {
        if (Survive.CONFIG.nutrition_enabled) {
            float protein = 1.0f;
            float carbs = 1.0f;
            float fats = 1.0f;
            if (DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)p_213357_2_.m_41720_()))) {
                ConsummableJsonHolder data = DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)p_213357_2_.m_41720_()));
                protein = data.getProteinRatio();
                carbs = data.getCarbohydrateRatio();
                fats = data.getFatRatio();
            }
            FoodProperties food = (FoodProperties)VersionHelper.VanillaComponents.FOOD.getData(p_213357_2_);
            float total = protein + carbs + fats;
            this.nutritionData.carbs().add(food.m_38744_() * Mth.m_14167_((float)(carbs / total * 100.0f)));
            this.nutritionData.protein().add(food.m_38744_() * Mth.m_14167_((float)(protein / total * 100.0f)));
            this.nutritionData.fat().add(food.m_38744_() * Mth.m_14167_((float)(fats / total * 100.0f)));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.m_128425_("surviveData", 10)) {
            CompoundTag surviveData = pCompound.m_128469_("surviveData");
            if (surviveData.m_128425_("temperature", 10)) {
                this.temperatureData.read(surviveData.m_128469_("temperature"));
            }
            if (surviveData.m_128425_("wellbeing", 10)) {
                this.wellbeingData.read(surviveData.m_128469_("wellbeing"));
            }
            if (surviveData.m_128425_("nutrition", 10)) {
                this.nutritionData.read(surviveData.m_128469_("nutrition"));
            }
            if (surviveData.m_128425_("hygiene", 10)) {
                this.hygieneData.read(surviveData.m_128469_("hygiene"));
            }
            if (surviveData.m_128425_("stamina", 10)) {
                this.staminaData.read(surviveData.m_128469_("stamina"));
            }
            if (surviveData.m_128425_("sleep", 10)) {
                this.sleepData.read(surviveData.m_128469_("sleep"));
            }
            if (surviveData.m_128425_("water", 10)) {
                this.waterData.read(surviveData.m_128469_("water"));
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        CompoundTag surviveData = new CompoundTag();
        surviveData.m_128365_("temperature", (Tag)this.temperatureData.write(false));
        surviveData.m_128365_("wellbeing", (Tag)this.wellbeingData.write(false));
        surviveData.m_128365_("nutrition", (Tag)this.nutritionData.write(false));
        surviveData.m_128365_("hygiene", (Tag)this.hygieneData.write(false));
        surviveData.m_128365_("stamina", (Tag)this.staminaData.write(false));
        surviveData.m_128365_("sleep", (Tag)this.sleepData.write(false));
        surviveData.m_128365_("water", (Tag)this.waterData.write(false));
        pCompound.m_128365_("surviveData", (Tag)surviveData);
    }

    @Override
    public StaminaData staminaData() {
        return this.staminaData;
    }

    @Override
    public void setStaminaData(StaminaData data) {
        this.staminaData = data;
    }

    @Override
    public HygieneData hygieneData() {
        return this.hygieneData;
    }

    @Override
    public void setHygieneData(HygieneData data) {
        this.hygieneData = data;
    }

    @Override
    public NutritionData nutritionData() {
        return this.nutritionData;
    }

    @Override
    public void setNutritionData(NutritionData data) {
        this.nutritionData = data;
    }

    @Override
    public TemperatureData temperatureData() {
        return this.temperatureData;
    }

    @Override
    public void setTemperatureData(TemperatureData data) {
        this.temperatureData = data;
    }

    @Override
    public WaterData waterData() {
        return this.waterData;
    }

    @Override
    public void setWaterData(WaterData data) {
        this.waterData = data;
    }

    @Override
    public WellbeingData wellbeingData() {
        return this.wellbeingData;
    }

    @Override
    public void setWellbeingData(WellbeingData data) {
        this.wellbeingData = data;
    }

    @Override
    public SleepData sleepData() {
        return this.sleepData;
    }

    @Override
    public void setSleepData(SleepData data) {
        this.sleepData = data;
    }

    @Override
    public CustomFoodData getRealFoodData() {
        if (this.f_36097_ instanceof CustomFoodData) {
            return (CustomFoodData)this.f_36097_;
        }
        return null;
    }
}

