/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.needs.Stamina;
import com.stereowalker.survive.core.WeightHandler;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.network.protocol.game.ServerboundArmorStaminaPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundRelaxPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundStaminaExhaustionPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.unionlib.api.insert.InsertResultCanceller;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Random;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class StaminaData
extends SurviveData
implements Stamina {
    private int longStamina;
    private int shortStamina;
    private int energyReserveLevel = 6;
    private float longExhaustion;
    private float shortExhaustion;
    private int energyTimer;
    private int shortTermTimer;
    private int shortRecoveryTimer;
    private boolean isStraining;
    private int prevEnergyLevel;
    private int maxLongStamina;
    private int maxBurstStamina = 10;

    public StaminaData(double maxStamina) {
        this.longStamina = Mth.m_14107_((double)maxStamina);
        this.prevEnergyLevel = Mth.m_14107_((double)maxStamina);
        this.shortStamina = this.maxBurstStamina;
    }

    public void relax(int energyLevelIn, double maxStamina) {
        int remaining = 0;
        remaining = this.energyReserveLevel + energyLevelIn - 6;
        this.energyReserveLevel = Math.min(energyLevelIn + this.energyReserveLevel, 6);
        if (remaining > 0) {
            this.longStamina = Math.min(remaining + this.longStamina, Mth.m_14107_((double)maxStamina));
        }
    }

    public void eat(Item pItem, ItemStack pStack, LivingEntity entity) {
        if (VersionHelper.VanillaComponents.FOOD.hasData(pStack) && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().m_7981_((Object)pItem)) && entity instanceof ServerPlayer && !entity.m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)entity;
            this.relax(DataMaps.Server.consummableItem.get(RegistryHelper.items().m_7981_((Object)pItem)).getEnergyAmount(), player.m_246858_(SAttributes.MAX_STAMINA.holder()));
        }
    }

    @Override
    public void clientTick(Player player) {
        if (player.m_20159_() && player.f_19797_ % 400 == 399 && player.m_20202_().m_20184_().f_82479_ == 0.0 && player.m_20202_().m_20184_().f_82481_ == 0.0) {
            new ServerboundRelaxPacket(1).send();
        }
        if (player.f_19797_ % 90 == 89 && player.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
            new ServerboundArmorStaminaPacket().send();
        }
    }

    @Override
    public void tick(Player player) {
        IRealisticEntity realPlayer = (IRealisticEntity)player;
        this.maxLongStamina = Mth.m_14107_((double)player.m_246858_(SAttributes.MAX_STAMINA.holder()));
        if (player.m_5803_() && player.m_9236_().m_46461_() && this.longStamina < this.maxLongStamina / 2) {
            player.f_36110_ = 0;
        }
        Difficulty difficulty = player.m_9236_().m_46791_();
        int energyToRegen = 1 + (player.m_21023_((MobEffect)SMobEffects.WELL_FED.holder().m_203334_()) ? new Random().nextInt(2) : 0);
        this.prevEnergyLevel = this.longStamina;
        if (this.longExhaustion > 20.0f) {
            this.longExhaustion -= 20.0f;
            if (difficulty != Difficulty.PEACEFUL) {
                if (this.longStamina > 0) {
                    this.longStamina = Math.max(this.longStamina - 1, 0);
                } else if (this.energyReserveLevel > 0) {
                    this.energyReserveLevel = Math.max(this.energyReserveLevel - 1, 0);
                }
            }
        }
        if (!this.isStraining && this.shortTermTimer > 0) {
            this.isStraining = true;
            this.maxBurstStamina = 10;
            if (Survive.CONFIG.nutrition_enabled) {
                int carb = realPlayer.nutritionData().carbs().level();
                this.maxBurstStamina = carb > 2000 ? Mth.m_269140_((float)((float)(carb - 2000) / 1000.0f), (int)12, (int)20) : (carb > 1000 ? Mth.m_269140_((float)((float)(carb - 1000) / 1000.0f), (int)7, (int)12) : (carb > 0 ? Mth.m_269140_((float)((float)carb / 2000.0f), (int)3, (int)7) : Mth.m_269140_((float)((float)(1000 + carb) / 1000.0f), (int)1, (int)3)));
            }
            this.shortExhaustion = 0.0f;
            this.shortStamina = this.maxBurstStamina;
        } else if (this.isStraining && this.shortTermTimer > 0) {
            --this.shortTermTimer;
            if (this.shortExhaustion > 5.0f) {
                this.shortExhaustion -= 5.0f;
                if (difficulty != Difficulty.PEACEFUL && this.shortStamina > 0) {
                    this.shortStamina = Math.max(this.shortStamina - 1, 0);
                }
            }
            if (this.shortStamina <= 0) {
                this.shortTermTimer = 0;
            }
        } else if (!this.isStraining && this.shortTermTimer <= 0) {
            --this.shortRecoveryTimer;
        } else if (this.isStraining && this.shortTermTimer <= 0) {
            this.isStraining = false;
            this.shortRecoveryTimer = this.maxBurstStamina - this.shortStamina;
            this.addExhaustion((float)this.shortRecoveryTimer * 7.8f, false);
            realPlayer.nutritionData().carbs().remove(this.shortRecoveryTimer * 10);
            this.shortRecoveryTimer *= 13;
            player.m_7292_(new MobEffectInstance((MobEffect)SMobEffects.FATIGUE.holder().m_203334_(), this.shortRecoveryTimer, 1, false, true));
        }
        if (this.isTired() && Survive.CONFIG.nutrition_enabled && ((IRealisticEntity)player).nutritionData().fat().level() >= 20) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxLongStamina);
                realPlayer.nutritionData().fat().remove(20);
                this.energyTimer = 0;
            }
        } else if (this.isTired() && !Survive.CONFIG.nutrition_enabled && player.m_36324_().m_38702_() > Survive.STAMINA_CONFIG.min_food && WeightHandler.getTotalArmorWeight((LivingEntity)player) / Survive.STAMINA_CONFIG.max_weight < 1.0f) {
            ++this.energyTimer;
            if (Survive.STAMINA_CONFIG.stamina_recovery_ticks == 0 || this.energyTimer >= Survive.STAMINA_CONFIG.stamina_recovery_ticks) {
                this.relax(energyToRegen, this.maxLongStamina);
                player.m_36324_().m_38703_(2.0f);
                this.energyTimer = 0;
            }
        } else if (player.m_5803_()) {
            ++this.energyTimer;
            if ((double)this.energyTimer >= Math.floor((float)Survive.STAMINA_CONFIG.sleepTime / (float)(this.maxLongStamina + 6))) {
                this.relax(energyToRegen, this.maxLongStamina);
                this.energyTimer = 0;
            }
        } else if (this.longStamina <= 0 && this.energyReserveLevel <= 0) {
            ++this.energyTimer;
            if (this.energyTimer >= 20) {
                player.m_6469_(SDamageSources.source(player.m_9236_().m_9598_(), SDamageTypes.OVERWORK), 3.0f);
                this.energyTimer = 0;
            }
        } else {
            this.energyTimer = 0;
        }
        if (difficulty == Difficulty.PEACEFUL && player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && this.isTired() && player.f_19797_ % 10 == 0) {
            this.setEnergyLevel(this.getLTS() + 1);
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("longStamina", 99)) {
            this.maxBurstStamina = compound.m_128451_("maxBurstStamina");
            this.maxLongStamina = compound.m_128451_("maxLongStamina");
            this.longStamina = compound.m_128451_("longStamina");
            this.longExhaustion = compound.m_128457_("longExhaustion");
            this.shortStamina = compound.m_128451_("shortStamina");
            this.shortExhaustion = compound.m_128457_("shortExhaustion");
            this.shortTermTimer = compound.m_128451_("shortTermTimer");
            this.shortRecoveryTimer = compound.m_128451_("shortRecoveryTimer");
            this.isStraining = compound.m_128471_("isStraining");
            this.energyTimer = compound.m_128451_("energyTickTimer");
            this.energyReserveLevel = compound.m_128451_("energyReserveLevel");
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.m_128405_("maxBurstStamina", this.maxBurstStamina);
        compound.m_128405_("maxLongStamina", this.maxLongStamina);
        compound.m_128405_("longStamina", this.longStamina);
        compound.m_128405_("shortStamina", this.shortStamina);
        compound.m_128379_("isStraining", this.isStraining);
        compound.m_128405_("energyReserveLevel", this.energyReserveLevel);
        if (!reducedData) {
            compound.m_128350_("shortExhaustion", this.shortExhaustion);
            compound.m_128350_("longExhaustion", this.longExhaustion);
            compound.m_128405_("energyTickTimer", this.energyTimer);
            compound.m_128405_("shortTermTimer", this.shortTermTimer);
        }
        compound.m_128405_("shortRecoveryTimer", this.shortRecoveryTimer);
    }

    public int getLTS() {
        return this.longStamina;
    }

    @Override
    public int getBurstStamina() {
        return this.shortStamina;
    }

    public int getSTSRecovery() {
        return this.maxBurstStamina - Mth.m_14143_((float)((float)this.shortRecoveryTimer / 13.0f));
    }

    public boolean isTired() {
        return this.longStamina < this.maxLongStamina;
    }

    public boolean isExerting() {
        return this.isStraining;
    }

    @Override
    public boolean isShortOfBreath() {
        return this.shortRecoveryTimer > 0;
    }

    @Override
    public boolean isDeadTired() {
        return this.longStamina <= 0;
    }

    public void addExhaustion(float exhaustion, boolean strain) {
        if (strain && !this.isShortOfBreath()) {
            this.shortExhaustion = Math.min(this.shortExhaustion + exhaustion, 40.0f);
            this.shortTermTimer = 100;
        } else {
            this.longExhaustion = Math.min(this.longExhaustion + exhaustion, 40.0f);
        }
    }

    public int getReserveLevel() {
        return this.energyReserveLevel;
    }

    public void setEnergyLevel(int energyLevelIn) {
        this.longStamina = energyLevelIn;
    }

    public void setEnergyReserveLevel(int energyReserveLevelIn) {
        this.energyReserveLevel = energyReserveLevelIn;
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.STAMINA_CONFIG.enabled;
    }

    public static void clickItem(Player player, Level level, InteractionHand hand, InsertResultCanceller<InteractionResultHolder<ItemStack>> cancel) {
        if (cancel.wasCancelled() || !(player instanceof Player) || ((InteractionResultHolder)cancel.cancelResult()).m_19089_().m_19077_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void rightClickEmpty(PlayerInteractEvent.RightClickEmpty clickItem) {
        if (!clickItem.isCanceled() && clickItem.getEntity() instanceof LocalPlayer && clickItem.getCancellationResult().m_19077_()) {
            new ServerboundStaminaExhaustionPacket(0.3125f).send();
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty clickItem) {
        if (!clickItem.isCanceled() && clickItem.getEntity() instanceof LocalPlayer && clickItem.getCancellationResult().m_19077_()) {
            new ServerboundStaminaExhaustionPacket(0.3125f).send();
        }
    }

    @SubscribeEvent
    public static void replenishEnergyOnSleep(SleepFinishedTimeEvent event) {
        for (Player player : event.getLevel().m_6907_()) {
            StaminaData energyStats = ((IRealisticEntity)player).staminaData();
            int staminaToRecover = Mth.m_14167_((float)((float)(event.getNewTime() - event.getLevel().m_8044_()) / (float)Survive.STAMINA_CONFIG.sleepTime * (float)(energyStats.maxLongStamina + 6)));
            energyStats.relax(staminaToRecover, player.m_246858_(SAttributes.MAX_STAMINA.holder()));
        }
    }
}

