/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.google.common.collect.Maps;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.needs.Temperature;
import com.stereowalker.survive.hooks.SurviveHooks;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.temperature.TemperatureModifier;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;

public class TemperatureData
extends SurviveData
implements Temperature {
    private double temperatureLevel = 0.0;
    private double displayTemperature = 0.0;
    private int temperatureTimer;
    private double targetTemperature = 0.0;
    private int hypTimer = 0;
    private Map<ResourceLocation, TemperatureModifier> temperatureModifiers = Maps.newHashMap();
    private Map<TemperatureModifier.ContributingFactor, Double> factors = Maps.newHashMap();

    public TemperatureData() {
        this.hypTimer = Survive.TEMPERATURE_CONFIG.tempGrace;
        this.temperatureLevel = 37.0;
    }

    public void addHeat(float heatLevel, double max) {
        this.temperatureLevel = Math.min(this.temperatureLevel + (double)heatLevel, max);
    }

    public void addCold(float coldLevel, double max) {
        this.temperatureLevel = Math.max(this.temperatureLevel - (double)coldLevel, max);
    }

    private boolean addTemperature(ServerPlayer player, double temperature) {
        if (Survive.TEMPERATURE_CONFIG.enabled) {
            if (player.f_8941_.m_9294_()) {
                double defaultT = 37.0;
                double maxHeat1 = TemperatureUtil.firstHeat((Player)player);
                double maxHeat2 = TemperatureUtil.secondHeat((Player)player);
                double maxHeat3 = TemperatureUtil.maxHeat((Player)player);
                double maxCold1 = TemperatureUtil.firstCold((Player)player);
                double maxCold2 = TemperatureUtil.secondCold((Player)player);
                double maxCold3 = TemperatureUtil.maxCold((Player)player);
                this.temperatureLevel = this.temperatureLevel > defaultT && this.temperatureLevel <= maxHeat1 ? (temperature < 0.0 ? (this.temperatureLevel += temperature * 1.5) : (this.temperatureLevel += temperature)) : (this.temperatureLevel > maxHeat1 && this.temperatureLevel <= maxHeat2 ? (temperature < 0.0 ? (this.temperatureLevel += temperature) : (this.temperatureLevel += temperature / 10.0)) : (this.temperatureLevel > maxHeat2 && this.temperatureLevel <= maxHeat3 ? (temperature < 0.0 ? (this.temperatureLevel += temperature / 10.0) : (this.temperatureLevel += temperature / 100.0)) : (this.temperatureLevel > maxHeat3 ? (temperature < 0.0 ? (this.temperatureLevel += temperature / 100.0) : maxHeat3) : (this.temperatureLevel < defaultT && this.temperatureLevel >= maxCold1 ? (temperature > 0.0 ? (this.temperatureLevel += temperature * 1.5) : (this.temperatureLevel += temperature)) : (this.temperatureLevel < maxCold1 && this.temperatureLevel >= maxCold2 ? (temperature > 0.0 ? (this.temperatureLevel += temperature) : (this.temperatureLevel += temperature / 10.0)) : (this.temperatureLevel < maxCold2 && this.temperatureLevel >= maxCold3 ? (temperature > 0.0 ? (this.temperatureLevel += temperature / 10.0) : (this.temperatureLevel += temperature / 100.0)) : (this.temperatureLevel < maxCold3 ? (temperature < 0.0 ? (this.temperatureLevel += temperature / 100.0) : maxCold3) : (this.temperatureLevel += temperature))))))));
                return true;
            }
        } else {
            this.temperatureLevel = 37.0;
        }
        return false;
    }

    public void addModifier(TemperatureModifier modifier) {
        if (!this.temperatureModifiers.containsKey(modifier.getId())) {
            this.temperatureModifiers.put(modifier.getId(), modifier);
        }
    }

    public TemperatureModifier getOrCreateModifier(ResourceLocation location) {
        if (!this.temperatureModifiers.containsKey(location)) {
            this.addModifier(new TemperatureModifier(location, 0.0));
        }
        return this.temperatureModifiers.get(location);
    }

    public static void setTemperatureModifier(LivingEntity entity, String id, double value, TemperatureModifier.ContributingFactor factor) {
        TemperatureData.setTemperatureModifier(entity, VersionHelper.toLoc((String)id), value, factor);
    }

    public static void setTemperatureModifier(LivingEntity entity, ResourceLocation id, double value, TemperatureModifier.ContributingFactor factor) {
        TemperatureData temp = ((IRealisticEntity)entity).temperatureData();
        TemperatureModifier mod = SurviveHooks.getTemperatureModifer(entity, new TemperatureModifier(id, value, factor));
        temp.getOrCreateModifier(id).setMod(mod.getMod()).setFactor(mod.getFactor());
    }

    @Override
    public void tick(Player player) {
        double div;
        double maxTemp;
        double tempLocation;
        double calculatedTarget = 37.0;
        Arrays.asList(TemperatureModifier.ContributingFactor.values()).forEach(f -> this.factors.put((TemperatureModifier.ContributingFactor)((Object)f), 0.0));
        for (TemperatureModifier modifier : this.temperatureModifiers.values()) {
            calculatedTarget += modifier.getMod();
            this.factors.put(modifier.getFactor(), this.factors.get((Object)modifier.getFactor()) + modifier.getMod());
        }
        this.targetTemperature = calculatedTarget;
        double mod = (this.targetTemperature - this.temperatureLevel) * Survive.TEMPERATURE_CONFIG.tempChangeSpeed;
        if (player instanceof ServerPlayer) {
            this.addTemperature((ServerPlayer)player, mod);
        }
        if ((tempLocation = this.temperatureLevel - 37.0) > 0.0) {
            maxTemp = 0.0;
            if (player.m_21051_((Attribute)SAttributes.HEAT_RESISTANCE.holder().m_203334_()) != null) {
                maxTemp = player.m_246858_(SAttributes.HEAT_RESISTANCE.holder());
            }
            div = tempLocation / maxTemp;
            this.displayTemperature = Mth.m_14008_((double)div, (double)0.0, (double)1.4444444444444444);
        }
        if (tempLocation < 0.0) {
            maxTemp = 0.0;
            if (player.m_21051_((Attribute)SAttributes.COLD_RESISTANCE.holder().m_203334_()) != null) {
                maxTemp = player.m_246858_(SAttributes.COLD_RESISTANCE.holder());
            }
            div = tempLocation / maxTemp;
            this.displayTemperature = Mth.m_14008_((double)div, (double)-1.4444444444444444, (double)0.0);
        }
        if (!player.m_7500_() && !player.m_5833_() && Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem) {
            double maxHeat1 = TemperatureUtil.firstHeat(player);
            double maxHeat2 = TemperatureUtil.secondHeat(player);
            double maxHeat3 = TemperatureUtil.maxHeat(player);
            double maxCold1 = TemperatureUtil.firstCold(player);
            double maxCold2 = TemperatureUtil.secondCold(player);
            double maxCold3 = TemperatureUtil.maxCold(player);
            if (this.temperatureLevel > maxHeat1 || this.temperatureLevel < maxCold1) {
                if (this.hypTimer > 0) {
                    --this.hypTimer;
                } else if (this.hypTimer == 0) {
                    // empty if block
                }
            } else if (this.hypTimer < Survive.TEMPERATURE_CONFIG.tempGrace) {
                ++this.hypTimer;
            }
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("temperatureLevel", 99)) {
            this.temperatureLevel = compound.m_128459_("temperatureLevel");
            this.targetTemperature = compound.m_128459_("targetTemperature");
            this.temperatureTimer = compound.m_128451_("temperatureTickTimer");
            this.displayTemperature = compound.m_128459_("displayTemperature");
            this.hypTimer = compound.m_128451_("hypTimer");
            ListTag modifiers = compound.m_128437_("modifiers", 10);
            HashMap temperatureModifiers = Maps.newHashMap();
            for (int i = 0; i < modifiers.size(); ++i) {
                CompoundTag nbt = modifiers.m_128728_(i);
                TemperatureModifier modifier = new TemperatureModifier();
                modifier.read(nbt);
                temperatureModifiers.put(modifier.getId(), modifier);
            }
            this.temperatureModifiers = temperatureModifiers;
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.m_128347_("temperatureLevel", this.temperatureLevel);
        compound.m_128347_("targetTemperature", this.targetTemperature);
        compound.m_128405_("temperatureTickTimer", this.temperatureTimer);
        compound.m_128347_("displayTemperature", this.displayTemperature);
        compound.m_128405_("hypTimer", this.hypTimer);
        ListTag modifiers = new ListTag();
        for (TemperatureModifier modifier : this.temperatureModifiers.values()) {
            modifiers.add((Object)modifier.write(new CompoundTag()));
        }
        compound.m_128365_("modifiers", (Tag)modifiers);
    }

    public double getTemperatureLevel() {
        return this.temperatureLevel;
    }

    public float getCelcius() {
        int temp = (int)(this.temperatureLevel * 100.0);
        return (float)temp / 100.0f;
    }

    public float getFahrenheit() {
        float rawFTemp = this.getCelcius() * 1.8f + 32.0f;
        int fTemp = (int)(rawFTemp * 100.0f);
        return (float)fTemp / 100.0f;
    }

    @Override
    public double getDisplayTemperature() {
        return this.displayTemperature;
    }

    public double getTargetTemperature() {
        return this.targetTemperature;
    }

    public void setTemperatureLevel(int temperatureLevelIn) {
        this.temperatureLevel = temperatureLevelIn;
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.TEMPERATURE_CONFIG.enabled;
    }
}

