/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ClientboundSurvivalStatsPacket
extends ClientboundUnionPacket {
    private CompoundTag stats;
    private boolean legacyStats;
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"clientbound_survival_stats");

    public ClientboundSurvivalStatsPacket(CompoundTag statsIn, boolean legacyStats) {
        super(Survive.getInstance().channel);
        this.stats = statsIn;
        this.legacyStats = legacyStats;
    }

    public ClientboundSurvivalStatsPacket(ServerPlayer player, boolean legacyStats) {
        this(legacyStats ? SurviveEntityStats.getModNBT((Entity)player) : ClientboundSurvivalStatsPacket.tag((IRealisticEntity)player), legacyStats);
    }

    public static CompoundTag tag(IRealisticEntity player) {
        CompoundTag surviveData = new CompoundTag();
        surviveData.m_128365_("temperature", (Tag)player.temperatureData().write(true));
        surviveData.m_128365_("wellbeing", (Tag)player.wellbeingData().write(true));
        surviveData.m_128365_("nutrition", (Tag)player.nutritionData().write(true));
        surviveData.m_128365_("hygiene", (Tag)player.hygieneData().write(true));
        surviveData.m_128365_("stamina", (Tag)player.staminaData().write(true));
        surviveData.m_128365_("sleep", (Tag)player.sleepData().write(true));
        surviveData.m_128365_("water", (Tag)player.waterData().write(true));
        return surviveData;
    }

    public ClientboundSurvivalStatsPacket(FriendlyByteBuf byteBuf) {
        super(byteBuf, Survive.getInstance().channel);
        this.stats = byteBuf.m_130260_();
        this.legacyStats = byteBuf.readBoolean();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.m_130079_(this.stats);
        byteBuf.writeBoolean(this.legacyStats);
    }

    public boolean runOnClient(Player sender) {
        if (this.legacyStats) {
            SurviveEntityStats.setModNBT(this.stats, (Entity)sender);
        } else {
            IRealisticEntity player = (IRealisticEntity)sender;
            if (this.stats.m_128425_("temperature", 10)) {
                player.temperatureData().read(this.stats.m_128469_("temperature"));
            }
            if (this.stats.m_128425_("wellbeing", 10)) {
                player.wellbeingData().read(this.stats.m_128469_("wellbeing"));
            }
            if (this.stats.m_128425_("nutrition", 10)) {
                player.nutritionData().read(this.stats.m_128469_("nutrition"));
            }
            if (this.stats.m_128425_("hygiene", 10)) {
                player.hygieneData().read(this.stats.m_128469_("hygiene"));
            }
            if (this.stats.m_128425_("stamina", 10)) {
                player.staminaData().read(this.stats.m_128469_("stamina"));
            }
            if (this.stats.m_128425_("sleep", 10)) {
                player.sleepData().read(this.stats.m_128469_("sleep"));
            }
            if (this.stats.m_128425_("water", 10)) {
                player.waterData().read(this.stats.m_128469_("water"));
            }
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

