/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Items;

public class ServerboundPlayerStatusBookPacket
extends ServerboundUnionPacket {
    private CompoundTag book;
    private boolean celcius;
    private String sleepPage;
    private String tempPage;
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"serverbound_player_status_book");

    public ServerboundPlayerStatusBookPacket(CompoundTag book, boolean celcius, String sleepPage, String tempPage) {
        super(Survive.getInstance().channel);
        this.book = book;
        this.celcius = celcius;
        this.sleepPage = sleepPage;
        this.tempPage = tempPage;
    }

    public ServerboundPlayerStatusBookPacket(FriendlyByteBuf byteBuf) {
        super(byteBuf, Survive.getInstance().channel);
        this.book = byteBuf.m_130261_();
        this.celcius = byteBuf.readBoolean();
        this.sleepPage = byteBuf.m_130277_();
        this.tempPage = byteBuf.m_130277_();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.m_130079_(this.book);
        byteBuf.writeBoolean(this.celcius);
        byteBuf.m_130070_(this.sleepPage);
        byteBuf.m_130070_(this.tempPage);
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (sender.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(Items.f_42615_) && sender instanceof IRealisticEntity) {
            IRealisticEntity real = (IRealisticEntity)sender;
            CompoundTag compoundtag = this.book;
            ListTag contents = compoundtag.m_128437_("pages", 8);
            int pages = 6;
            if (contents.size() < pages) {
                while (contents.size() < pages) {
                    contents.add(contents.size(), (Tag)StringTag.m_129297_((String)""));
                }
            }
            String status0 = "\u00a72\u00a7nGeneral:\u00a7r\nWater Level = " + real.waterData().getWaterLevel() + "\nHydration = " + real.waterData().getHydrationLevel() + "\nFood Level = " + sender.m_36324_().m_38702_() + "\nSaturation Level = " + sender.m_36324_().m_38722_() + "\nEnergy Level = " + real.staminaData().getLTS();
            Object status1 = "\u00a72\u00a7nWellness:\u00a7r\n";
            status1 = real.wellbeingData().isWell() ? (String)status1 + "No ilnesses dectected" : (String)status1 + "Intensity = " + (real.wellbeingData().getIntensity() + 1) + "\nReason = " + real.wellbeingData().getReason() + "\n";
            Object status3 = "\u00a72\u00a7nHygiene:\u00a7r\n";
            status3 = (String)status3 + "Cleanliness level = " + (100 - real.hygieneData().getUncleanLevel());
            Object status4 = "\u00a72\u00a7nNutrition:\u00a7r\n";
            status4 = (String)status4 + "Carbohydrates = " + real.nutritionData().carbs().level() + "\nProteins = " + real.nutritionData().protein().level() + "\nFats = " + real.nutritionData().fat().level() + "\n";
            Function<String, Tag> ft = s -> StringTag.m_129297_((String)("{\"text\":\"" + s.replaceAll("\n", "\\\\n") + "\"}"));
            contents.set(0, ft.apply(status0));
            contents.set(1, ft.apply((String)status1));
            contents.set(2, ft.apply(String.format(this.sleepPage, Float.valueOf(real.sleepData().getDaysAwake()))));
            contents.set(3, ft.apply((String)status3));
            contents.set(4, ft.apply((String)status4));
            contents.set(5, ft.apply(String.format(this.tempPage, !this.celcius ? real.temperatureData().getFahrenheit() + " \u00b0F" : real.temperatureData().getCelcius() + " \u00b0C")));
            compoundtag.m_128365_("pages", (Tag)contents);
            sender.m_21120_(InteractionHand.MAIN_HAND).m_41751_(compoundtag);
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

