/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.EntityTemperatureJsonHolder;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTemperatureDataManager
implements IResourceReloadListener<Map<ResourceLocation, EntityTemperatureJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, EntityTemperatureJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, EntityTemperatureJsonHolder> drinkMap = new HashMap<ResourceLocation, EntityTemperatureJsonHolder>();
            for (Map.Entry resource : manager.m_214159_("survive_modifiers/entities", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation entityId = VersionHelper.toLoc((String)((ResourceLocation)resource.getKey()).m_135827_(), (String)((ResourceLocation)resource.getKey()).m_135815_().replace("survive_modifiers/entities/", "").replace(".json", ""));
                if (ForgeRegistries.ENTITY_TYPES.containsKey(entityId)) {
                    try (InputStream stream = ((Resource)resource.getValue()).m_215507_();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        EntityTemperatureJsonHolder blockData = new EntityTemperatureJsonHolder(entityId, object);
                        Survive.getInstance().getLogger().info("Found entity temperature modifier for the entity " + entityId);
                        drinkMap.put(entityId, blockData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading the entity temperature modifier for the entity " + entityId + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such entity exists with the entity id " + entityId + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, EntityTemperatureJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation drinkId : data.keySet()) {
                Survive.registerEntityTemperatures(drinkId, (EntityTemperatureJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return VersionHelper.toLoc((String)"survive:entity_data");
    }
}

