/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.PotionJsonHolder;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionDrinkDataManager
implements IResourceReloadListener<Map<ResourceLocation, PotionJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, PotionJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, PotionJsonHolder> drinkMap = new HashMap<ResourceLocation, PotionJsonHolder>();
            for (Map.Entry resource : manager.m_214159_("survive_modifiers/consumables/potions", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation drinkId = VersionHelper.toLoc((String)((ResourceLocation)resource.getKey()).m_135827_(), (String)((ResourceLocation)resource.getKey()).m_135815_().replace("survive_modifiers/consumables/potions/", "").replace(".json", ""));
                if (ForgeRegistries.POTIONS.containsKey(drinkId)) {
                    try (InputStream stream = ((Resource)resource.getValue()).m_215507_();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        PotionJsonHolder drinkData = new PotionJsonHolder(drinkId, object);
                        Survive.getInstance().getLogger().info("Found potion drink data for " + drinkId);
                        drinkMap.put(drinkId, drinkData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading potion drink data " + drinkId + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such potion exists with the id " + drinkId + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, PotionJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation drinkId : data.keySet()) {
                Survive.registerDrinkDataForPotion(drinkId, (PotionJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return VersionHelper.toLoc((String)"survive:potion_data");
    }
}

