/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.crafting.PurifiedWaterCraftingRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class PurifiedWaterCraftingSerializer
implements RecipeSerializer<PurifiedWaterCraftingRecipe> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;

    public PurifiedWaterCraftingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
        NonNullList<Ingredient> nonnulllist = PurifiedWaterCraftingSerializer.add(PurifiedWaterCraftingSerializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredients")));
        CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > MAX_WIDTH * MAX_HEIGHT) {
            throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is " + MAX_WIDTH * MAX_HEIGHT);
        }
        ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
        return new PurifiedWaterCraftingRecipe(pRecipeId, s, craftingbookcategory, itemstack, PurifiedWaterCraftingSerializer.add(nonnulllist));
    }

    private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < pIngredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public PurifiedWaterCraftingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String s = pBuffer.m_130277_();
        CraftingBookCategory craftingbookcategory = (CraftingBookCategory)pBuffer.m_130066_(CraftingBookCategory.class);
        int i = pBuffer.m_130242_();
        NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
        for (int j = 0; j < nonnulllist.size(); ++j) {
            nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
        }
        ItemStack itemstack = pBuffer.m_130267_();
        return new PurifiedWaterCraftingRecipe(pRecipeId, s, craftingbookcategory, itemstack, PurifiedWaterCraftingSerializer.add((NonNullList<Ingredient>)nonnulllist));
    }

    public void toNetwork(FriendlyByteBuf pBuffer, PurifiedWaterCraftingRecipe pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        pBuffer.m_130068_((Enum)pRecipe.m_245232_());
        NonNullList<Ingredient> nonnulllist = PurifiedWaterCraftingSerializer.add((NonNullList<Ingredient>)pRecipe.m_7527_());
        pBuffer.m_130130_(nonnulllist.size());
        for (Ingredient ingredient : nonnulllist) {
            ingredient.m_43923_(pBuffer);
        }
        pBuffer.m_130055_(pRecipe.m_8043_(null));
    }

    protected static NonNullList<Ingredient> add(NonNullList<Ingredient> ing) {
        ItemStack potion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)SPotions.PURIFIED_WATER.holder().m_203334_()));
        if (((Ingredient)ing.get(ing.size() - 1)).test(potion)) {
            return ing;
        }
        NonNullList nonnulllist = NonNullList.m_122780_((int)(ing.size() + 1), (Object)Ingredient.f_43901_);
        for (int j = 0; j < ing.size(); ++j) {
            nonnulllist.set(j, (Object)((Ingredient)ing.get(j)));
        }
        nonnulllist.set(ing.size(), (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{potion}));
        return nonnulllist;
    }
}

