/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.world.level.block.entity.RealisticCampfireBlockEntity;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RealisticCampfireBlock
extends CampfireBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final IntegerProperty HEAT = IntegerProperty.m_61631_((String)"heat", (int)0, (int)4);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final int SMOKE_DISTANCE = 5;

    public RealisticCampfireBlock(boolean p_51236_, int p_51237_, BlockBehaviour.Properties p_51238_) {
        super(p_51236_, p_51237_, p_51238_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_51228_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_51229_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof RealisticCampfireBlockEntity) {
            RealisticCampfireBlockEntity campfireblockentity = (RealisticCampfireBlockEntity)blockentity;
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            Optional<CampfireCookingRecipe> optional = campfireblockentity.getCookableRecipe(itemstack);
            if (optional.isPresent()) {
                if (!pLevel.f_46443_ && campfireblockentity.placeFood((Entity)pPlayer, pPlayer.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack, optional.get().m_43753_())) {
                    pPlayer.m_36220_(Stats.f_12975_);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (AbstractFurnaceBlockEntity.m_58399_((ItemStack)itemstack)) {
                if (!pLevel.f_46443_ && campfireblockentity.placeFuel((LivingEntity)pPlayer, itemstack)) {
                    pPlayer.m_36220_(Stats.f_12975_);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if ((Integer)pState.m_61143_((Property)HEAT) > 0 && pEntity instanceof LivingEntity) {
            pEntity.m_6469_(pLevel.m_269111_().m_269387_(), (float)((Integer)pState.m_61143_((Property)HEAT)).intValue() * 0.25f);
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos;
        Level levelaccessor = pContext.m_43725_();
        boolean flag = levelaccessor.m_6425_(blockpos = pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_51229_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)f_51228_, (Comparable)Boolean.valueOf(this.m_51323_(levelaccessor.m_8055_(blockpos.m_7495_()))))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)f_51229_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return pFacing == Direction.DOWN ? (BlockState)pState.m_61124_((Property)f_51228_, (Comparable)Boolean.valueOf(this.m_51323_(pFacingState))) : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private boolean m_51323_(BlockState pState) {
        return pState.m_60713_(Blocks.f_50335_);
    }

    public static void m_152749_(@Nullable Entity pEntity, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity blockentity;
        if (pLevel.m_5776_()) {
            for (int i = 0; i < 20; ++i) {
                RealisticCampfireBlock.m_51251_((Level)pLevel, pPos, (Boolean)pState.m_61143_((Property)f_51228_), true);
            }
        }
        if ((blockentity = pLevel.m_7702_(pPos)) instanceof RealisticCampfireBlockEntity) {
            ((RealisticCampfireBlockEntity)blockentity).dowse();
        }
        pLevel.m_142346_(pEntity, GameEvent.f_157792_, pPos);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            boolean flag;
            boolean bl = flag = (Integer)pState.m_61143_((Property)HEAT) > 0;
            if (flag) {
                if (!pLevel.m_5776_()) {
                    pLevel.m_5594_(null, pPos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                RealisticCampfireBlock.m_152749_(null, pLevel, pPos, pState);
            }
            pLevel.m_7731_(pPos, (BlockState)((BlockState)((BlockState)pState.m_61124_((Property)f_51229_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEAT, (Comparable)Integer.valueOf(0)), 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos blockpos = pHit.m_82425_();
        if (!pLevel.f_46443_ && pProjectile.m_6060_() && pProjectile.m_142265_(pLevel, blockpos) && !((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && !((Boolean)pState.m_61143_((Property)f_51229_)).booleanValue()) {
            pLevel.m_7731_(blockpos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    public static void m_51251_(Level pLevel, BlockPos pPos, boolean pIsSignalFire, boolean pSpawnExtraSmoke) {
        RandomSource randomsource = pLevel.m_213780_();
        SimpleParticleType simpleparticletype = pIsSignalFire ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
        pLevel.m_6485_((ParticleOptions)simpleparticletype, true, (double)pPos.m_123341_() + 0.5 + randomsource.m_188500_() / 3.0 * (double)(randomsource.m_188499_() ? 1 : -1), (double)pPos.m_123342_() + randomsource.m_188500_() + randomsource.m_188500_(), (double)pPos.m_123343_() + 0.5 + randomsource.m_188500_() / 3.0 * (double)(randomsource.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
        if (pSpawnExtraSmoke) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pPos.m_123341_() + 0.5 + randomsource.m_188500_() / 4.0 * (double)(randomsource.m_188499_() ? 1 : -1), (double)pPos.m_123342_() + 0.4, (double)pPos.m_123343_() + 0.5 + randomsource.m_188500_() / 4.0 * (double)(randomsource.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT, f_51228_, f_51229_, FACING, HEAT});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RealisticCampfireBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.f_46443_) {
            return (Integer)pState.m_61143_((Property)HEAT) > 0 ? RealisticCampfireBlock.m_152132_(pBlockEntityType, SBlockEntityType.REALISIC_CAMPFIRE, RealisticCampfireBlockEntity::particleTick) : null;
        }
        return (Integer)pState.m_61143_((Property)HEAT) > 0 ? RealisticCampfireBlock.m_152132_(pBlockEntityType, SBlockEntityType.REALISIC_CAMPFIRE, RealisticCampfireBlockEntity::cookTick) : RealisticCampfireBlock.m_152132_(pBlockEntityType, SBlockEntityType.REALISIC_CAMPFIRE, RealisticCampfireBlockEntity::cooldownTick);
    }
}

