/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block.entity;

import com.stereowalker.survive.world.inventory.SaltBoxMenu;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.SaltBoxBlock;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SaltBoxBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level p_155062_, BlockPos p_155063_, BlockState p_155064_) {
            SaltBoxBlockEntity.this.playSound(p_155064_, SoundEvents.f_11725_);
            SaltBoxBlockEntity.this.updateBlockState(p_155064_, true);
        }

        protected void m_142289_(Level p_155072_, BlockPos p_155073_, BlockState p_155074_) {
            SaltBoxBlockEntity.this.playSound(p_155074_, SoundEvents.f_11724_);
            SaltBoxBlockEntity.this.updateBlockState(p_155074_, false);
        }

        protected void m_142148_(Level p_155066_, BlockPos p_155067_, BlockState p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean m_142718_(Player p_155060_) {
            if (p_155060_.f_36096_ instanceof SaltBoxMenu) {
                Container container = ((SaltBoxMenu)p_155060_.f_36096_).getContainer();
                return container == SaltBoxBlockEntity.this;
            }
            return false;
        }
    };
    long lastGameTickUpdated;
    int[] saltSludge = new int[27];
    private static final int COLS = 9;
    private static final int ROWS = 3;
    private static final int[][] OFFSETS = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};

    public SaltBoxBlockEntity(BlockPos pos, BlockState blockState) {
        super(SBlockEntityType.SALT_BOX, pos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
        tag.m_128356_("lastGameTickUpdated", this.lastGameTickUpdated);
        for (int i = 0; i < 27; ++i) {
            tag.m_128356_("sludge" + i, (long)this.saltSludge[i]);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
        this.lastGameTickUpdated = tag.m_128454_("lastGameTickUpdated");
        for (int i = 0; i < 27; ++i) {
            this.saltSludge[i] = tag.m_128451_("sludge" + i);
        }
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.barrel");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new SaltBoxMenu(id, player, (Container)this, this.data());
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void updateBlockState(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)SaltBoxBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)SaltBoxBlock.FACING)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public ContainerData data() {
        return new ContainerData(){

            public void m_8050_(int pIndex, int pValue) {
                SaltBoxBlockEntity.this.saltSludge[pIndex] = pValue;
            }

            public int m_6499_() {
                return SaltBoxBlockEntity.this.saltSludge.length;
            }

            public int m_6413_(int pIndex) {
                return SaltBoxBlockEntity.this.saltSludge[pIndex];
            }
        };
    }

    public void massivelyExtendLifespan() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41720_() != SItems.SEA_SALT || this.saltSludge[i] > 0) continue;
            this.saltSludge[i] = 1000;
            stack.m_41774_(1);
        }
        long gameTime = this.f_58857_.m_46467_();
        if (this.lastGameTickUpdated == 0L) {
            this.lastGameTickUpdated = gameTime;
        }
        long timeSinceLastOpened = gameTime - this.lastGameTickUpdated;
        this.lastGameTickUpdated = gameTime;
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (!SDataComponents.FOOD_STATUS_D.hasData(stack)) continue;
            int sidesCovered = 0;
            for (int n : SaltBoxBlockEntity.get8Neighbors(i)) {
                if (n < 0 || SDataComponents.FOOD_STATUS_D.hasData((ItemStack)this.items.get(n)) || this.saltSludge[n] <= 0) continue;
                ++sidesCovered;
                int n2 = n;
                this.saltSludge[n2] = this.saltSludge[n2] - 1;
            }
            if (sidesCovered <= 0) continue;
            float perc = 1.0E-4f * (float)sidesCovered + 0.9991f;
            float efficiency = (float)timeSinceLastOpened * perc;
            if (timeSinceLastOpened <= 2L) {
                efficiency = 1.0f;
            }
            float eff = efficiency;
            float salt = (float)timeSinceLastOpened * ((float)sidesCovered / 8.0f / 96.0f);
            SDataComponents.FOOD_STATUS_D.editData(stack, food_status -> food_status.extendTime(eff).increaseSalt(salt / 8.0f));
        }
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        System.out.println("Index " + pIndex);
        int[] saltSlots = new int[]{0, 8};
        super.m_6836_(pIndex, pStack);
    }

    public static int[] get8Neighbors(int index) {
        int[] neighbors = new int[8];
        if (index >= 0 && index < 27) {
            int row = index / 9;
            int col = index % 9;
            for (int i = 0; i < OFFSETS.length; ++i) {
                int dx = OFFSETS[i][0];
                int dy = OFFSETS[i][1];
                int nr = row + dy;
                int nc = col + dx;
                neighbors[i] = nr < 0 || nr >= 3 || nc < 0 || nc >= 9 ? -1 : nr * 9 + nc;
            }
        }
        return neighbors;
    }
}

