/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.compat.jei;

import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.helpers.IStackHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.compress.utils.Lists;

public final class CanteenFillingRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createRecipes(IStackHelper stackHelper, Item empty, Item filled, int amount) {
        String group = "survive.fill.canteen";
        return RegistryHelper.potions().holders().map(potion -> {
            ItemStack canteenStack = new ItemStack((ItemLike)empty);
            Ingredient canteenIngredient = Ingredient.of((ItemStack[])new ItemStack[]{canteenStack});
            ItemStack input = PotionContents.createItemStack((Item)Items.POTION, (Holder)potion);
            ItemStack output = CanteenItem.addToCanteen(new ItemStack((ItemLike)filled), amount, (Holder<Potion>)potion);
            Ingredient potionIngredient = Ingredient.of((ItemStack[])new ItemStack[]{input});
            ArrayList ingredients = Lists.newArrayList();
            ingredients.add(canteenIngredient);
            for (int i = 0; i <= amount; ++i) {
                ingredients.add(potionIngredient);
            }
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients.toArray(new Ingredient[0]));
            ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)("survive.fill" + amount + ".canteen." + output.getDescriptionId()));
            return new RecipeHolder(id, (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, output, inputs));
        }).toList();
    }

    private CanteenFillingRecipeMaker() {
    }
}

