/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.events;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.api.world.level.block.TemperatureEmitter;
import com.stereowalker.survive.compat.SereneSeasonsCompat;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.core.TempMode;
import com.stereowalker.survive.events.TempEvents;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.EntityTemperatureJsonHolder;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.survive.network.protocol.game.ClientboundDataTransferPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundSurvivalStatsPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundInteractWithWaterPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.item.enchantment.SEnchantmentHelper;
import com.stereowalker.survive.world.seasons.Season;
import com.stereowalker.survive.world.temperature.TemperatureModifier;
import com.stereowalker.survive.world.temperature.TemperatureQuery;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import com.stereowalker.unionlib.util.ModHelper;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.UnionMathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;

@Mod.EventBusSubscriber
public class SurviveEvents {
    private static final List<Offset> SPHERE_OFFSETS_RANGE_2 = SurviveEvents.buildSphereOffsets(2);
    private static final List<Offset> SPHERE_OFFSETS_RANGE_5 = SurviveEvents.buildSphereOffsets(5);
    private static final List<Offset> SPHERE_OFFSETS_RANGE_6 = SurviveEvents.buildSphereOffsets(6);

    public static void desyncClient(Player player) {
        if (!player.level().isClientSide && DataMaps.Server.syncedClients.containsKey(player.getUUID())) {
            Survive.getInstance().getLogger().info("Removing Client (" + player.getDisplayName().getString() + ") From Survive Data Sync List");
            DataMaps.Server.syncedClients.put(player.getUUID(), false);
        }
    }

    public static void sendToClient(LivingEntity living) {
        if (living != null && !living.level().isClientSide && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            new ClientboundSurvivalStatsPacket(player, true).send(player);
            new ClientboundSurvivalStatsPacket(player, false).send(player);
            if (!DataMaps.Server.syncedClients.containsKey(player.getUUID())) {
                DataMaps.Server.syncedClients.put(player.getUUID(), false);
            }
            if (!DataMaps.Server.syncedClients.get(player.getUUID()).booleanValue()) {
                Survive.getInstance().getLogger().info("Syncing All Data To Client (" + player.getDisplayName().getString() + ")");
                Survive.getInstance().getLogger().info("Syncing Armor Data");
                MutableInt a = new MutableInt(0);
                DataMaps.Server.armor.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((ResourceLocation)key, (JsonHolder)value, a.getValue() == 0).send(player);
                    a.increment();
                });
                Survive.getInstance().getLogger().info("Done with Armors");
                Survive.getInstance().getLogger().info("Syncing Fluid Data");
                MutableInt f = new MutableInt(0);
                DataMaps.Server.fluid.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((ResourceLocation)key, (JsonHolder)value, f.getValue() == 0).send(player);
                    f.increment();
                });
                Survive.getInstance().getLogger().info("Done with Fluids");
                Survive.getInstance().getLogger().info("Syncing Biome Data");
                MutableInt i = new MutableInt(0);
                DataMaps.Server.biome.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((ResourceLocation)key, (JsonHolder)value, i.getValue() == 0).send(player);
                    i.increment();
                });
                Survive.getInstance().getLogger().info("Done with Biomes");
                Survive.getInstance().getLogger().info("Syncing Consummable Data");
                MutableInt c = new MutableInt(0);
                DataMaps.Server.consummableItem.forEach((key, value) -> {
                    new ClientboundDataTransferPacket((ResourceLocation)key, (JsonHolder)value, c.getValue() == 0).send(player);
                    c.increment();
                });
                Survive.getInstance().getLogger().info("Done with Consummables");
                DataMaps.Server.syncedClients.put(player.getUUID(), true);
            }
        }
    }

    public static boolean isSnowingAt(Level world, BlockPos position) {
        if (!world.isRaining()) {
            return false;
        }
        if (!world.canSeeSky(position)) {
            return false;
        }
        if (world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, position).getY() > position.getY()) {
            return false;
        }
        Biome biome = (Biome)world.getBiome(position).value();
        return biome.getPrecipitationAt(position) == Biome.Precipitation.SNOW || biome.getTemperature(position) <= 0.15f || ModHelper.isPrimalWinterLoaded() || ModHelper.isSereneSeasonsLoaded() && SereneSeasonsCompat.snowsHere(world, position);
    }

    public static void updateEnvTemperature(LivingEntity living) {
        ServerPlayer player;
        if (living != null && living instanceof ServerPlayer) {
            player = (ServerPlayer)living;
            if (!living.level().isClientSide) {
                SurviveEntityStats.addWetTime((LivingEntity)player, player.isUnderWater() ? 2 : (player.isInWaterOrRain() ? 1 : -2));
            }
        }
        if (living != null && living instanceof ServerPlayer && (player = (ServerPlayer)living).isAlive()) {
            for (ResourceLocation queryId : TemperatureQuery.queries.keySet()) {
                double queryValue = ((TemperatureQuery)TemperatureQuery.queries.get(queryId).getA()).run((Player)player, ((IRealisticEntity)player).temperatureData().getTemperatureLevel(), player.level(), player.blockPosition(), true);
                TemperatureData.setTemperatureModifier((LivingEntity)player, queryId, queryValue, (TemperatureModifier.ContributingFactor)((Object)TemperatureQuery.queries.get(queryId).getB()));
            }
        }
        if (living instanceof Player) {
            player = (Player)living;
            FoodUtils.giveLifespanToFood((NonNullList<ItemStack>)player.getInventory().items, player.level().getGameTime());
            for (ChunkPos chunk : TempEvents.GLOBAL_BLOCK_TEMPS.keySet()) {
                if (player.level().hasChunk(chunk.x, chunk.z)) continue;
                TempEvents.discardChunk(chunk);
                TempEvents.log("Discarding Chunks " + String.valueOf(chunk));
            }
        }
    }

    public static float getModifierFromSlot(EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return 0.05f;
            }
            case CHEST: {
                return 0.16f;
            }
            case LEGS: {
                return 0.13f;
            }
            case FEET: {
                return 0.06f;
            }
        }
        return 0.0f;
    }

    private static List<BlockPos> getNeighbors(BlockPos pos) {
        return Lists.newArrayList((Object[])new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.west(), pos.east()});
    }

    private static double getBlockTransmissionCost(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!state.getFluidState().isEmpty() && !state.getFluidState().getTags().toList().contains(FluidTags.LAVA)) {
            return 1.2f;
        }
        if (state.isSolid()) {
            return 5.0;
        }
        return 1.0;
    }

    public static double getEffectiveDistance(Level level, BlockPos startPos, BlockPos target, double maxCost) {
        if (startPos.equals((Object)target)) {
            return 0.0;
        }
        PriorityQueue<PathNode> queue = new PriorityQueue<PathNode>(Comparator.comparingDouble(node -> node.cost));
        HashMap<BlockPos, Double> bestCosts = new HashMap<BlockPos, Double>();
        bestCosts.put(startPos, 0.0);
        queue.add(new PathNode(startPos, 0.0));
        while (!queue.isEmpty()) {
            PathNode current = queue.poll();
            if (current.pos.equals((Object)target)) {
                return current.cost;
            }
            if (current.cost > maxCost) continue;
            for (BlockPos neighbor : SurviveEvents.getNeighbors(current.pos)) {
                double costToEnter = SurviveEvents.getBlockTransmissionCost(level, neighbor);
                double newCost = current.cost + costToEnter;
                if (!(newCost < bestCosts.getOrDefault(neighbor, Double.POSITIVE_INFINITY))) continue;
                bestCosts.put(neighbor, newCost);
                queue.add(new PathNode(neighbor, newCost));
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    private static List<Offset> buildSphereOffsets(int rangeInBlocks) {
        ArrayList<Offset> finalList = new ArrayList<Offset>();
        for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
            for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                    if (x * x + y * y + z * z > rangeInBlocks * rangeInBlocks) continue;
                    finalList.add(new Offset(x, y, z));
                }
            }
        }
        return Collections.unmodifiableList(finalList);
    }

    public static double getExactTemperature(Level world, BlockPos pos, TempType type) {
        float skyLight = world.getChunkSource().getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(pos);
        float gameTime = world.getDayTime() % 24000L;
        gameTime /= 66.0f;
        gameTime = (float)Math.sin(Math.toRadians(gameTime));
        switch (type.ordinal()) {
            case 4: {
                float sunIntensity = 5.0f;
                if (world.getBiome(pos).unwrapKey().isPresent() && DataMaps.Server.biome.containsKey(((ResourceKey)world.getBiome(pos).unwrapKey().get()).location())) {
                    sunIntensity = DataMaps.Server.biome.get(((ResourceKey)world.getBiome(pos).unwrapKey().get()).location()).getSunIntensity();
                }
                if (skyLight > 5.0f) {
                    return gameTime * sunIntensity;
                }
                return -1.0f * sunIntensity;
            }
            case 0: {
                float biomeTemp = TemperatureUtil.getTemperature((Holder<Biome>)world.getBiome(pos), pos) * 2.0f - 2.0f;
                if (ModHelper.isPrimalWinterLoaded()) {
                    biomeTemp = -0.7f;
                }
                return biomeTemp;
            }
            case 1: {
                return TempEvents.tempOrCache(pos, SPHERE_OFFSETS_RANGE_2, SPHERE_OFFSETS_RANGE_5, offsets -> {
                    float totalBlockTemp = 0.0f;
                    int rangeInBlocks = 5;
                    for (Offset offset : offsets) {
                        float sourceRange;
                        float blockTemp = 0.0f;
                        BlockPos heatSource = new BlockPos(pos.getX() + offset.dx, pos.getY() + offset.dy, pos.getZ() + offset.dz);
                        float blockLight = world.getChunkSource().getLightEngine().getLayerListener(LightLayer.BLOCK).getLightValue(heatSource);
                        BlockState heatState = world.getBlockState(heatSource);
                        if (heatState.getBlock() instanceof TemperatureEmitter) {
                            sourceRange = ((TemperatureEmitter)heatState.getBlock()).getModificationRange(heatState);
                        } else {
                            float f = sourceRange = DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().getKey((Object)heatState.getBlock())) ? (float)DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().getKey((Object)heatState.getBlock())).getRange() : 5.0f;
                        }
                        if (!pos.closerThan((Vec3i)heatSource, (double)sourceRange)) continue;
                        blockTemp += blockLight / 500.0f;
                        if (heatState.getBlock() instanceof TemperatureEmitter) {
                            blockTemp = ((TemperatureEmitter)heatState.getBlock()).getTemperatureModification(heatState);
                        } else if (TempEvents.STATE_CACHE.containsKey(heatState)) {
                            blockTemp += TempEvents.STATE_CACHE.get(heatState).tempModifier();
                        }
                        boolean doDistanceCalculation = true;
                        if (doDistanceCalculation) {
                            double effectiveDistance = SurviveEvents.getEffectiveDistance(world, heatSource, pos, rangeInBlocks);
                            if (!(effectiveDistance <= (double)rangeInBlocks)) continue;
                            totalBlockTemp = (float)((double)totalBlockTemp + (double)blockTemp * (1.0 - effectiveDistance / (double)rangeInBlocks));
                            continue;
                        }
                        totalBlockTemp += blockTemp;
                    }
                    return Float.valueOf(totalBlockTemp);
                });
            }
            case 3: {
                return skyLight / 7.5f - 1.0f;
            }
            case 2: {
                float totalEntityTemp = 0.0f;
                int rangeInBlocks = 5;
                for (Entity entity : world.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks((BlockPos)pos.offset(rangeInBlocks, rangeInBlocks, rangeInBlocks), (BlockPos)pos.offset(-rangeInBlocks, -rangeInBlocks, -rangeInBlocks)))) {
                    float sourceRange;
                    float f = sourceRange = DataMaps.Server.entityTemperature.containsKey(RegistryHelper.entityTypes().getKey((Object)entity.getType())) ? DataMaps.Server.entityTemperature.get(RegistryHelper.entityTypes().getKey((Object)entity.getType())).getRange() : 5.0f;
                    if (!pos.closerThan((Vec3i)entity.blockPosition(), (double)sourceRange) || !DataMaps.Server.entityTemperature.containsKey(RegistryHelper.entityTypes().getKey((Object)entity.getType()))) continue;
                    EntityTemperatureJsonHolder entityTemperatureData = DataMaps.Server.entityTemperature.get(RegistryHelper.entityTypes().getKey((Object)entity.getType()));
                    totalEntityTemp += entityTemperatureData.getTemperatureModifier();
                }
                return totalEntityTemp;
            }
        }
        return 37.0;
    }

    public static double getBlendedTemperature(Level world, BlockPos mainPos, BlockPos blendPos, TempType type) {
        float distance = (float)Math.sqrt(mainPos.distSqr((Vec3i)blendPos));
        if ((double)distance <= 5.0) {
            float blendRatio0 = distance / 5.0f;
            float blendRatio1 = 1.0f - blendRatio0;
            double temp0 = SurviveEvents.getExactTemperature(world, blendPos, type);
            double temp1 = SurviveEvents.getExactTemperature(world, mainPos, type);
            return temp0 * (double)blendRatio0 + temp1 * (double)blendRatio1;
        }
        return SurviveEvents.getExactTemperature(world, mainPos, type);
    }

    public static float getAverageTemperature(Level world, BlockPos pos, TempType type, int rangeInBlocks, TempMode mode) {
        float temp = 0.0f;
        int tempAmount = 0;
        for (int x = -rangeInBlocks; x <= rangeInBlocks; ++x) {
            for (int y = -rangeInBlocks; y <= rangeInBlocks; ++y) {
                for (int z = -rangeInBlocks; z <= rangeInBlocks; ++z) {
                    if (mode == TempMode.BLEND) {
                        temp = (float)((double)temp + SurviveEvents.getBlendedTemperature(world, new BlockPos(pos.getX() + x, pos.getY() + y, pos.getZ() + z), pos, type));
                    } else if (mode == TempMode.NORMAL) {
                        temp = (float)((double)temp + SurviveEvents.getExactTemperature(world, new BlockPos(pos.getX() + x, pos.getY() + y, pos.getZ() + z), type));
                    }
                    ++tempAmount;
                }
            }
        }
        return temp / (float)tempAmount;
    }

    @SubscribeEvent
    public static void interactWithWaterSourceBlock(PlayerInteractEvent.RightClickEmpty event) {
        BlockHitResult raytraceresult = SurviveEvents.getPlayerPOVHitResult(event.getLevel(), event.getEntity(), ClipContext.Fluid.SOURCE_ONLY);
        BlockPos blockpos = raytraceresult.getBlockPos();
        if (event.getLevel().isClientSide && ServerboundInteractWithWaterPacket.isValidStack(event.getItemStack()) && event.getHand() == InteractionHand.MAIN_HAND) {
            Fluid fluid = event.getLevel().getFluidState(blockpos).getType();
            if (DataMaps.Client.fluid.containsKey((Object)RegistryHelper.fluids().getKey((Object)fluid))) {
                BiomeJsonHolder biomeData;
                FluidJsonHolder fluidHolder = (FluidJsonHolder)DataMaps.Client.fluid.get((Object)RegistryHelper.fluids().getKey((Object)fluid));
                float thirstChance = fluidHolder.getThirstChance();
                if (DataMaps.Client.biome.containsKey((Object)((ResourceKey)event.getLevel().getBiome(blockpos).unwrapKey().get()).location()) && (biomeData = (BiomeJsonHolder)DataMaps.Client.biome.get((Object)((ResourceKey)event.getLevel().getBiome(blockpos).unwrapKey().get()).location())).getThirstChance() >= 0.0f) {
                    thirstChance = biomeData.getThirstChance();
                }
                new ServerboundInteractWithWaterPacket(blockpos, thirstChance, fluidHolder.getThirstAmount(), fluidHolder.getHydrationAmount(), event.getHand()).send();
            }
            if (event.getLevel().isRainingAt(blockpos)) {
                new ServerboundInteractWithWaterPacket(event.getPos(), 0.0f, 1.0, 0.5, event.getHand()).send();
            }
        }
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level pLevel, Player pPlayer, ClipContext.Fluid pFluidMode) {
        Vec3 vec3 = pPlayer.getEyePosition();
        Vec3 vec31 = vec3.add(pPlayer.calculateViewVector(pPlayer.getXRot(), pPlayer.getYRot()).scale(pPlayer.blockInteractionRange()));
        return pLevel.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, pFluidMode, (Entity)pPlayer));
    }

    public static void restoreStats(Player thisPlayer, Player thatPlayer, boolean keepEverything) {
        SurviveEntityStats.getOrCreateModNBT((Entity)thisPlayer);
        if (keepEverything) {
            IRealisticEntity entity = (IRealisticEntity)thisPlayer;
            IRealisticEntity original = (IRealisticEntity)thatPlayer;
            entity.setTemperatureData(original.temperatureData());
            entity.setNutritionData(original.nutritionData());
            entity.setWellbeingData(original.wellbeingData());
            entity.setHygieneData(original.hygieneData());
            entity.setStaminaData(original.staminaData());
            entity.setSleepData(original.sleepData());
            entity.setWaterData(original.waterData());
            SurviveEntityStats.setWetTime((LivingEntity)thisPlayer, SurviveEntityStats.getWetTime((LivingEntity)thatPlayer));
        }
    }

    public static void addReload(LevelAccessor lvl) {
        TempEvents.buildStateCache();
        Survive.getInstance().getLogger().info("Start Resistering Temperature Queries");
        for (TempType type : TempType.values()) {
            TemperatureQuery.registerQuery("survive:" + type.getName(), TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
                double temperature = type.isUsingExact() ? SurviveEvents.getExactTemperature(level, pos, type) : (double)SurviveEvents.getAverageTemperature(level, pos, type, 5, Survive.TEMPERATURE_CONFIG.tempMode);
                return UnionMathHelper.roundDecimal((int)3, (double)(temperature / type.getReductionAmount()));
            });
        }
        TemperatureQuery.registerQuery("survive:snow", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            double snow = 0.0;
            if (SurviveEvents.isSnowingAt(level, pos)) {
                snow = -2.0;
            }
            return snow;
        });
        TemperatureQuery.registerQuery("survive:season", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            float seasonMod = 0.0f;
            if (ModHelper.isSereneSeasonsLoaded()) {
                Season season = SereneSeasonsCompat.modifyTemperatureBySeason(level, pos);
                seasonMod = level.getBiome(pos).unwrapKey().isPresent() && DataMaps.Server.biome.containsKey(((ResourceKey)level.getBiome(pos).unwrapKey().get()).location()) ? DataMaps.Server.biome.get(((ResourceKey)level.getBiome(pos).unwrapKey().get()).location()).getSeasonModifiers().get(season).floatValue() : season.getModifier();
                if (ModHelper.isPrimalWinterLoaded()) {
                    seasonMod = -1.0f;
                }
            }
            return seasonMod;
        });
        TemperatureQuery.registerQuery("survive:dimension", TemperatureModifier.ContributingFactor.ENVIRONMENTAL, (player, temp, level, pos, applyTemp) -> {
            for (String dimensionList : ServerConfig.dimensionModifiers) {
                String[] dimension = dimensionList.split(",");
                ResourceLocation loc = VersionHelper.toLoc((String)dimension[0]);
                if (!RegistryHelper.matchesRegistryKey((ResourceLocation)loc, (ResourceKey)level.dimension())) continue;
                return Float.parseFloat(dimension[1]);
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:wetness", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (level.getBiome(pos).unwrapKey().isPresent() && DataMaps.Server.biome.containsKey(((ResourceKey)level.getBiome(pos).unwrapKey().get()).location())) {
                float f = DataMaps.Server.biome.get(((ResourceKey)level.getBiome(pos).unwrapKey().get()).location()).getWetnessModifier();
                return (double)SurviveEntityStats.getWetTime((LivingEntity)player) / -1800.0 * (double)f;
            }
            return (double)SurviveEntityStats.getWetTime((LivingEntity)player) / -1800.0;
        });
        TemperatureQuery.registerQuery("survive:cooling_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double coolingMod = 0.0;
            coolingMod -= 0.05 * (double)SEnchantmentHelper.getCoolingModifier(player.getItemBySlot(EquipmentSlot.HEAD));
            coolingMod -= 0.16 * (double)SEnchantmentHelper.getCoolingModifier(player.getItemBySlot(EquipmentSlot.CHEST));
            coolingMod -= 0.13 * (double)SEnchantmentHelper.getCoolingModifier(player.getItemBySlot(EquipmentSlot.LEGS));
            return coolingMod -= 0.06 * (double)SEnchantmentHelper.getCoolingModifier(player.getItemBySlot(EquipmentSlot.FEET));
        });
        TemperatureQuery.registerQuery("survive:warming_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double warmingMod = 0.0;
            warmingMod += 0.05 * (double)SEnchantmentHelper.getWarmingModifier(player.getItemBySlot(EquipmentSlot.HEAD));
            warmingMod += 0.16 * (double)SEnchantmentHelper.getWarmingModifier(player.getItemBySlot(EquipmentSlot.CHEST));
            warmingMod += 0.13 * (double)SEnchantmentHelper.getWarmingModifier(player.getItemBySlot(EquipmentSlot.LEGS));
            return warmingMod += 0.06 * (double)SEnchantmentHelper.getWarmingModifier(player.getItemBySlot(EquipmentSlot.FEET));
        });
        TemperatureQuery.registerQuery("survive:thirst_cooldown", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (((IRealisticEntity)player).waterData().shouldTempDrop()) {
                if (applyTemp) {
                    ((IRealisticEntity)player).waterData().applyTempDrop(player);
                }
                return 1.0;
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:adjusted_cooling_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (temp > 37.0) {
                for (EquipmentSlot types : EquipmentSlot.values()) {
                    if (!SEnchantmentHelper.hasAdjustedCooling(player.getItemBySlot(types))) continue;
                    return 2.0;
                }
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:adjusted_warming_enchantment", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (temp < 37.0) {
                for (EquipmentSlot types : EquipmentSlot.values()) {
                    if (!SEnchantmentHelper.hasAdjustedWarming(player.getItemBySlot(types))) continue;
                    return 2.0;
                }
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:fats", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            IRealisticEntity real = (IRealisticEntity)player;
            if (Survive.CONFIG.nutrition_enabled && temp < (37.0 + TemperatureUtil.firstCold(player)) / 2.0) {
                if (real.nutritionData().fat().level() > 2500) {
                    real.nutritionData().fat().remove(3);
                    return 6.0;
                }
                if (real.nutritionData().fat().level() > 1500) {
                    real.nutritionData().fat().remove(2);
                    return 3.0;
                }
                if (real.nutritionData().fat().level() > 500) {
                    real.nutritionData().fat().remove(1);
                    return 1.0;
                }
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:armor", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            double armorMod = 0.0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || player.getItemBySlot(slot).isEmpty()) continue;
                Item armor = player.getItemBySlot(slot).getItem();
                float modifier = 1.0f;
                if (DataMaps.Server.armor.containsKey(RegistryHelper.items().getKey((Object)armor))) {
                    for (Pair<String, TemperatureChangeInstance> instance : DataMaps.Server.armor.get(RegistryHelper.items().getKey((Object)armor)).getTemperatureModifier()) {
                        if (!((TemperatureChangeInstance)instance.getSecond()).shouldChangeTemperature(player)) continue;
                        modifier = ((TemperatureChangeInstance)instance.getSecond()).getTemperature();
                        break;
                    }
                }
                armorMod += (double)(SurviveEvents.getModifierFromSlot(slot) * modifier);
            }
            return armorMod;
        });
        TemperatureQuery.registerQuery("survive:chilled_effect", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.hasEffect(SMobEffects.CHILLED.holder())) {
                return -(0.05f * (float)(player.getEffect(SMobEffects.CHILLED.holder()).getAmplifier() + 1));
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:heated_effect", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.hasEffect(SMobEffects.HEATED.holder())) {
                return 0.05f * (float)(player.getEffect(SMobEffects.HEATED.holder()).getAmplifier() + 1);
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:main_held_item", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.getMainHandItem().getItem() == Items.TORCH && DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().getKey((Object)Blocks.TORCH))) {
                return DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().getKey((Object)Blocks.TORCH)).getTemperatureModifier();
            }
            return 0.0;
        });
        TemperatureQuery.registerQuery("survive:off_held_item", TemperatureModifier.ContributingFactor.INTERNAL, (player, temp, level, pos, applyTemp) -> {
            if (player.getOffhandItem().getItem() == Items.TORCH && DataMaps.Server.blockTemperature.containsKey(RegistryHelper.blocks().getKey((Object)Blocks.TORCH))) {
                return DataMaps.Server.blockTemperature.get(RegistryHelper.blocks().getKey((Object)Blocks.TORCH)).getTemperatureModifier();
            }
            return 0.0;
        });
        System.out.println("Done Resistering Temperature Queries");
    }

    private record PathNode(BlockPos pos, double cost) {
    }

    private record Offset(int dx, int dy, int dz) {
    }

    private static enum TempType {
        BIOME("biome", 6.0, false),
        BLOCK("block", 8.0, true),
        ENTITY("entity", 9.0, true),
        SHADE("shade", 200.0, true),
        SUN("sun", 200.0, true);

        String name;
        double reductionAmount;
        boolean usingExact;

        private TempType(String name, double reductionAmountIn, boolean usingExactIn) {
            this.reductionAmount = reductionAmountIn;
            this.usingExact = usingExactIn;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public double getReductionAmount() {
            return this.reductionAmount;
        }

        public boolean isUsingExact() {
            return this.usingExact;
        }
    }
}

