/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.gson.JsonObject;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FluidJsonHolder
implements JsonHolder {
    private static final Marker DRINK_DATA = MarkerManager.getMarker((String)"FLUID");
    private ResourceLocation itemID;
    private int thirstAmount = 0;
    private float hydrationAmount = 0.0f;
    private float thirstChance = 0.0f;
    String wo = "NOTHING";

    public FluidJsonHolder(CompoundTag nbt) {
        this.itemID = VersionHelper.toLoc((String)nbt.getString("id"));
        this.thirstAmount = nbt.getInt("thirst_amount");
        this.hydrationAmount = nbt.getFloat("hydration_amount");
        this.thirstChance = nbt.getFloat("thirst_chance");
    }

    public FluidJsonHolder(ResourceLocation itemID, JsonObject object) {
        String THIRST = "thirst";
        String THIRSTY = "thirst_chance";
        this.itemID = itemID;
        if (object.entrySet().size() != 0) {
            this.stopWorking();
            try {
                if (this.hasMemberAndIsPrimitive(THIRST, object)) {
                    this.setWorkingOn(THIRST);
                    this.thirstAmount = object.get(THIRST).getAsInt();
                    this.stopWorking();
                }
                if (this.hasMemberAndIsPrimitive("hydration", object)) {
                    this.hydrationAmount = this.workOnFloat("hydration", object);
                }
                if (this.hasMemberAndIsPrimitive(THIRSTY, object)) {
                    this.setWorkingOn(THIRSTY);
                    this.thirstChance = object.get(THIRSTY).getAsFloat();
                    this.stopWorking();
                }
            }
            catch (ClassCastException e) {
                Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading fluid data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
            }
            catch (NumberFormatException e) {
                Survive.getInstance().getLogger().warn(DRINK_DATA, "Loading fluid data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)itemID, (Object)this.getworkingOn());
            }
        }
    }

    public ResourceLocation getItemID() {
        return this.itemID;
    }

    public int getThirstAmount() {
        return this.thirstAmount;
    }

    public float getHydrationAmount() {
        return this.hydrationAmount;
    }

    public float getThirstChance() {
        return this.thirstChance;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("id", this.itemID.toString());
        nbt.putInt("thirst_amount", this.thirstAmount);
        nbt.putFloat("hydration_amount", this.hydrationAmount);
        nbt.putFloat("thirst_chance", this.thirstChance);
        return nbt;
    }

    @Override
    public FluidJsonHolder deserialize(CompoundTag input) {
        return new FluidJsonHolder(input);
    }

    @Override
    public String getworkingOn() {
        return this.wo;
    }

    @Override
    public void setWorkingOn(String member) {
        this.wo = member;
    }
}

