/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.world.effect.SMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;

public class CustomFoodData
extends FoodData {
    int uncleanConsumption = 0;
    boolean causeAche = false;
    boolean wellFed = false;
    FoodUtils.State isSpoiled = FoodUtils.State.Okay;

    public CustomFoodData(FoodData originalFoodData) {
        this.foodLevel = originalFoodData.foodLevel;
        this.setSaturation(originalFoodData.getSaturationLevel());
        this.setExhaustion(originalFoodData.getExhaustionLevel());
        this.tickTimer = originalFoodData.tickTimer;
    }

    public void eat(int pFoodLevelModifier, float pSaturationLevelModifier) {
        int foodLevel = this.foodLevel;
        float satMod = 1.0f;
        if (this.IsSpoiled() == FoodUtils.State.Spoiled) {
            pFoodLevelModifier /= 2;
        }
        if (this.IsSpoiled() == FoodUtils.State.Fresh) {
            satMod = 1.5f;
        } else if (this.IsSpoiled() == FoodUtils.State.Good) {
            satMod = 1.1f;
        } else if (this.IsSpoiled() == FoodUtils.State.Spoiling) {
            satMod = 0.9f;
        } else if (this.IsSpoiled() == FoodUtils.State.Spoiled) {
            satMod = 0.5f;
        }
        super.eat(pFoodLevelModifier, pSaturationLevelModifier * satMod);
        int capacity = 20;
        if (ServerConfig.stomachCapacity == StomachCapacity.DOUBLED) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == StomachCapacity.LIMITED && this.foodLevel < 20) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == StomachCapacity.LIMITED && this.foodLevel >= 20) {
            capacity = this.foodLevel;
        }
        if (ServerConfig.stomachCapacity != StomachCapacity.VANILLA) {
            this.foodLevel = Math.min(pFoodLevelModifier + foodLevel, capacity);
            if (this.foodLevel == 20 && foodLevel < 20) {
                this.wellFed = true;
            } else {
                this.causeAche = this.foodLevel > 20 && foodLevel < 20 && pFoodLevelModifier / 2 < this.foodLevel - 20 ? true : this.foodLevel > 20 && foodLevel >= 20;
            }
        }
    }

    public void consumeUnclean() {
        ++this.uncleanConsumption;
    }

    public void markAsSpoiled(ItemStack stack, LivingEntity living) {
        this.isSpoiled = FoodUtils.foodStatus(stack, living.level());
        if (this.IsSpoiled() == FoodUtils.State.Spoiled) {
            living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 1200));
            living.addEffect(new MobEffectInstance(MobEffects.HUNGER, 1200));
        }
    }

    public void tick(Player pPlayer) {
        Difficulty difficulty = pPlayer.level().getDifficulty();
        if (this.wellFed) {
            if (this.foodLevel == 20) {
                pPlayer.addEffect(new MobEffectInstance(SMobEffects.WELL_FED.holder(), 300, 0));
            } else {
                this.wellFed = false;
            }
        }
        if (ServerConfig.stomachCapacity != StomachCapacity.VANILLA) {
            int amplifier = -1;
            int duration = 210;
            if (this.foodLevel > 36) {
                amplifier = 4;
            } else if (this.foodLevel > 32) {
                amplifier = 3;
            } else if (this.foodLevel > 28) {
                amplifier = 2;
            } else if (this.foodLevel > 24) {
                amplifier = 1;
            } else if (this.foodLevel > 20) {
                amplifier = 0;
            }
            MobEffectInstance upsetStomach = pPlayer.getEffect(SMobEffects.UPSET_STOMACH.holder());
            if (!(pPlayer.isSpectator() || pPlayer.isCreative() || amplifier <= 0 || upsetStomach != null && upsetStomach.getDuration() > 210 && upsetStomach.getAmplifier() >= amplifier)) {
                pPlayer.addEffect(new MobEffectInstance(SMobEffects.UPSET_STOMACH.holder(), duration, amplifier));
            }
        }
        if (Survive.WELLBEING_CONFIG.enabled && this.uncleanConsumption >= 3) {
            ((IRealisticEntity)pPlayer).wellbeingData().setTimer(2400, 6000, "eating bad food");
            this.uncleanConsumption = 0;
        }
        if (this.foodLevel >= 40 && (pPlayer.getHealth() > 10.0f || difficulty == Difficulty.HARD || pPlayer.getHealth() > 1.0f && difficulty == Difficulty.NORMAL)) {
            int tickTimer2 = this.tickTimer;
            this.tickTimer = 0;
            super.tick(pPlayer);
            this.tickTimer = tickTimer2 + 1;
            if (this.tickTimer >= 10) {
                pPlayer.hurt(SDamageSources.source(pPlayer.level().registryAccess(), SDamageTypes.OVEREAT), 1.0f);
                this.tickTimer = 0;
            }
        } else {
            super.tick(pPlayer);
        }
    }

    public boolean canConsumeFood() {
        switch (ServerConfig.stomachCapacity.ordinal()) {
            case 2: {
                return this.needsFood();
            }
            case 1: {
                return this.needsFood();
            }
            case 0: {
                return this.foodLevel < 40;
            }
        }
        return this.needsFood();
    }

    public void readAdditionalSaveData(CompoundTag pCompoundTag) {
        super.readAdditionalSaveData(pCompoundTag);
        if (pCompoundTag.contains("foodLevel", 99)) {
            this.uncleanConsumption = pCompoundTag.getInt("foodUncleanConsumption");
            this.causeAche = pCompoundTag.getBoolean("foodCauseAche");
            this.wellFed = pCompoundTag.getBoolean("foodWellFed");
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompoundTag) {
        super.addAdditionalSaveData(pCompoundTag);
        pCompoundTag.putFloat("foodUncleanConsumption", (float)this.uncleanConsumption);
        pCompoundTag.putBoolean("foodCauseAche", this.causeAche);
        pCompoundTag.putBoolean("foodWellFed", this.wellFed);
    }

    public FoodUtils.State IsSpoiled() {
        return this.isSpoiled;
    }

    public static enum StomachCapacity {
        DOUBLED,
        LIMITED,
        VANILLA;

    }
}

