/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeDataManager
implements IResourceReloadListener<Map<ResourceLocation, BiomeJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, BiomeJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, BiomeJsonHolder> drinkMap = new HashMap<ResourceLocation, BiomeJsonHolder>();
            for (Map.Entry resource : manager.listResources("survive_modifiers/biomes", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation blockId = VersionHelper.toLoc((String)((ResourceLocation)resource.getKey()).getNamespace(), (String)((ResourceLocation)resource.getKey()).getPath().replace("survive_modifiers/biomes/", "").replace(".json", ""));
                if (!ForgeRegistries.BIOMES.containsKey(blockId)) {
                    Survive.getInstance().getLogger().warn("Did not find biome " + String.valueOf(blockId) + " in the forge registry. This is a temporary warning and will be removed after the fabric release");
                }
                try {
                    InputStream stream = ((Resource)resource.getValue()).open();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        BiomeJsonHolder biomeData = new BiomeJsonHolder(blockId, object);
                        drinkMap.put(blockId, biomeData);
                        Survive.getInstance().getLogger().info("Registered modifier for the biome \"" + String.valueOf(blockId) + "\"");
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    Survive.getInstance().getLogger().warn("Error reading the biomes temperature modifier for the biome " + String.valueOf(blockId) + "!", (Throwable)e);
                }
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, BiomeJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation drinkId : data.keySet()) {
                Survive.registerBiomeTemperatures(drinkId, (BiomeJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return VersionHelper.toLoc((String)"survive:biome_data");
    }
}

