/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.material;

import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.material.SFluids;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public abstract class PurifiedWaterFluid
extends FlowingFluid {
    public Fluid getFlowing() {
        return SFluids.FLOWING_PURIFIED_WATER;
    }

    public Fluid getSource() {
        return SFluids.PURIFIED_WATER;
    }

    public Item getBucket() {
        return SItems.PURIFIED_WATER_BUCKET;
    }

    public void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource pRandom) {
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
            if (pRandom.nextInt(64) == 0) {
                worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, pRandom.nextFloat() * 0.25f + 0.75f, pRandom.nextFloat() + 0.5f, false);
            }
        } else if (pRandom.nextInt(10) == 0) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)pos.getX() + pRandom.nextDouble(), (double)pos.getY() + pRandom.nextDouble(), (double)pos.getZ() + pRandom.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    protected boolean canConvertToSource(Level level) {
        return level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
    }

    protected void beforeDestroyingBlock(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = state.hasBlockEntity() ? worldIn.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
    }

    public int getSlopeFindDistance(LevelReader worldIn) {
        return 4;
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)SBlocks.PURIFIED_WATER.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(PurifiedWaterFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(Fluid fluidIn) {
        return fluidIn == SFluids.PURIFIED_WATER || fluidIn == SFluids.FLOWING_PURIFIED_WATER;
    }

    public int getDropOff(LevelReader worldIn) {
        return 1;
    }

    public int getTickDelay(LevelReader p_205569_1_) {
        return 5;
    }

    public boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.is(FluidTags.WATER);
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public static class Source
    extends PurifiedWaterFluid {
        public int getAmount(FluidState p_207192_1_) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends PurifiedWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState p_207192_1_) {
            return (Integer)p_207192_1_.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

